/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.wand;

import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.WandMode;
import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class WandOrganizer {
    private final Wand wand;
    private final Mage mage;
    protected static final int inventoryOrganizeSize = 22;
    protected static final int inventoryOrganizeNewGroupSize = 16;
    protected static final int favoriteCastCountThreshold = 20;
    private int currentInventoryIndex = 0;
    private int currentInventoryCount = 0;
    private Inventory currentInventory = null;
    private boolean addToHotbar = true;

    public WandOrganizer(Wand wand, Mage mage) {
        this.wand = wand;
        this.mage = mage;
        this.addToHotbar = wand.getMode() == WandMode.INVENTORY;
    }

    protected void nextInventory() {
        ++this.currentInventoryIndex;
        this.currentInventoryCount = 0;
        this.currentInventory = this.wand.getInventoryByIndex(this.currentInventoryIndex);
    }

    protected void addToInventory(ItemStack itemStack) {
        HashMap result;
        if (this.addToHotbar) {
            this.addToHotbar = false;
            Inventory hotbar = this.wand.getHotbar();
            int emptyCount = 0;
            int i = 8;
            while (i >= 0) {
                ItemStack hotbarItem = hotbar.getItem(i);
                if ((hotbarItem == null || hotbarItem.getType() == Material.AIR) && ++emptyCount > 1) {
                    this.addToHotbar = true;
                    hotbar.setItem(i, itemStack);
                    break;
                }
                --i;
            }
        }
        if (this.currentInventoryCount > 22) {
            this.nextInventory();
        }
        if ((result = this.currentInventory.addItem(new ItemStack[]{itemStack})).size() > 0) {
            this.nextInventory();
            for (ItemStack skipped : result.values()) {
                this.currentInventory.addItem(new ItemStack[]{skipped});
                ++this.currentInventoryCount;
            }
        } else {
            ++this.currentInventoryCount;
        }
    }

    public void organize() {
        HashSet<String> hotbarSpellNames = new HashSet<String>();
        HashSet<String> hotbarMaterialNames = new HashSet<String>();
        Inventory hotbar = this.wand.getHotbar();
        int hotbarSize = 9;
        int i = 0;
        while (i < hotbarSize) {
            ItemStack hotbarItem = hotbar.getItem(i);
            if (hotbarItem != null && hotbarItem.getType() != Material.AIR) {
                String spellName = Wand.getSpell(hotbarItem);
                if (spellName != null) {
                    hotbarSpellNames.add(spellName);
                } else {
                    String materialKey = Wand.getMaterialKey(hotbarItem);
                    if (materialKey != null) {
                        hotbarMaterialNames.add(materialKey);
                    }
                }
            }
            ++i;
        }
        MagicController master = this.wand.getMaster();
        TreeMap favoriteSpells = new TreeMap();
        TreeMap<String, TreeSet<String>> groupedSpells = new TreeMap<String, TreeSet<String>>();
        Set<String> spells = this.wand.getSpells();
        for (String spellName : spells) {
            TreeSet<String> spellList;
            Object spell;
            Object object = spell = this.mage == null ? master.getSpell(spellName) : this.mage.getSpell(spellName);
            if (spell == null || hotbarSpellNames.contains(spellName)) continue;
            long castCount = ((Spell)spell).getCastCount();
            if (castCount > 20L) {
                List<String> favorites = null;
                if (!favoriteSpells.containsKey(castCount)) {
                    favorites = new ArrayList();
                    favoriteSpells.put(castCount, favorites);
                } else {
                    favorites = (List)favoriteSpells.get(castCount);
                }
                favorites.add(spellName);
                spell = null;
            }
            if (spell == null) continue;
            String category = ((Spell)spell).getCategory();
            if (category == null || category.length() == 0) {
                category = "default";
            }
            if ((spellList = (TreeSet<String>)groupedSpells.get(category)) == null) {
                spellList = new TreeSet<String>();
                groupedSpells.put(category, spellList);
            }
            spellList.add(spellName);
        }
        Set<String> wandMaterials = this.wand.getMaterialKeys();
        for (String hotbarItemName : hotbarMaterialNames) {
            wandMaterials.remove(hotbarItemName);
        }
        TreeMap<String, String> materials = new TreeMap<String, String>();
        for (String materialKey : wandMaterials) {
            if (Wand.isSpecialMaterialKey(materialKey)) {
                materials.put(" " + materialKey, materialKey);
                continue;
            }
            materials.put(materialKey, materialKey);
        }
        this.wand.clearInventories();
        this.currentInventoryIndex = 0;
        this.currentInventoryCount = 0;
        this.currentInventory = this.wand.getInventoryByIndex(this.currentInventoryIndex);
        for (List favorites : favoriteSpells.descendingMap().values()) {
            for (String spellName : favorites) {
                this.addToInventory(this.wand.createSpellItem(spellName));
            }
        }
        for (Collection spellGroup : groupedSpells.values()) {
            if (this.currentInventoryCount > 16) {
                this.nextInventory();
            }
            for (String spellName : spellGroup) {
                this.addToInventory(this.wand.createSpellItem(spellName));
            }
        }
        if (materials.size() > 0) {
            this.nextInventory();
            for (String materialName : materials.values()) {
                this.addToInventory(this.wand.createMaterialItem(materialName));
            }
        }
    }
}

