/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class TossSpell
extends BrushSpell {
    public SpellResult onCast(ConfigurationNode parameters) {
        Location location = this.getPlayer().getLocation();
        if (!this.hasBuildPermission(location.getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        location.setY(location.getY() - 1.0);
        MaterialBrush buildWith = this.getMaterialBrush();
        buildWith.setTarget(location);
        Material material = buildWith.getMaterial();
        byte data = buildWith.getData();
        int tossCount = 1;
        tossCount = parameters.getInt("count", tossCount);
        tossCount = (int)(this.mage.getRadiusMultiplier() * (float)tossCount);
        float speed = 0.6f;
        speed = (float)parameters.getDouble("speed", speed);
        Vector direction = this.getPlayer().getLocation().getDirection();
        direction.normalize().multiply(speed);
        Vector up = new Vector(0, 1, 0);
        Vector perp = new Vector();
        perp.copy(direction);
        perp.crossProduct(up);
        int i = 0;
        while (i < tossCount) {
            FallingBlock block = null;
            location = this.getPlayer().getEyeLocation();
            location.setX(location.getX() + perp.getX() * (Math.random() * (double)tossCount / 4.0 - (double)(tossCount / 8)));
            location.setY(location.getY());
            location.setZ(location.getZ() + perp.getZ() * (Math.random() * (double)tossCount / 4.0 - (double)(tossCount / 8)));
            block = this.getPlayer().getWorld().spawnFallingBlock(location, material, data);
            if (block == null) {
                this.sendMessage("One of your blocks fizzled");
                return SpellResult.FAIL;
            }
            block.setDropItem(false);
            block.setVelocity(direction);
            ++i;
        }
        this.castMessage("You toss some blocks");
        return SpellResult.CAST;
    }
}

