/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.NMSUtils;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectileSpell
extends Spell {
    private int defaultSize = 1;

    @Override
    public SpellResult onCast(ConfigurationNode parameters) {
        if (!this.mage.hasBuildPermission(this.getPlayer().getLocation().getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Player player = this.getPlayer();
        if (player == null) {
            return SpellResult.PLAYER_REQUIRED;
        }
        int count = parameters.getInt("count", 1);
        int size = parameters.getInt("size", this.defaultSize);
        int radius = parameters.getInt("radius", 0);
        double damage = parameters.getDouble("damage", 0.0);
        float speed = (float)parameters.getDouble("speed", 0.6f);
        float spread = (float)parameters.getDouble("spread", 12.0);
        Collection<PotionEffect> effects = null;
        if (radius > 0) {
            effects = ProjectileSpell.getPotionEffects(parameters);
            radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        }
        count = (int)((float)count * this.mage.getRadiusMultiplier());
        size = (int)(this.mage.getRadiusMultiplier() * (float)size);
        float damageMultiplier = this.mage.getDamageMultiplier();
        speed *= damageMultiplier;
        damage *= (double)damageMultiplier;
        spread /= damageMultiplier;
        boolean useFire = parameters.getBoolean("fire", true);
        int tickIncrease = parameters.getInteger("tick_increase", 1180);
        String projectileClass = parameters.getString("projectile", "Fireball");
        Class arrowClass = NMSUtils.getBukkitClass("net.minecraft.server.EntityArrow");
        Class craftArrowClass = NMSUtils.getBukkitClass("org.bukkit.craftbukkit.entity.CraftArrow");
        ArrayList<Projectile> projectiles = new ArrayList<Projectile>();
        Class<?> projectileType = null;
        try {
            projectileType = Class.forName("org.bukkit.entity." + projectileClass);
        }
        catch (Exception ex) {
            this.castMessage("Your projectile fizzled");
            this.controller.getLogger().warning(ex.getMessage());
            return SpellResult.FAIL;
        }
        Location location = this.mage.getLocation();
        Vector direction = this.mage.getDirection();
        int i = 0;
        while (i < count) {
            block19: {
                try {
                    Projectile projectile = null;
                    if (projectileType == Arrow.class) {
                        Location arrowLocation = location.clone();
                        arrowLocation.setX(arrowLocation.getX() + direction.getX() * (1.0 + Math.random() * (double)count));
                        arrowLocation.setY(arrowLocation.getY() + 1.5);
                        arrowLocation.setZ(arrowLocation.getZ() + direction.getZ() * (1.0 + Math.random() * (double)count));
                        projectile = player.getWorld().spawnArrow(arrowLocation, direction, speed, spread);
                        projectile.setShooter((LivingEntity)player);
                    } else {
                        projectile = player.launchProjectile(projectileType);
                    }
                    if (projectile == null) {
                        throw new Exception("A projectile fizzled");
                    }
                    projectiles.add(projectile);
                    projectile.setShooter((LivingEntity)this.getPlayer());
                    if (projectile instanceof Fireball) {
                        Fireball fireball = (Fireball)projectile;
                        fireball.setIsIncendiary(useFire);
                        fireball.setYield((float)size);
                    }
                    if (!(projectile instanceof Arrow)) break block19;
                    Arrow arrow = (Arrow)projectile;
                    if (useFire) {
                        arrow.setFireTicks(300);
                    }
                    try {
                        if (arrowClass == null || craftArrowClass == null) {
                            this.controller.getLogger().warning("Can not access NMS EntityArrow class");
                        } else {
                            Method getHandleMethod = arrow.getClass().getMethod("getHandle", new Class[0]);
                            Object handle = getHandleMethod.invoke((Object)arrow, new Object[0]);
                            Field fromPlayerField = arrowClass.getField("fromPlayer");
                            fromPlayerField.setInt(handle, 2);
                            if (damage > 0.0) {
                                Field damageField = arrowClass.getDeclaredField("damage");
                                damageField.setAccessible(true);
                                damageField.set(handle, damage);
                            }
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++i;
        }
        if (tickIncrease > 0 && projectiles.size() > 0 && arrowClass != null) {
            this.scheduleProjectileCheck(projectiles, tickIncrease, effects, radius, arrowClass, craftArrowClass, 5);
        }
        return SpellResult.CAST;
    }

    protected void scheduleProjectileCheck(final Collection<Projectile> projectiles, final int tickIncrease, final Collection<PotionEffect> effects, final int radius, final Class<?> arrowClass, final Class<?> craftArrowClass, final int retries) {
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), new Runnable(){

            public void run() {
                ProjectileSpell.this.checkProjectiles(projectiles, tickIncrease, effects, radius, arrowClass, craftArrowClass, retries);
            }
        }, 40L);
    }

    protected void checkProjectiles(Collection<Projectile> projectiles, int tickIncrease, Collection<PotionEffect> effects, int radius, Class<?> arrowClass, Class<?> craftArrowClass, int retries) {
        try {
            Field lifeField = arrowClass.getDeclaredField("j");
            Method getHandleMethod = craftArrowClass.getMethod("getHandle", new Class[0]);
            ArrayList<Projectile> remaining = new ArrayList<Projectile>();
            for (Projectile projectile : projectiles) {
                if (projectile.isDead()) {
                    this.applyPotionEffects(projectile.getLocation(), radius, effects);
                    continue;
                }
                if (!(projectile instanceof Arrow)) continue;
                Object handle = getHandleMethod.invoke((Object)projectile, new Object[0]);
                lifeField.setAccessible(true);
                int currentLife = (Integer)lifeField.get(handle);
                if (currentLife < tickIncrease) {
                    lifeField.set(handle, tickIncrease);
                }
                remaining.add(projectile);
            }
            if (remaining.size() > 0 && retries > 0) {
                this.scheduleProjectileCheck(remaining, tickIncrease, effects, radius, arrowClass, craftArrowClass, retries - 1);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

