/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.effects.EffectUtils;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.lang.reflect.Field;
import java.util.Random;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.block.Block;

public class FireworkSpell
extends Spell {
    public SpellResult onCast(ConfigurationNode parameters) {
        Random rand = new Random();
        int power = rand.nextInt(2) + 1;
        Color color1 = null;
        Color color2 = null;
        FireworkEffect.Type fireworkType = null;
        Boolean flicker = null;
        Boolean trail = null;
        power = parameters.getInt("size", power);
        if (parameters.containsKey("color1")) {
            color1 = this.getColor(parameters.getString("color1"));
        } else if (this.mage.getEffectColor() != null) {
            color1 = this.mage.getEffectColor();
        }
        if (parameters.containsKey("color2")) {
            color2 = this.getColor(parameters.getString("color2"));
        }
        if (parameters.containsKey("type")) {
            fireworkType = this.getType(parameters.getString("type"));
        }
        flicker = parameters.getBoolean("flicker", flicker);
        trail = parameters.getBoolean("trail", trail);
        int flareCount = parameters.getInt("count", 1);
        Block target = this.getTarget().getBlock();
        FireworkEffect effect = this.mage.getFireworkEffect(color1, color2, fireworkType, flicker, trail);
        int i = 0;
        while (i < flareCount) {
            EffectUtils.spawnFireworkEffect(target.getLocation(), effect, power);
            ++i;
        }
        this.castMessage("You fire some magical flares");
        return SpellResult.CAST;
    }

    protected Color getColor(String name) {
        try {
            Field colorConstant = Color.class.getField(name.toUpperCase());
            return (Color)colorConstant.get(null);
        }
        catch (Exception exception) {
            return Color.WHITE;
        }
    }

    protected FireworkEffect.Type getType(String name) {
        FireworkEffect.Type[] typeArray = FireworkEffect.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FireworkEffect.Type t = typeArray[n2];
            if (t.name().equalsIgnoreCase(name)) {
                return t;
            }
            ++n2;
        }
        return FireworkEffect.Type.BALL;
    }
}

