/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effects;

import com.elmakers.mine.bukkit.effects.EffectRepeating;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EffectRing
extends EffectRepeating {
    protected int size = 8;
    protected float radius = 1.0f;

    public EffectRing() {
    }

    public EffectRing(Plugin plugin) {
        super(plugin);
    }

    public void load(Plugin plugin, ConfigurationNode configuration) {
        super.load(plugin, configuration);
        this.radius = configuration.getFloat("radius", this.radius);
        this.size = configuration.getInt("size", this.size);
    }

    public void setRadius(float radius) {
        this.radius = radius;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void iterate() {
        float currentRadius = this.scale(this.radius) + 1.0f;
        double startRadians = Math.random() * Math.PI * 2.0;
        int i = 0;
        while (i < this.size) {
            Location loc;
            double radians = (double)i / (double)this.size * Math.PI * 2.0 + startRadians;
            Vector direction = new Vector(Math.cos(radians) * (double)currentRadius, 0.0, Math.sin(radians) * (double)currentRadius);
            if (this.playAtOrigin) {
                loc = this.origin.clone();
                loc.add(direction);
                this.playEffect(loc);
            }
            if (this.playAtTarget && this.target != null) {
                loc = this.target.clone();
                loc.add(direction);
                this.playEffect(loc);
            }
            ++i;
        }
    }
}

