/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.MaterialAndData;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class Schematic {
    private static Class<?> vectorClass;
    private static Class<?> cuboidClipboardClass;
    private static Class<?> blockClass;
    private static Class<?> signClass;
    private static Class<?> chestClass;
    private static Class<?> containerClass;
    private static Class<?> itemStackClass;
    private static Class<?> itemClass;
    private static Class<?> compoundTagClass;
    private static Constructor<?> signConstructor;
    private static Constructor<?> chestConstructor;
    private static Constructor<?> vectorConstructor;
    private static Method getBlockMethod;
    private static Method getIdMethod;
    private static Method getDataMethod;
    private static Method getSizeMethod;
    private static Method getBlockXMethod;
    private static Method getBlockYMethod;
    private static Method getBlockZMethod;
    private static Method getLinesMethod;
    private static Method getNBTDataMethod;
    private static Method hasNBTDataMethod;
    private static Method signSetNBTDataMethod;
    private static Method chestSetNBTDataMethod;
    private static Method getItemsMethod;
    private static Method getItemAmountMethod;
    private static Method getItemIdMethod;
    private static Method getItemDataMethod;
    private static Method getItemEnchantmentsMethod;
    private final Object weSchematic;
    private Vector center;
    private Vector size;
    private static Boolean classesValid;

    static {
        classesValid = null;
    }

    private static boolean checkClasses() {
        if (classesValid != null) {
            return classesValid;
        }
        try {
            vectorClass = Class.forName("com.sk89q.worldedit.Vector");
            if (vectorClass != null) {
                vectorConstructor = vectorClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                getBlockXMethod = vectorClass.getMethod("getBlockX", new Class[0]);
                getBlockYMethod = vectorClass.getMethod("getBlockY", new Class[0]);
                getBlockZMethod = vectorClass.getMethod("getBlockZ", new Class[0]);
            }
            if ((cuboidClipboardClass = Class.forName("com.sk89q.worldedit.CuboidClipboard")) != null) {
                getBlockMethod = cuboidClipboardClass.getMethod("getBlock", vectorClass);
                getSizeMethod = cuboidClipboardClass.getMethod("getSize", new Class[0]);
            }
            compoundTagClass = Class.forName("com.sk89q.jnbt.CompoundTag");
            blockClass = Class.forName("com.sk89q.worldedit.foundation.Block");
            if (blockClass != null) {
                getNBTDataMethod = blockClass.getMethod("getNbtData", new Class[0]);
                hasNBTDataMethod = blockClass.getMethod("hasNbtData", new Class[0]);
            }
            if ((signClass = Class.forName("com.sk89q.worldedit.blocks.SignBlock")) != null) {
                getLinesMethod = signClass.getMethod("getText", new Class[0]);
                signSetNBTDataMethod = signClass.getMethod("setNbtData", compoundTagClass);
                signConstructor = signClass.getConstructor(Integer.TYPE, Integer.TYPE);
            }
            if (blockClass != null) {
                getIdMethod = blockClass.getMethod("getId", new Class[0]);
                getDataMethod = blockClass.getMethod("getData", new Class[0]);
            }
            if ((chestClass = Class.forName("com.sk89q.worldedit.blocks.ChestBlock")) != null) {
                chestSetNBTDataMethod = chestClass.getMethod("setNbtData", compoundTagClass);
                chestConstructor = chestClass.getConstructor(Integer.TYPE);
            }
            if ((containerClass = Class.forName("com.sk89q.worldedit.blocks.ContainerBlock")) != null) {
                getItemsMethod = containerClass.getMethod("getItems", new Class[0]);
            }
            if ((itemClass = Class.forName("com.sk89q.worldedit.blocks.BaseItem")) != null) {
                getItemDataMethod = itemClass.getMethod("getData", new Class[0]);
                getItemIdMethod = itemClass.getMethod("getType", new Class[0]);
                getItemEnchantmentsMethod = itemClass.getMethod("getEnchantments", new Class[0]);
            }
            if ((itemStackClass = Class.forName("com.sk89q.worldedit.blocks.BaseItemStack")) != null) {
                getItemAmountMethod = itemStackClass.getMethod("getAmount", new Class[0]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        classesValid = vectorClass != null && vectorConstructor != null && cuboidClipboardClass != null && getBlockMethod != null && blockClass != null && getSizeMethod != null && getBlockXMethod != null && getBlockYMethod != null && getBlockZMethod != null && getLinesMethod != null && signClass != null && compoundTagClass != null && getNBTDataMethod != null && signSetNBTDataMethod != null && hasNBTDataMethod != null && chestClass != null && containerClass != null && itemClass != null && itemStackClass != null && getItemDataMethod != null && getItemIdMethod != null && getItemEnchantmentsMethod != null && getItemAmountMethod != null && getItemsMethod != null && chestSetNBTDataMethod != null && chestConstructor != null;
        return classesValid;
    }

    public Schematic(Object schematic) {
        this.weSchematic = schematic;
        if (Schematic.checkClasses()) {
            try {
                Object weSize = getSizeMethod.invoke(this.weSchematic, new Object[0]);
                this.size = new Vector(((Integer)getBlockXMethod.invoke(weSize, new Object[0])).intValue(), ((Integer)getBlockYMethod.invoke(weSize, new Object[0])).intValue(), ((Integer)getBlockZMethod.invoke(weSize, new Object[0])).intValue());
                this.center = new Vector(Math.floor(this.size.getBlockX() / 2), 0.0, Math.floor(this.size.getBlockZ() / 2));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.center == null) {
            this.center = new Vector(0, 0, 0);
        }
        if (this.size == null) {
            this.size = new Vector(0, 0, 0);
        }
    }

    public boolean contains(Vector v) {
        int x = v.getBlockX() + this.center.getBlockX();
        int y = v.getBlockY() + this.center.getBlockY();
        int z = v.getBlockZ() + this.center.getBlockZ();
        return x >= 0 && x <= this.size.getBlockX() && y >= 0 && y <= this.size.getBlockY() && z >= 0 && z <= this.size.getBlockZ();
    }

    public MaterialAndData getBlock(Vector v) {
        if (!Schematic.checkClasses()) {
            return null;
        }
        int x = v.getBlockX() + this.center.getBlockX();
        int y = v.getBlockY() + this.center.getBlockY();
        int z = v.getBlockZ() + this.center.getBlockZ();
        try {
            Object vector = vectorConstructor.newInstance(x, y, z);
            Object baseBlock = getBlockMethod.invoke(this.weSchematic, vector);
            Material material = Material.getMaterial((int)((Integer)getIdMethod.invoke(baseBlock, new Object[0])));
            int materialData = (Integer)getDataMethod.invoke(baseBlock, new Object[0]);
            MaterialAndData blockData = new MaterialAndData(material, (byte)materialData);
            if (material == Material.SIGN_POST || material == Material.WALL_SIGN) {
                if (((Boolean)hasNBTDataMethod.invoke(baseBlock, new Object[0])).booleanValue()) {
                    Object signBlock = signConstructor.newInstance(material.getId(), materialData);
                    Object nbtData = getNBTDataMethod.invoke(baseBlock, new Object[0]);
                    signSetNBTDataMethod.invoke(signBlock, nbtData);
                    blockData.setSignLines((String[])getLinesMethod.invoke(signBlock, new Object[0]));
                }
            } else if (material == Material.CHEST && ((Boolean)hasNBTDataMethod.invoke(baseBlock, new Object[0])).booleanValue()) {
                Object chestBlock = chestConstructor.newInstance(materialData);
                Object nbtData = getNBTDataMethod.invoke(baseBlock, new Object[0]);
                chestSetNBTDataMethod.invoke(chestBlock, nbtData);
                Object[] items = (Object[])getItemsMethod.invoke(chestBlock, new Object[0]);
                if (items != null && items.length > 0) {
                    ItemStack[] contents = new ItemStack[items.length];
                    int i = 0;
                    while (i < items.length) {
                        if (items[i] != null) {
                            Material itemMaterial = Material.getMaterial((int)((Integer)getItemIdMethod.invoke(items[i], new Object[0])));
                            short itemData = (Short)getItemDataMethod.invoke(items[i], new Object[0]);
                            int itemAmount = (Integer)getItemAmountMethod.invoke(items[i], new Object[0]);
                            ItemStack newStack = new ItemStack(itemMaterial, itemAmount, itemData);
                            Map enchantments = (Map)getItemEnchantmentsMethod.invoke(items[i], new Object[0]);
                            if (enchantments != null && enchantments.size() > 0) {
                                for (Map.Entry enchantment : enchantments.entrySet()) {
                                    try {
                                        Enchantment enchantmentType = Enchantment.getById((int)((Integer)enchantment.getKey()));
                                        newStack.addEnchantment(enchantmentType, ((Integer)enchantment.getValue()).intValue());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            contents[i] = newStack;
                        }
                        ++i;
                    }
                    blockData.setInventoryContents(contents);
                }
            }
            return blockData;
        }
        catch (ArrayIndexOutOfBoundsException vector) {
        }
        catch (InvocationTargetException vector) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

