/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import java.awt.Color;
import java.awt.Image;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.DyeColor;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapCursorCollection;
import org.bukkit.map.MapFont;
import org.bukkit.map.MapPalette;
import org.bukkit.map.MapView;

public class MaterialMapCanvas
implements MapCanvas {
    public static int CANVAS_WIDTH = 128;
    public static int CANVAS_HEIGHT = 128;
    private static MapCursorCollection emptyCursors = new MapCursorCollection();
    private byte[] pixels = new byte[16384];
    private Map<Byte, DyeColor> dyeColors = new HashMap<Byte, DyeColor>();

    public MapView getMapView() {
        return null;
    }

    public MapCursorCollection getCursors() {
        return emptyCursors;
    }

    public void setCursors(MapCursorCollection cursors) {
    }

    public void setPixel(int x, int y, byte color) {
        if (x < 0 || y < 0 || x > CANVAS_WIDTH || y > CANVAS_HEIGHT) {
            return;
        }
        this.pixels[x + y * MaterialMapCanvas.CANVAS_WIDTH] = color;
        if (color != 0 && !this.dyeColors.containsKey(color)) {
            Color mapColor = MapPalette.getColor((byte)color);
            org.bukkit.Color targetColor = org.bukkit.Color.fromRGB((int)mapColor.getRed(), (int)mapColor.getGreen(), (int)mapColor.getBlue());
            DyeColor bestDyeColor = null;
            Double bestDistance = null;
            DyeColor[] dyeColorArray = DyeColor.values();
            int n = dyeColorArray.length;
            int n2 = 0;
            while (n2 < n) {
                DyeColor testDyeColor = dyeColorArray[n2];
                org.bukkit.Color testColor = testDyeColor.getColor();
                double testDistance = MaterialMapCanvas.getDistance(testColor, targetColor);
                if (bestDistance == null || testDistance < bestDistance) {
                    bestDistance = testDistance;
                    bestDyeColor = testDyeColor;
                    if (testDistance == 0.0) break;
                }
                ++n2;
            }
            this.dyeColors.put(color, bestDyeColor);
        }
    }

    private static double getDistance(org.bukkit.Color c1, org.bukkit.Color c2) {
        double rmean = (double)(c1.getRed() + c2.getRed()) / 2.0;
        double r = c1.getRed() - c2.getRed();
        double g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return weightR * r * r + weightG * g * g + weightB * (double)b * (double)b;
    }

    public byte getPixel(int x, int y) {
        if (x < 0 || y < 0 || x > CANVAS_WIDTH || y > CANVAS_HEIGHT) {
            return 0;
        }
        return this.pixels[x + y * CANVAS_WIDTH];
    }

    public DyeColor getDyeColor(int x, int y) {
        byte color = this.getPixel(x, y);
        if (color == 0) {
            return null;
        }
        if (!this.dyeColors.containsKey(color)) {
            return null;
        }
        return this.dyeColors.get(color);
    }

    public byte getBasePixel(int x, int y) {
        return 0;
    }

    public void drawImage(int x, int y, Image image) {
        byte[] bytes = MapPalette.imageToBytes((Image)image);
        int x2 = 0;
        while (x2 < image.getWidth(null)) {
            int y2 = 0;
            while (y2 < image.getHeight(null)) {
                this.setPixel(x + x2, y + y2, bytes[y2 * image.getWidth(null) + x2]);
                ++y2;
            }
            ++x2;
        }
    }

    public void drawText(int x, int y, MapFont font, String text) {
        int xStart = x;
        byte color = 44;
        if (!font.isValid(text)) {
            throw new IllegalArgumentException("text contains invalid characters");
        }
        int i = 0;
        while (i < text.length()) {
            block10: {
                char ch = text.charAt(i);
                if (ch == '\n') {
                    x = xStart;
                    y += font.getHeight() + 1;
                } else {
                    int j;
                    if (ch == '\u00a7' && (j = text.indexOf(59, i)) >= 0) {
                        try {
                            color = Byte.parseByte(text.substring(i + 1, j));
                            i = j;
                            break block10;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    MapFont.CharacterSprite sprite = font.getChar(text.charAt(i));
                    int r = 0;
                    while (r < font.getHeight()) {
                        int c = 0;
                        while (c < sprite.getWidth()) {
                            if (sprite.get(r, c)) {
                                this.setPixel(x + c, y + r, color);
                            }
                            ++c;
                        }
                        ++r;
                    }
                    x += sprite.getWidth() + 1;
                }
            }
            ++i;
        }
    }
}

