/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.wand;

import com.elmakers.mine.bukkit.blocks.MaterialAndData;
import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.blocks.MaterialBrushData;
import com.elmakers.mine.bukkit.effects.EffectRing;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.CastingCost;
import com.elmakers.mine.bukkit.plugins.magic.CostReducer;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.WandMode;
import com.elmakers.mine.bukkit.plugins.magic.wand.WandLevel;
import com.elmakers.mine.bukkit.plugins.magic.wand.WandOrganizer;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.Messages;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.TreeSpecies;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wand
implements CostReducer {
    public static final int INVENTORY_SIZE = 27;
    public static final int HOTBAR_SIZE = 9;
    public static final String[] PROPERTY_KEYS = new String[]{"active_spell", "active_material", "xp", "xp_regeneration", "xp_max", "health_regeneration", "hunger_regeneration", "uses", "cost_reduction", "cooldown_reduction", "power", "protection", "protection_physical", "protection_projectiles", "protection_falling", "protection_fire", "protection_explosions", "haste", "has_inventory", "modifiable", "effect_color", "effect_particle", "effect_particle_data", "effect_particle_count", "effect_bubbles", "materials", "spells", "mode"};
    private ItemStack item;
    private MagicController controller;
    private Mage mage;
    private String id;
    private Inventory hotbar = InventoryUtils.createInventory(null, 9, "Wand");
    private List<Inventory> inventories = new ArrayList<Inventory>();
    private String activeSpell = "";
    private String activeMaterial = "";
    private String wandName = "";
    private String description = "";
    private String owner = "";
    private float costReduction = 0.0f;
    private float cooldownReduction = 0.0f;
    private float damageReduction = 0.0f;
    private float damageReductionPhysical = 0.0f;
    private float damageReductionProjectiles = 0.0f;
    private float damageReductionFalling = 0.0f;
    private float damageReductionFire = 0.0f;
    private float damageReductionExplosions = 0.0f;
    private float power = 0.0f;
    private boolean hasInventory = false;
    private boolean modifiable = true;
    private int uses = 0;
    private int xp = 0;
    private int xpRegeneration = 0;
    private int xpMax = 50;
    private int healthRegeneration = 0;
    private int hungerRegeneration = 0;
    private int effectColor = 0;
    private ParticleType effectParticle = null;
    private float effectParticleData = 0.0f;
    private int effectParticleCount = 1;
    private int particleFrequency = 2;
    private int particleCounter = 0;
    private boolean effectBubbles = false;
    private EffectRing effectPlayer = null;
    private float defaultWalkSpeed = 0.2f;
    private float defaultFlySpeed = 0.1f;
    private float speedIncrease = 0.0f;
    private int storedXpLevel = 0;
    private int storedXp = 0;
    private float storedXpProgress = 0.0f;
    private boolean suspendSave = false;
    private static DecimalFormat floatFormat = new DecimalFormat("#.###");
    public static boolean SchematicsEnabled = false;
    public static Material WandMaterial = Material.BLAZE_ROD;
    public static Material EnchantableWandMaterial = Material.WOOD_SWORD;
    public static Material EraseMaterial = Material.SULPHUR;
    public static Material CopyMaterial = Material.SUGAR;
    public static Material CloneMaterial = Material.NETHER_STALK;
    public static Material ReplicateMaterial = Material.PUMPKIN_SEEDS;
    public static Material MapMaterial = Material.MAP;
    public static Material SchematicMaterial = Material.PAPER;
    public static final String ERASE_MATERIAL_KEY = "erase";
    public static final String COPY_MATERIAL_KEY = "copy";
    public static final String CLONE_MATERIAL_KEY = "clone";
    public static final String REPLICATE_MATERIAL_KEY = "replicate";
    public static final String MAP_MATERIAL_KEY = "map";
    public static final String SCHEMATIC_MATERIAL_KEY = "schematic";
    protected static Map<String, ConfigurationNode> wandTemplates = new HashMap<String, ConfigurationNode>();
    WandMode mode = null;
    int openInventoryPage = 0;
    boolean inventoryIsOpen = false;
    Inventory displayInventory = null;

    private Wand(ItemStack itemStack) {
        this.item = itemStack;
    }

    public Wand(MagicController spells) {
        this(InventoryUtils.getCopy(new ItemStack(WandMaterial)));
        InventoryUtils.addGlow(this.item);
        this.controller = spells;
        this.id = UUID.randomUUID().toString();
        this.wandName = Messages.get("wand.default_name");
        this.updateName();
        this.saveState();
    }

    public Wand(MagicController spells, ItemStack item) {
        this(item);
        this.controller = spells;
        this.loadState();
    }

    public void setActiveSpell(String activeSpell) {
        this.activeSpell = activeSpell;
        this.updateName();
        this.updateInventory();
        this.saveState();
    }

    protected void activateBrush(String materialKey) {
        this.setActiveMaterial(materialKey);
        if (materialKey != null) {
            if (materialKey.contains(":")) {
                materialKey = StringUtils.split((String)materialKey, (String)":")[0];
            }
            if (materialKey.equals(CLONE_MATERIAL_KEY) || materialKey.equals(REPLICATE_MATERIAL_KEY)) {
                MaterialBrush brush = this.mage.getBrush();
                Location cloneLocation = this.mage.getLocation();
                cloneLocation.setY(cloneLocation.getY() - 1.0);
                brush.setCloneLocation(cloneLocation);
            } else if (materialKey.equals(MAP_MATERIAL_KEY) || materialKey.equals(SCHEMATIC_MATERIAL_KEY)) {
                MaterialBrush brush = this.mage.getBrush();
                brush.clearCloneTarget();
            }
        }
    }

    public void activateBrush(ItemStack itemStack) {
        if (!Wand.isBrush(itemStack)) {
            return;
        }
        this.activateBrush(Wand.getMaterialKey(itemStack));
    }

    protected void setActiveMaterial(String materialKey) {
        this.activeMaterial = materialKey;
        this.updateName();
        this.updateActiveMaterial();
        this.updateInventory();
        this.saveState();
    }

    public int getXpRegeneration() {
        return this.xpRegeneration;
    }

    public int getXpMax() {
        return this.xpMax;
    }

    public int getExperience() {
        return this.xp;
    }

    public void removeExperience(int amount) {
        this.xp = Math.max(0, this.xp - amount);
        this.updateMana();
    }

    public int getHealthRegeneration() {
        return this.healthRegeneration;
    }

    public int getHungerRegeneration() {
        return this.hungerRegeneration;
    }

    public boolean isModifiable() {
        return this.modifiable;
    }

    @Override
    public boolean usesMana() {
        return this.xpMax > 0 && this.xpRegeneration > 0 && this.getCostReduction() < 1.0f;
    }

    public float getCooldownReduction() {
        return this.controller.getCooldownReduction() + this.cooldownReduction;
    }

    @Override
    public float getCostReduction() {
        return this.controller.getCostReduction() + this.costReduction;
    }

    public void setCooldownReduction(float reduction) {
        this.cooldownReduction = reduction;
    }

    public boolean getHasInventory() {
        return this.hasInventory;
    }

    public float getPower() {
        return this.power;
    }

    public float getDamageReduction() {
        return this.damageReduction;
    }

    public float getDamageReductionPhysical() {
        return this.damageReductionPhysical;
    }

    public float getDamageReductionProjectiles() {
        return this.damageReductionProjectiles;
    }

    public float getDamageReductionFalling() {
        return this.damageReductionFalling;
    }

    public float getDamageReductionFire() {
        return this.damageReductionFire;
    }

    public float getDamageReductionExplosions() {
        return this.damageReductionExplosions;
    }

    public int getUses() {
        return this.uses;
    }

    public String getName() {
        return this.wandName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setName(String name) {
        this.wandName = name;
        this.updateName();
    }

    protected void setDescription(String description) {
        this.description = description;
        this.updateLore();
    }

    protected void takeOwnership(Player player) {
        this.owner = player.getName();
    }

    public void takeOwnership(Player player, String name, boolean updateDescription) {
        this.setName(name);
        this.takeOwnership(player);
        if (updateDescription) {
            this.setDescription("");
        }
    }

    public ItemStack getItem() {
        return this.item;
    }

    protected List<Inventory> getAllInventories() {
        ArrayList<Inventory> allInventories = new ArrayList<Inventory>(this.inventories.size() + 1);
        allInventories.add(this.hotbar);
        allInventories.addAll(this.inventories);
        return allInventories;
    }

    public Set<String> getSpells() {
        return this.getSpells(false);
    }

    protected Set<String> getSpells(boolean includePositions) {
        TreeSet<String> spellNames = new TreeSet<String>();
        List<Inventory> allInventories = this.getAllInventories();
        int index = 0;
        for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            int i = 0;
            while (i < items.length) {
                if (items[i] != null && !Wand.isWand(items[i]) && Wand.isSpell(items[i])) {
                    String spellName = Wand.getSpell(items[i]);
                    if (includePositions) {
                        spellName = String.valueOf(spellName) + "@" + index;
                    }
                    spellNames.add(spellName);
                }
                ++index;
                ++i;
            }
        }
        return spellNames;
    }

    protected String getSpellString() {
        return StringUtils.join(this.getSpells(true), (String)"|");
    }

    public Set<String> getMaterialKeys() {
        return this.getMaterialKeys(false);
    }

    protected Set<String> getMaterialKeys(boolean includePositions) {
        TreeSet<String> materialNames = new TreeSet<String>();
        ArrayList<Inventory> allInventories = new ArrayList<Inventory>(this.inventories.size() + 1);
        allInventories.add(this.hotbar);
        allInventories.addAll(this.inventories);
        Integer index = 0;
        for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            int i = 0;
            while (i < items.length) {
                String materialKey = Wand.getMaterialKey(items[i], includePositions ? index : null);
                if (materialKey != null) {
                    materialNames.add(materialKey);
                }
                index = index + 1;
                ++i;
            }
        }
        return materialNames;
    }

    protected String getMaterialString() {
        return StringUtils.join(this.getMaterialKeys(true), (String)"|");
    }

    protected Integer parseSlot(String[] pieces) {
        Integer slot = null;
        if (pieces.length > 0) {
            try {
                slot = Integer.parseInt(pieces[1]);
            }
            catch (Exception ex) {
                slot = null;
            }
            if (slot != null && slot < 0) {
                slot = null;
            }
        }
        return slot;
    }

    protected void addToInventory(ItemStack itemStack) {
        WandMode wandMode = this.getMode();
        Integer selectedItem = null;
        if (wandMode == WandMode.INVENTORY && this.mage != null && this.mage.getPlayer() != null) {
            selectedItem = this.mage.getPlayer().getInventory().getHeldItemSlot();
            this.hotbar.setItem(selectedItem.intValue(), this.item);
        }
        List<Inventory> checkInventories = wandMode == WandMode.INVENTORY ? this.getAllInventories() : this.inventories;
        boolean added = false;
        for (Inventory inventory : checkInventories) {
            HashMap returned = inventory.addItem(new ItemStack[]{itemStack});
            if (returned.size() != 0) continue;
            added = true;
            break;
        }
        if (!added) {
            Inventory newInventory = InventoryUtils.createInventory(null, 27, "Wand");
            newInventory.addItem(new ItemStack[]{itemStack});
            this.inventories.add(newInventory);
        }
        if (selectedItem != null) {
            this.hotbar.setItem(selectedItem.intValue(), null);
        }
    }

    protected Inventory getDisplayInventory() {
        if (this.displayInventory == null) {
            this.displayInventory = InventoryUtils.createInventory(null, 27, "Wand");
        }
        return this.displayInventory;
    }

    protected Inventory getInventoryByIndex(int inventoryIndex) {
        while (inventoryIndex >= this.inventories.size()) {
            this.inventories.add(InventoryUtils.createInventory(null, 27, "Wand"));
        }
        return this.inventories.get(inventoryIndex);
    }

    protected Inventory getInventory(Integer slot) {
        Inventory inventory = this.hotbar;
        if (slot >= 9) {
            int inventoryIndex = (slot - 9) / 27;
            inventory = this.getInventoryByIndex(inventoryIndex);
        }
        return inventory;
    }

    protected int getInventorySlot(Integer slot) {
        if (slot < 9) {
            return slot;
        }
        return (slot - 9) % 27;
    }

    protected void addToInventory(ItemStack itemStack, Integer slot) {
        if (slot == null) {
            this.addToInventory(itemStack);
            return;
        }
        Inventory inventory = this.getInventory(slot);
        slot = this.getInventorySlot(slot);
        ItemStack existing = inventory.getItem(slot.intValue());
        inventory.setItem(slot.intValue(), itemStack);
        if (existing != null && existing.getType() != Material.AIR) {
            this.addToInventory(existing);
        }
    }

    protected void parseInventoryStrings(String spellString, String materialString) {
        String[] materialNames;
        String[] spellNames;
        this.hotbar.clear();
        this.inventories.clear();
        String[] stringArray = spellNames = StringUtils.split((String)spellString, (String)"|");
        int n = spellNames.length;
        int n2 = 0;
        while (n2 < n) {
            String spellName = stringArray[n2];
            String[] pieces = spellName.split("@");
            Integer slot = this.parseSlot(pieces);
            ItemStack itemStack = this.createSpellItem(pieces[0]);
            if (itemStack == null) {
                this.controller.getPlugin().getLogger().warning("Unable to create spell icon for key " + pieces[0]);
            } else {
                this.addToInventory(itemStack, slot);
            }
            ++n2;
        }
        String[] stringArray2 = materialNames = StringUtils.split((String)materialString, (String)"|");
        int n3 = materialNames.length;
        n = 0;
        while (n < n3) {
            String materialName = stringArray2[n];
            String[] pieces = materialName.split("@");
            Integer slot = this.parseSlot(pieces);
            ItemStack itemStack = this.createMaterialItem(pieces[0]);
            if (itemStack == null) {
                this.controller.getPlugin().getLogger().warning("Unable to create material icon for key " + pieces[0]);
            } else {
                this.addToInventory(itemStack, slot);
            }
            ++n;
        }
        this.hasInventory = spellNames.length + materialNames.length > 1;
    }

    protected ItemStack createSpellItem(String spellName) {
        Spell spell = this.controller.getSpell(spellName);
        if (spell == null) {
            return null;
        }
        MaterialAndData icon = spell.getIcon();
        if (icon == null) {
            this.controller.getPlugin().getLogger().warning("Unable to create spell icon for " + spell.getName() + ", missing material");
        }
        ItemStack itemStack = null;
        ItemStack originalItemStack = null;
        try {
            originalItemStack = new ItemStack(icon.getMaterial(), 1, 0, Byte.valueOf(icon.getData()));
            itemStack = InventoryUtils.getCopy(originalItemStack);
        }
        catch (Exception ex) {
            itemStack = null;
        }
        if (itemStack == null) {
            this.controller.getPlugin().getLogger().warning("Unable to create spell icon with material " + icon.getMaterial().name());
            return originalItemStack;
        }
        this.updateSpellName(itemStack, spell, true);
        return itemStack;
    }

    private String getActiveWandName(String materialKey) {
        Spell spell = this.controller.getSpell(this.activeSpell);
        return this.getActiveWandName(spell, materialKey);
    }

    protected ItemStack createMaterialItem(String materialKey) {
        byte dataId;
        MaterialBrushData brushData = Wand.parseMaterialKey(materialKey);
        if (brushData == null) {
            return null;
        }
        Material material = brushData.getMaterial();
        ItemStack originalItemStack = new ItemStack(material, 1, 0, Byte.valueOf(dataId = brushData.getData()));
        ItemStack itemStack = InventoryUtils.getCopy(originalItemStack);
        if (itemStack == null) {
            this.controller.getPlugin().getLogger().warning("Unable to create material icon for " + material.name() + ": " + originalItemStack.getType());
            return originalItemStack;
        }
        ItemMeta meta = itemStack.getItemMeta();
        ArrayList<String> lore = new ArrayList<String>();
        if (material != null) {
            lore.add(ChatColor.GRAY + Messages.get("wand.building_material_info").replace("$material", Wand.getMaterialName(materialKey)));
            if (material == EraseMaterial) {
                lore.add(Messages.get("wand.erase_material_description"));
            } else if (material == CopyMaterial) {
                lore.add(Messages.get("wand.copy_material_description"));
            } else if (material == CloneMaterial) {
                lore.add(Messages.get("wand.clone_material_description"));
            } else if (material == ReplicateMaterial) {
                lore.add(Messages.get("wand.replicate_material_description"));
            } else if (material == MapMaterial) {
                lore.add(Messages.get("wand.map_material_description"));
            } else if (material == SchematicMaterial) {
                lore.add(Messages.get("wand.schematic_material_description").replace("$schematic", brushData.getSchematicName()));
            } else {
                lore.add(ChatColor.LIGHT_PURPLE + Messages.get("wand.building_material_description"));
            }
        }
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        this.updateMaterialName(itemStack, materialKey, true);
        return itemStack;
    }

    protected void saveState(boolean force) {
        if (force) {
            this.suspendSave = false;
        }
        this.saveState();
    }

    protected void saveState() {
        if (this.suspendSave) {
            return;
        }
        Object wandNode = InventoryUtils.createNode(this.item, "wand");
        InventoryUtils.setMeta(wandNode, "id", this.id);
        String wandMaterials = this.getMaterialString();
        String wandSpells = this.getSpellString();
        InventoryUtils.setMeta(wandNode, "materials", wandMaterials);
        InventoryUtils.setMeta(wandNode, "spells", wandSpells);
        InventoryUtils.setMeta(wandNode, "active_spell", this.activeSpell);
        InventoryUtils.setMeta(wandNode, "active_material", this.activeMaterial);
        InventoryUtils.setMeta(wandNode, "name", this.wandName);
        InventoryUtils.setMeta(wandNode, "description", this.description);
        InventoryUtils.setMeta(wandNode, "owner", this.owner);
        InventoryUtils.setMeta(wandNode, "cost_reduction", floatFormat.format(this.costReduction));
        InventoryUtils.setMeta(wandNode, "cooldown_reduction", floatFormat.format(this.cooldownReduction));
        InventoryUtils.setMeta(wandNode, "power", floatFormat.format(this.power));
        InventoryUtils.setMeta(wandNode, "protection", floatFormat.format(this.damageReduction));
        InventoryUtils.setMeta(wandNode, "protection_physical", floatFormat.format(this.damageReductionPhysical));
        InventoryUtils.setMeta(wandNode, "protection_projectiles", floatFormat.format(this.damageReductionProjectiles));
        InventoryUtils.setMeta(wandNode, "protection_falling", floatFormat.format(this.damageReductionFalling));
        InventoryUtils.setMeta(wandNode, "protection_fire", floatFormat.format(this.damageReductionFire));
        InventoryUtils.setMeta(wandNode, "protection_explosions", floatFormat.format(this.damageReductionExplosions));
        InventoryUtils.setMeta(wandNode, "haste", floatFormat.format(this.speedIncrease));
        InventoryUtils.setMeta(wandNode, "xp", Integer.toString(this.xp));
        InventoryUtils.setMeta(wandNode, "xp_regeneration", Integer.toString(this.xpRegeneration));
        InventoryUtils.setMeta(wandNode, "xp_max", Integer.toString(this.xpMax));
        InventoryUtils.setMeta(wandNode, "health_regeneration", Integer.toString(this.healthRegeneration));
        InventoryUtils.setMeta(wandNode, "hunger_regeneration", Integer.toString(this.hungerRegeneration));
        InventoryUtils.setMeta(wandNode, "uses", Integer.toString(this.uses));
        InventoryUtils.setMeta(wandNode, "has_inventory", Integer.toString(this.hasInventory ? 1 : 0));
        InventoryUtils.setMeta(wandNode, "modifiable", Integer.toString(this.modifiable ? 1 : 0));
        InventoryUtils.setMeta(wandNode, "effect_color", Integer.toString(this.effectColor, 16));
        InventoryUtils.setMeta(wandNode, "effect_bubbles", Integer.toString(this.effectBubbles ? 1 : 0));
        InventoryUtils.setMeta(wandNode, "effect_particle_data", Float.toString(this.effectParticleData));
        InventoryUtils.setMeta(wandNode, "effect_particle_count", Integer.toString(this.effectParticleCount));
        if (this.effectParticle != null) {
            InventoryUtils.setMeta(wandNode, "effect_particle", this.effectParticle.name());
        }
        if (this.mode != null) {
            InventoryUtils.setMeta(wandNode, "mode", this.mode.name());
        }
    }

    protected void loadState() {
        Object wandNode = InventoryUtils.getNode(this.item, "wand");
        if (wandNode == null) {
            this.controller.getPlugin().getLogger().warning("Found a wand with missing NBT data. This may be an old wand, or something may have wiped its data");
            return;
        }
        this.id = InventoryUtils.getMeta(wandNode, "id");
        this.id = this.id == null || this.id.length() == 0 ? UUID.randomUUID().toString() : this.id;
        this.wandName = InventoryUtils.getMeta(wandNode, "name", this.wandName);
        this.description = InventoryUtils.getMeta(wandNode, "description", this.description);
        this.owner = InventoryUtils.getMeta(wandNode, "owner", this.owner);
        this.activeSpell = InventoryUtils.getMeta(wandNode, "active_spell", this.activeSpell);
        this.activeMaterial = InventoryUtils.getMeta(wandNode, "active_material", this.activeMaterial);
        String wandMaterials = InventoryUtils.getMeta(wandNode, "materials", "");
        String wandSpells = InventoryUtils.getMeta(wandNode, "spells", "");
        this.parseInventoryStrings(wandSpells, wandMaterials);
        this.costReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "cost_reduction", floatFormat.format(this.costReduction)));
        this.cooldownReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "cooldown_reduction", floatFormat.format(this.cooldownReduction)));
        this.power = Float.parseFloat(InventoryUtils.getMeta(wandNode, "power", floatFormat.format(this.power)));
        this.damageReduction = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection", floatFormat.format(this.damageReduction)));
        this.damageReductionPhysical = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_physical", floatFormat.format(this.damageReductionPhysical)));
        this.damageReductionProjectiles = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_projectiles", floatFormat.format(this.damageReductionProjectiles)));
        this.damageReductionFalling = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_falling", floatFormat.format(this.damageReductionFalling)));
        this.damageReductionFire = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_fire", floatFormat.format(this.damageReductionFire)));
        this.damageReductionExplosions = Float.parseFloat(InventoryUtils.getMeta(wandNode, "protection_explosions", floatFormat.format(this.damageReductionExplosions)));
        this.speedIncrease = Float.parseFloat(InventoryUtils.getMeta(wandNode, "haste", floatFormat.format(this.speedIncrease)));
        this.xp = Integer.parseInt(InventoryUtils.getMeta(wandNode, "xp", Integer.toString(this.xp)));
        this.xpRegeneration = Integer.parseInt(InventoryUtils.getMeta(wandNode, "xp_regeneration", Integer.toString(this.xpRegeneration)));
        this.xpMax = Integer.parseInt(InventoryUtils.getMeta(wandNode, "xp_max", Integer.toString(this.xpMax)));
        this.healthRegeneration = Integer.parseInt(InventoryUtils.getMeta(wandNode, "health_regeneration", Integer.toString(this.healthRegeneration)));
        this.hungerRegeneration = Integer.parseInt(InventoryUtils.getMeta(wandNode, "hunger_regeneration", Integer.toString(this.hungerRegeneration)));
        this.uses = Integer.parseInt(InventoryUtils.getMeta(wandNode, "uses", Integer.toString(this.uses)));
        this.hasInventory = Integer.parseInt(InventoryUtils.getMeta(wandNode, "has_inventory", this.hasInventory ? "1" : "0")) != 0;
        this.modifiable = Integer.parseInt(InventoryUtils.getMeta(wandNode, "modifiable", this.modifiable ? "1" : "0")) != 0;
        this.effectColor = Integer.parseInt(InventoryUtils.getMeta(wandNode, "effect_color", Integer.toString(this.effectColor, 16)), 16);
        this.effectBubbles = Integer.parseInt(InventoryUtils.getMeta(wandNode, "effect_bubbles", this.effectBubbles ? "1" : "0")) != 0;
        this.effectParticleData = Float.parseFloat(InventoryUtils.getMeta(wandNode, "effect_particle_data", floatFormat.format(this.effectParticleData)));
        this.effectParticleCount = Integer.parseInt(InventoryUtils.getMeta(wandNode, "effect_particle_count", Integer.toString(this.effectParticleCount)));
        this.parseParticleEffect(InventoryUtils.getMeta(wandNode, "effect_particle", this.effectParticle == null ? "" : this.effectParticle.name()));
        this.mode = Wand.parseWandMode(InventoryUtils.getMeta(wandNode, "mode", ""), this.mode);
    }

    protected void parseParticleEffect(String effectParticleName) {
        if (effectParticleName.length() > 0) {
            String testName = effectParticleName.toUpperCase().replace("_", "");
            try {
                ParticleType[] particleTypeArray = ParticleType.values();
                int n = particleTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ParticleType testType = particleTypeArray[n2];
                    String testTypeName = testType.name().replace("_", "");
                    if (testTypeName.equals(testName)) {
                        this.effectParticle = testType;
                        break;
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                this.effectParticle = null;
            }
        } else {
            this.effectParticle = null;
        }
    }

    public void describe(CommandSender sender) {
        Object wandNode = InventoryUtils.getNode(this.item, "wand");
        if (wandNode == null) {
            sender.sendMessage("Found a wand with missing NBT data. This may be an old wand, or something may have wiped its data");
            return;
        }
        ChatColor wandColor = this.modifiable ? ChatColor.AQUA : ChatColor.RED;
        sender.sendMessage(wandColor + this.wandName);
        if (this.description.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + ChatColor.GREEN + this.description);
        } else {
            sender.sendMessage(ChatColor.ITALIC + ChatColor.GREEN + "(No Description)");
        }
        if (this.owner.length() > 0) {
            sender.sendMessage(ChatColor.ITALIC + ChatColor.WHITE + this.owner);
        } else {
            sender.sendMessage(ChatColor.ITALIC + ChatColor.WHITE + "(No Owner)");
        }
        String[] stringArray = PROPERTY_KEYS;
        int n = PROPERTY_KEYS.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            String value = InventoryUtils.getMeta(wandNode, key);
            if (value != null && value.length() > 0) {
                sender.sendMessage(String.valueOf(key) + ": " + value);
            }
            ++n2;
        }
    }

    public boolean removeMaterial(String materialKey) {
        if (!this.modifiable || materialKey == null) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if (materialKey.equals(this.activeMaterial)) {
            this.activeMaterial = null;
        }
        List<Inventory> allInventories = this.getAllInventories();
        boolean found = false;
        block0: for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            int index = 0;
            while (index < items.length) {
                ItemStack itemStack = items[index];
                if (itemStack != null && Wand.isBrush(itemStack)) {
                    String itemKey = Wand.getMaterialKey(itemStack);
                    if (itemKey.equals(materialKey)) {
                        found = true;
                        inventory.setItem(index, null);
                    } else if (this.activeMaterial == null) {
                        this.activeMaterial = materialKey;
                    }
                    if (found && this.activeMaterial != null) continue block0;
                }
                ++index;
            }
        }
        this.updateActiveMaterial();
        this.updateInventory();
        this.updateName();
        this.updateLore();
        this.saveState();
        if (this.isInventoryOpen()) {
            this.updateInventory();
        }
        return found;
    }

    public boolean hasMaterial(String materialKey) {
        return this.getMaterialKeys().contains(materialKey);
    }

    public boolean hasSpell(String spellName) {
        return this.getSpells().contains(spellName);
    }

    public boolean addMaterial(String materialKey, boolean makeActive, boolean force) {
        boolean addedNew;
        if (!this.modifiable && !force) {
            return false;
        }
        boolean bl = addedNew = !this.hasMaterial(materialKey);
        if (addedNew) {
            this.addToInventory(this.createMaterialItem(materialKey));
        }
        if (this.activeMaterial == null || this.activeMaterial.length() == 0 || makeActive) {
            this.setActiveMaterial(materialKey);
        } else {
            this.updateInventory();
        }
        this.updateLore();
        this.saveState();
        this.hasInventory = this.getSpells().size() + this.getMaterialKeys().size() > 1;
        return addedNew;
    }

    public boolean addMaterial(Material material, byte data, boolean makeActive, boolean force) {
        if (!this.modifiable && !force) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        String materialKey = Wand.getMaterialKey(material, data);
        return this.addMaterial(materialKey, makeActive, force);
    }

    public boolean removeSpell(String spellName) {
        if (!this.modifiable) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        if (spellName.equals(this.activeSpell)) {
            this.activeSpell = null;
        }
        List<Inventory> allInventories = this.getAllInventories();
        boolean found = false;
        block0: for (Inventory inventory : allInventories) {
            ItemStack[] items = inventory.getContents();
            int index = 0;
            while (index < items.length) {
                ItemStack itemStack = items[index];
                if (itemStack != null && itemStack.getType() != Material.AIR && !Wand.isWand(itemStack) && Wand.isSpell(itemStack)) {
                    if (Wand.getSpell(itemStack).equals(spellName)) {
                        found = true;
                        inventory.setItem(index, null);
                    } else if (this.activeSpell == null) {
                        this.activeSpell = Wand.getSpell(itemStack);
                    }
                    if (found && this.activeSpell != null) continue block0;
                }
                ++index;
            }
        }
        this.updateName();
        this.updateLore();
        this.saveState();
        this.updateInventory();
        return found;
    }

    public boolean addSpell(String spellName, boolean makeActive) {
        if (!this.modifiable) {
            return false;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
        }
        boolean addedNew = !this.hasSpell(spellName);
        ItemStack spellItem = this.createSpellItem(spellName);
        if (spellItem == null) {
            this.controller.getPlugin().getLogger().info("Unknown spell: " + spellName);
            return false;
        }
        if (addedNew) {
            this.addToInventory(spellItem);
        }
        if (this.activeSpell == null || this.activeSpell.length() == 0 || makeActive) {
            this.setActiveSpell(spellName);
        } else {
            this.updateInventory();
        }
        this.hasInventory = this.getSpells().size() + this.getMaterialKeys().size() > 1;
        this.updateLore();
        this.saveState();
        return addedNew;
    }

    public boolean addSpell(String spellName) {
        return this.addSpell(spellName, false);
    }

    private String getSpellDisplayName(Spell spell, String materialKey) {
        String name = "";
        if (spell != null) {
            if (materialKey != null && spell instanceof BrushSpell && !((BrushSpell)spell).hasBrushOverride()) {
                String materialName = Wand.getMaterialName(materialKey);
                if (materialName == null) {
                    materialName = "none";
                }
                name = ChatColor.GOLD + spell.getName() + ChatColor.GRAY + " " + materialName + ChatColor.WHITE;
            } else {
                name = ChatColor.GOLD + spell.getName() + ChatColor.WHITE;
            }
        }
        return name;
    }

    private String getActiveWandName(Spell spell, String materialKey) {
        int remaining;
        ChatColor wandColor = this.modifiable ? ChatColor.AQUA : ChatColor.RED;
        String name = wandColor + this.wandName;
        if (spell != null) {
            name = String.valueOf(this.getSpellDisplayName(spell, materialKey)) + " (" + name + ChatColor.WHITE + ")";
        }
        if ((remaining = this.getRemainingUses()) > 0) {
            name = String.valueOf(name) + " : " + ChatColor.RED + Messages.get("wand.uses_remaining_brief").replace("$count", Integer.valueOf(remaining).toString());
        }
        return name;
    }

    private String getActiveWandName(Spell spell) {
        return this.getActiveWandName(spell, this.activeMaterial);
    }

    private static String getMaterialKey(Material material) {
        String materialKey = null;
        if (material == null) {
            return null;
        }
        if (material == EraseMaterial) {
            materialKey = ERASE_MATERIAL_KEY;
        } else if (material == CopyMaterial) {
            materialKey = COPY_MATERIAL_KEY;
        } else if (material == CloneMaterial) {
            materialKey = CLONE_MATERIAL_KEY;
        } else if (material == MapMaterial) {
            materialKey = MAP_MATERIAL_KEY;
        } else if (material == ReplicateMaterial) {
            materialKey = REPLICATE_MATERIAL_KEY;
        } else if (SchematicsEnabled && material == SchematicMaterial) {
            materialKey = SCHEMATIC_MATERIAL_KEY;
        } else if (material.isBlock()) {
            materialKey = material.name().toLowerCase();
        }
        return materialKey;
    }

    private static String getMaterialKey(Material material, byte data) {
        String materialKey = Wand.getMaterialKey(material);
        if (materialKey == null) {
            return null;
        }
        if (data != 0) {
            materialKey = String.valueOf(materialKey) + ":" + data;
        }
        return materialKey;
    }

    private static String getMaterialName(String materialKey) {
        if (materialKey == null) {
            return null;
        }
        String materialName = materialKey;
        String[] namePieces = StringUtils.split((String)materialName, (String)":");
        if (namePieces.length == 0) {
            return null;
        }
        materialName = namePieces[0];
        if (!Wand.isSpecialMaterialKey(materialKey)) {
            MaterialBrushData brushData = Wand.parseMaterialKey(materialKey);
            if (brushData == null) {
                return null;
            }
            Material material = brushData.getMaterial();
            byte data = brushData.getData();
            if (material == Material.CARPET || material.getId() == 95 || material.getId() == 159 || material.getId() == 160 || material == Material.WOOL) {
                DyeColor color = DyeColor.getByWoolData((byte)data);
                materialName = String.valueOf(color.name().toLowerCase().replace('_', ' ')) + " " + materialName;
            } else if (material == Material.WOOD || material == Material.LOG || material == Material.SAPLING || material == Material.LEAVES) {
                TreeSpecies treeSpecies = TreeSpecies.getByData((byte)data);
                materialName = String.valueOf(treeSpecies.name().toLowerCase().replace('_', ' ')) + " " + materialName;
            } else {
                materialName = material.name();
            }
        } else if (materialName.startsWith(SCHEMATIC_MATERIAL_KEY) && namePieces.length > 1) {
            materialName = namePieces[1];
        }
        materialName = materialName.toLowerCase().replace('_', ' ');
        return materialName;
    }

    private String getActiveWandName() {
        Spell spell = null;
        if (this.hasInventory) {
            spell = this.controller.getSpell(this.activeSpell);
        }
        return this.getActiveWandName(spell);
    }

    public void updateName(boolean isActive) {
        ItemMeta meta = this.item.getItemMeta();
        meta.setDisplayName(isActive ? this.getActiveWandName() : this.wandName);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    private void updateName() {
        this.updateName(true);
    }

    private String getLevelString(String prefix, float amount) {
        String suffix = "";
        suffix = amount > 1.0f ? Messages.get("wand.enchantment_level_max") : ((double)amount > 0.8 ? Messages.get("wand.enchantment_level_5") : ((double)amount > 0.6 ? Messages.get("wand.enchantment_level_4") : ((double)amount > 0.4 ? Messages.get("wand.enchantment_level_3") : ((double)amount > 0.2 ? Messages.get("wand.enchantment_level_2") : Messages.get("wand.enchantment_level_1")))));
        return String.valueOf(prefix) + " " + suffix;
    }

    protected static String convertToHTML(String line) {
        int tagCount = 1;
        line = "<span style=\"color:white\">" + line;
        ChatColor[] chatColorArray = ChatColor.values();
        int n = chatColorArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChatColor c = chatColorArray[n2];
            tagCount += StringUtils.countMatches((String)line, (String)c.toString());
            String replaceStyle = "";
            if (c == ChatColor.ITALIC) {
                replaceStyle = "font-style: italic";
            } else if (c == ChatColor.BOLD) {
                replaceStyle = "font-weight: bold";
            } else if (c == ChatColor.UNDERLINE) {
                replaceStyle = "text-decoration: underline";
            } else {
                String color = c.name().toLowerCase().replace("_", "");
                if (c == ChatColor.LIGHT_PURPLE) {
                    color = "mediumpurple";
                }
                replaceStyle = "color:" + color;
            }
            line = line.replace(c.toString(), "<span style=\"" + replaceStyle + "\">");
            ++n2;
        }
        int i = 0;
        while (i < tagCount) {
            line = String.valueOf(line) + "</span>";
            ++i;
        }
        return line;
    }

    public String getHTMLDescription() {
        List<String> rawLore = this.getLore();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("<h2>" + Wand.convertToHTML(this.getActiveWandName()) + "</h2>");
        for (String line : rawLore) {
            lore.add(Wand.convertToHTML(line));
        }
        return "<div style=\"background-color: black; margin: 8px; padding: 8px\">" + StringUtils.join(lore, (String)"<br/>") + "</div>";
    }

    private List<String> getLore() {
        return this.getLore(this.getSpells().size(), this.getMaterialKeys().size());
    }

    private List<String> getLore(int spellCount, int materialCount) {
        ArrayList<String> lore = new ArrayList<String>();
        Spell spell = this.controller.getSpell(this.activeSpell);
        if (spell != null && spellCount == 1 && materialCount <= 1) {
            this.addSpellLore(spell, lore);
        } else {
            if (this.description.length() > 0) {
                lore.add(ChatColor.ITALIC + ChatColor.GREEN + this.description);
            }
            if (this.owner.length() > 0) {
                String ownerDescription = Messages.get("wand.owner_description", "$name").replace("$name", this.owner);
                lore.add(ChatColor.ITALIC + ChatColor.DARK_GREEN + ownerDescription);
            }
            lore.add(Messages.get("wand.spell_count").replace("$count", Integer.valueOf(spellCount).toString()));
            if (materialCount > 0) {
                lore.add(Messages.get("wand.material_count").replace("$count", Integer.valueOf(materialCount).toString()));
            }
        }
        int remaining = this.getRemainingUses();
        if (remaining > 0) {
            lore.add(ChatColor.RED + Messages.get("wand.uses_remaining").replace("$count", Integer.valueOf(remaining).toString()));
        }
        if (this.usesMana()) {
            lore.add(ChatColor.LIGHT_PURPLE + ChatColor.ITALIC + Messages.get("wand.mana_amount").replace("$amount", Integer.valueOf(this.xpMax).toString()));
            lore.add(ChatColor.RESET + ChatColor.LIGHT_PURPLE + this.getLevelString(Messages.get("wand.mana_regeneration"), (float)this.xpRegeneration / 50.0f));
        }
        if (this.costReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.cost_reduction"), this.costReduction));
        }
        if (this.cooldownReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.cooldown_reduction"), this.cooldownReduction));
        }
        if (this.power > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.power"), this.power));
        }
        if (this.speedIncrease > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.haste"), this.speedIncrease));
        }
        if (this.damageReduction > 0.0f) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.protection"), this.damageReduction));
        }
        if (this.damageReduction < 1.0f) {
            if (this.damageReductionPhysical > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.protection_physical"), this.damageReductionPhysical));
            }
            if (this.damageReductionProjectiles > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.protection_projectile"), this.damageReductionProjectiles));
            }
            if (this.damageReductionFalling > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.protection_fall"), this.damageReductionFalling));
            }
            if (this.damageReductionFire > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.protection_fire"), this.damageReductionFire));
            }
            if (this.damageReductionExplosions > 0.0f) {
                lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.protection_blast"), this.damageReductionExplosions));
            }
        }
        if (this.healthRegeneration > 0) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.health_regeneration"), this.healthRegeneration / 5));
        }
        if (this.hungerRegeneration > 0) {
            lore.add(ChatColor.AQUA + this.getLevelString(Messages.get("wand.hunger_regeneration"), this.hungerRegeneration / 5));
        }
        return lore;
    }

    private void updateLore() {
        ItemMeta meta = this.item.getItemMeta();
        List<String> lore = this.getLore();
        meta.setLore(lore);
        this.item.setItemMeta(meta);
        InventoryUtils.addGlow(this.item);
        this.saveState();
    }

    public int getRemainingUses() {
        return this.uses;
    }

    public void makeEnchantable(boolean enchantable) {
        this.item.setType(enchantable ? EnchantableWandMaterial : WandMaterial);
        this.updateName();
    }

    public static boolean hasActiveWand(Player player) {
        if (player == null) {
            return false;
        }
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    public static Wand getActiveWand(MagicController spells, Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        if (Wand.isWand(activeItem)) {
            return new Wand(spells, activeItem);
        }
        return null;
    }

    public static boolean isSpecialMaterialKey(String materialKey) {
        if (materialKey == null || materialKey.length() == 0) {
            return false;
        }
        if (materialKey.contains(":")) {
            materialKey = StringUtils.split((String)materialKey, (String)":")[0];
        }
        return COPY_MATERIAL_KEY.equals(materialKey) || ERASE_MATERIAL_KEY.equals(materialKey) || REPLICATE_MATERIAL_KEY.equals(materialKey) || CLONE_MATERIAL_KEY.equals(materialKey) || MAP_MATERIAL_KEY.equals(materialKey) || SchematicsEnabled && SCHEMATIC_MATERIAL_KEY.equals(materialKey);
    }

    public static boolean isWand(ItemStack item) {
        return !(item == null || item.getType() != WandMaterial && item.getType() != EnchantableWandMaterial || !InventoryUtils.hasMeta(item, "wand") && !InventoryUtils.hasMeta(item, "magic_wand"));
    }

    public static boolean isSpell(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "spell");
    }

    public static boolean isBrush(ItemStack item) {
        return item != null && InventoryUtils.hasMeta(item, "brush");
    }

    public static String getSpell(ItemStack item) {
        if (!Wand.isSpell(item)) {
            return null;
        }
        Object spellNode = InventoryUtils.getNode(item, "spell");
        return InventoryUtils.getMeta(spellNode, "key");
    }

    public static String getMaterialKey(ItemStack item) {
        if (!Wand.isBrush(item)) {
            return null;
        }
        Object brushNode = InventoryUtils.getNode(item, "brush");
        return InventoryUtils.getMeta(brushNode, "key");
    }

    protected static String getMaterialKey(ItemStack itemStack, Integer index) {
        String materialKey = Wand.getMaterialKey(itemStack);
        if (materialKey == null) {
            return null;
        }
        if (index != null) {
            materialKey = String.valueOf(materialKey) + "@" + index;
        }
        return materialKey;
    }

    protected void updateInventoryName(ItemStack item, boolean activeName) {
        if (Wand.isSpell(item)) {
            Spell spell = this.mage.getSpell(Wand.getSpell(item));
            if (spell != null) {
                this.updateSpellName(item, spell, activeName);
            }
        } else if (Wand.isBrush(item)) {
            this.updateMaterialName(item, Wand.getMaterialKey(item), activeName);
        }
    }

    protected void updateSpellName(ItemStack itemStack, Spell spell, boolean activeName) {
        ItemMeta meta = itemStack.getItemMeta();
        String displayName = null;
        displayName = activeName ? this.getActiveWandName(spell) : this.getSpellDisplayName(spell, this.activeMaterial);
        meta.setDisplayName(displayName);
        ArrayList<String> lore = new ArrayList<String>();
        this.addSpellLore(spell, lore);
        meta.setLore(lore);
        itemStack.setItemMeta(meta);
        InventoryUtils.addGlow(itemStack);
        Object spellNode = InventoryUtils.createNode(itemStack, "spell");
        InventoryUtils.setMeta(spellNode, "key", spell.getKey());
    }

    protected void updateMaterialName(ItemStack itemStack, String materialKey, boolean activeName) {
        ItemMeta meta = itemStack.getItemMeta();
        String displayName = null;
        displayName = activeName ? this.getActiveWandName(materialKey) : Wand.getMaterialName(materialKey);
        meta.setDisplayName(displayName);
        itemStack.setItemMeta(meta);
        Object brushNode = InventoryUtils.createNode(itemStack, "brush");
        InventoryUtils.setMeta(brushNode, "key", materialKey);
    }

    private void updateInventory() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.INVENTORY) {
            if (!this.mage.hasStoredInventory()) {
                return;
            }
            PlayerInventory inventory = player.getInventory();
            inventory.clear();
            this.updateHotbar(inventory);
            this.updateInventory((Inventory)inventory, 9);
            this.updateName();
            player.updateInventory();
        } else if (wandMode == WandMode.CHEST) {
            Inventory inventory = this.getDisplayInventory();
            inventory.clear();
            this.updateInventory(inventory, 0);
            player.updateInventory();
        }
    }

    private void updateHotbar(PlayerInventory playerInventory) {
        int currentSlot = playerInventory.getHeldItemSlot();
        ItemStack existingHotbar = this.hotbar.getItem(currentSlot);
        if (existingHotbar != null && existingHotbar.getType() != Material.AIR && !Wand.isWand(existingHotbar)) {
            this.addToInventory(existingHotbar);
            this.hotbar.setItem(currentSlot, null);
        }
        playerInventory.setItem(currentSlot, this.item);
        int hotbarSlot = 0;
        while (hotbarSlot < 9) {
            if (hotbarSlot != currentSlot) {
                ItemStack hotbarItem = this.hotbar.getItem(hotbarSlot);
                this.updateInventoryName(hotbarItem, true);
                playerInventory.setItem(hotbarSlot, hotbarItem);
            }
            ++hotbarSlot;
        }
    }

    private void updateInventory(Inventory targetInventory, int startOffset) {
        if (this.openInventoryPage < this.inventories.size()) {
            Inventory inventory = this.inventories.get(this.openInventoryPage);
            ItemStack[] contents = inventory.getContents();
            int i = 0;
            while (i < contents.length) {
                ItemStack inventoryItem = contents[i];
                this.updateInventoryName(inventoryItem, false);
                targetInventory.setItem(i + startOffset, inventoryItem);
                ++i;
            }
        }
    }

    protected void addSpellLore(Spell spell, List<String> lore) {
        List<CastingCost> activeCosts;
        List<CastingCost> costs;
        String description = spell.getDescription();
        String usage = spell.getUsage();
        if (description != null && description.length() > 0) {
            lore.add(description);
        }
        if (usage != null && usage.length() > 0) {
            lore.add(usage);
        }
        if ((costs = spell.getCosts()) != null) {
            for (CastingCost cost : costs) {
                if (!cost.hasCosts(this)) continue;
                lore.add(ChatColor.YELLOW + Messages.get("wand.costs_description").replace("$description", cost.getFullDescription(this)));
            }
        }
        if ((activeCosts = spell.getActiveCosts()) != null) {
            for (CastingCost cost : activeCosts) {
                if (!cost.hasCosts(this)) continue;
                lore.add(ChatColor.YELLOW + Messages.get("wand.active_costs_description").replace("$description", cost.getFullDescription(this)));
            }
        }
    }

    protected Inventory getOpenInventory() {
        while (this.openInventoryPage >= this.inventories.size()) {
            this.inventories.add(InventoryUtils.createInventory(null, 27, "Wand"));
        }
        return this.inventories.get(this.openInventoryPage);
    }

    public void saveInventory() {
        if (this.mage == null) {
            return;
        }
        if (!this.isInventoryOpen()) {
            return;
        }
        if (this.mage.getPlayer() == null) {
            return;
        }
        if (this.getMode() != WandMode.INVENTORY) {
            return;
        }
        if (!this.mage.hasStoredInventory()) {
            return;
        }
        Player player = this.mage.getPlayer();
        PlayerInventory playerInventory = player.getInventory();
        int i = 0;
        while (i < 9) {
            ItemStack playerItem = playerInventory.getItem(i);
            if (Wand.isWand(playerItem)) {
                playerItem = null;
            }
            this.hotbar.setItem(i, playerItem);
            ++i;
        }
        Inventory openInventory = this.getOpenInventory();
        int i2 = 0;
        while (i2 < openInventory.getSize()) {
            openInventory.setItem(i2, playerInventory.getItem(i2 + 9));
            ++i2;
        }
        this.saveState();
    }

    public static boolean isActive(Player player) {
        ItemStack activeItem = player.getInventory().getItemInHand();
        return Wand.isWand(activeItem);
    }

    protected void randomize(int totalLevels, boolean additive) {
        if (!wandTemplates.containsKey("random")) {
            return;
        }
        if (!additive) {
            this.wandName = Messages.get("wands.random.name", this.wandName);
        }
        int maxLevel = WandLevel.getMaxLevel();
        int addLevels = Math.min(totalLevels, maxLevel);
        while (addLevels > 0) {
            WandLevel.randomizeWand(this, additive, addLevels);
            addLevels = Math.min(totalLevels -= maxLevel, maxLevel);
            additive = true;
        }
    }

    public static Wand createWand(MagicController controller, String templateName) {
        return Wand.createWand(controller, templateName, null);
    }

    public static Wand createWand(MagicController controller, String templateName, Mage owner) {
        Wand wand = new Wand(controller);
        wand.suspendSave = true;
        String wandName = Messages.get("wand.default_name");
        String wandDescription = "";
        if ((templateName == null || templateName.length() == 0) && wandTemplates.containsKey("default")) {
            templateName = "default";
        }
        if (templateName != null && templateName.length() > 0) {
            List<Object> materialList;
            if ((templateName.equals("random") || templateName.startsWith("random(")) && wandTemplates.containsKey("random")) {
                int level = 1;
                if (!templateName.equals("random")) {
                    String randomLevel = templateName.substring(templateName.indexOf(40) + 1, templateName.length() - 1);
                    level = Integer.parseInt(randomLevel);
                }
                ConfigurationNode randomTemplate = wandTemplates.get("random");
                wand.randomize(level, false);
                wand.modifiable = randomTemplate.getBoolean("modifiable", true);
                wand.saveState(true);
                return wand;
            }
            if (!wandTemplates.containsKey(templateName)) {
                return null;
            }
            ConfigurationNode wandConfig = wandTemplates.get(templateName);
            wandName = Messages.get("wands." + templateName + ".name", wandName);
            wandDescription = Messages.get("wands." + templateName + ".description", wandDescription);
            List<Object> spellList = wandConfig.getList("spells");
            if (spellList != null) {
                for (Object spellName : spellList) {
                    wand.addSpell((String)spellName);
                }
            }
            if ((materialList = wandConfig.getList("materials")) != null) {
                for (Object materialKey : materialList) {
                    if (!Wand.isValidMaterial((String)materialKey)) {
                        controller.getPlugin().getLogger().info("Unknown material: " + materialKey);
                        continue;
                    }
                    wand.addMaterial((String)materialKey, false, true);
                }
            }
            wand.configureProperties(wandConfig);
            if (wandConfig.getBoolean("organize", false)) {
                wand.organizeInventory(owner);
            }
        }
        if (owner != null) {
            wand.takeOwnership(owner.getPlayer());
        }
        wand.setDescription(wandDescription);
        wand.setName(wandName);
        wand.saveState(true);
        return wand;
    }

    public void add(Wand other) {
        if (!this.modifiable || !other.modifiable) {
            return;
        }
        this.costReduction = Math.max(this.costReduction, other.costReduction);
        this.power = Math.max(this.power, other.power);
        this.damageReduction = Math.max(this.damageReduction, other.damageReduction);
        this.damageReductionPhysical = Math.max(this.damageReductionPhysical, other.damageReductionPhysical);
        this.damageReductionProjectiles = Math.max(this.damageReductionProjectiles, other.damageReductionProjectiles);
        this.damageReductionFalling = Math.max(this.damageReductionFalling, other.damageReductionFalling);
        this.damageReductionFire = Math.max(this.damageReductionFire, other.damageReductionFire);
        this.damageReductionExplosions = Math.max(this.damageReductionExplosions, other.damageReductionExplosions);
        this.healthRegeneration = Math.max(this.healthRegeneration, other.healthRegeneration);
        this.hungerRegeneration = Math.max(this.hungerRegeneration, other.hungerRegeneration);
        this.speedIncrease = Math.max(this.speedIncrease, other.speedIncrease);
        Color color1 = Color.fromBGR((int)this.effectColor);
        Color color2 = Color.fromBGR((int)other.effectColor);
        Color newColor = color1.mixColors(new Color[]{color2});
        this.effectColor = newColor.asRGB();
        boolean bl = this.effectBubbles = this.effectBubbles || other.effectBubbles;
        if (this.effectParticle == null) {
            this.effectParticle = other.effectParticle;
            this.effectParticleData = other.effectParticleData;
            this.effectParticleCount = other.effectParticleCount;
        }
        if (this.costReduction >= 1.0f) {
            this.xpRegeneration = 0;
            this.xpMax = 0;
            this.xp = 0;
        } else {
            this.xpRegeneration = Math.max(this.xpRegeneration, other.xpRegeneration);
            this.xpMax = Math.max(this.xpMax, other.xpMax);
            this.xp = Math.max(this.xp, other.xp);
        }
        this.uses = this.uses == 0 || other.uses == 0 ? 0 : (this.uses += other.uses);
        Set<String> spells = other.getSpells();
        for (String spell : spells) {
            this.addSpell(spell, false);
        }
        Set<String> materials = other.getMaterialKeys();
        for (String material : materials) {
            this.addMaterial(material, false, true);
        }
        this.saveState();
        this.updateName();
        this.updateLore();
    }

    public void configureProperties(ConfigurationNode wandConfig) {
        this.configureProperties(wandConfig, false);
    }

    public void configureProperties(ConfigurationNode wandConfig, boolean safe) {
        this.modifiable = wandConfig.getBoolean("modifiable", this.modifiable);
        float _costReduction = (float)wandConfig.getDouble("cost_reduction", this.costReduction);
        this.costReduction = safe ? Math.max(_costReduction, this.costReduction) : _costReduction;
        float _cooldownReduction = (float)wandConfig.getDouble("cooldown_reduction", this.cooldownReduction);
        this.cooldownReduction = safe ? Math.max(_cooldownReduction, this.cooldownReduction) : _cooldownReduction;
        float _power = (float)wandConfig.getDouble("power", this.power);
        this.power = safe ? Math.max(_power, this.power) : _power;
        float _damageReduction = (float)wandConfig.getDouble("protection", this.damageReduction);
        this.damageReduction = safe ? Math.max(_damageReduction, this.damageReduction) : _damageReduction;
        float _damageReductionPhysical = (float)wandConfig.getDouble("protection_physical", this.damageReductionPhysical);
        this.damageReductionPhysical = safe ? Math.max(_damageReductionPhysical, this.damageReductionPhysical) : _damageReductionPhysical;
        float _damageReductionProjectiles = (float)wandConfig.getDouble("protection_projectiles", this.damageReductionProjectiles);
        this.damageReductionProjectiles = safe ? Math.max(_damageReductionProjectiles, this.damageReductionPhysical) : _damageReductionProjectiles;
        float _damageReductionFalling = (float)wandConfig.getDouble("protection_falling", this.damageReductionFalling);
        this.damageReductionFalling = safe ? Math.max(_damageReductionFalling, this.damageReductionFalling) : _damageReductionFalling;
        float _damageReductionFire = (float)wandConfig.getDouble("protection_fire", this.damageReductionFire);
        this.damageReductionFire = safe ? Math.max(_damageReductionFire, this.damageReductionFire) : _damageReductionFire;
        float _damageReductionExplosions = (float)wandConfig.getDouble("protection_explosions", this.damageReductionExplosions);
        this.damageReductionExplosions = safe ? Math.max(_damageReductionExplosions, this.damageReductionExplosions) : _damageReductionExplosions;
        int _xpRegeneration = wandConfig.getInt("xp_regeneration", this.xpRegeneration);
        this.xpRegeneration = safe ? Math.max(_xpRegeneration, this.xpRegeneration) : _xpRegeneration;
        int _xpMax = wandConfig.getInt("xp_max", this.xpMax);
        this.xpMax = safe ? Math.max(_xpMax, this.xpMax) : _xpMax;
        int _xp = wandConfig.getInt("xp", this.xp);
        this.xp = safe ? Math.max(_xp, this.xp) : _xp;
        int _healthRegeneration = wandConfig.getInt("health_regeneration", this.healthRegeneration);
        this.healthRegeneration = safe ? Math.max(_healthRegeneration, this.healthRegeneration) : _healthRegeneration;
        int _hungerRegeneration = wandConfig.getInt("hunger_regeneration", this.hungerRegeneration);
        this.hungerRegeneration = safe ? Math.max(_hungerRegeneration, this.hungerRegeneration) : _hungerRegeneration;
        int _uses = wandConfig.getInt("uses", this.uses);
        this.uses = safe ? Math.max(_uses, this.uses) : _uses;
        float _speedIncrease = (float)wandConfig.getDouble("haste", this.speedIncrease);
        float f = this.speedIncrease = safe ? Math.max(_speedIncrease, this.speedIncrease) : _speedIncrease;
        if (wandConfig.containsKey("effect_color") && !safe) {
            try {
                this.effectColor = Integer.parseInt(wandConfig.getString("effect_color", "0"), 16);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (wandConfig.containsKey("effect_bubbles")) {
            boolean _effectBubbles = wandConfig.getBoolean("effect_bubbles", this.effectBubbles);
            boolean bl = safe ? _effectBubbles || this.effectBubbles : (this.effectBubbles = _effectBubbles);
        }
        if (wandConfig.containsKey("effect_particle") && !safe) {
            this.parseParticleEffect(wandConfig.getString("effect_particle"));
        }
        if (wandConfig.containsKey("effect_particle_data") && !safe) {
            this.effectParticleData = Float.parseFloat(wandConfig.getString("effect_particle_data"));
        }
        if (wandConfig.containsKey("effect_particle_count") && !safe) {
            this.effectParticleCount = Integer.parseInt(wandConfig.getString("effect_particle_count"));
        }
        this.mode = Wand.parseWandMode(wandConfig.getString("mode"), this.mode);
        this.owner = wandConfig.getString("owner", this.owner);
        this.description = wandConfig.getString("description", this.description);
        this.saveState();
        this.updateName();
        this.updateLore();
    }

    public static void loadTemplates(ConfigurationNode properties) {
        wandTemplates.clear();
        List<String> wandKeys = properties.getKeys();
        for (String key : wandKeys) {
            ConfigurationNode wandNode = properties.getNode(key);
            wandNode.setProperty("key", key);
            ConfigurationNode existing = wandTemplates.get(key);
            if (existing != null) {
                List<String> overrideKeys = existing.getKeys();
                for (String propertyKey : overrideKeys) {
                    existing.setProperty(propertyKey, existing.getProperty(key));
                }
            } else {
                wandTemplates.put(key, wandNode);
            }
            if (!wandNode.getBoolean("enabled", true)) {
                wandTemplates.remove(key);
            }
            if (!key.equals("random")) continue;
            WandLevel.mapLevels(wandNode);
        }
    }

    public static Collection<String> getWandKeys() {
        return wandTemplates.keySet();
    }

    public static Collection<ConfigurationNode> getWandTemplates() {
        return wandTemplates.values();
    }

    public static WandMode parseWandMode(String modeString, WandMode defaultValue) {
        WandMode[] wandModeArray = WandMode.values();
        int n = wandModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            WandMode testMode = wandModeArray[n2];
            if (testMode.name().equalsIgnoreCase(modeString)) {
                return testMode;
            }
            ++n2;
        }
        return defaultValue;
    }

    public static MaterialBrushData parseMaterialKey(String materialKey) {
        if (materialKey == null || materialKey.length() == 0) {
            return null;
        }
        Material material = Material.DIRT;
        byte data = 0;
        String schematicName = "";
        String[] pieces = StringUtils.split((String)materialKey, (String)":");
        if (materialKey.equals(ERASE_MATERIAL_KEY)) {
            material = EraseMaterial;
        } else if (materialKey.equals(COPY_MATERIAL_KEY)) {
            material = CopyMaterial;
        } else if (materialKey.equals(CLONE_MATERIAL_KEY)) {
            material = CloneMaterial;
        } else if (materialKey.equals(REPLICATE_MATERIAL_KEY)) {
            material = ReplicateMaterial;
        } else if (materialKey.equals(MAP_MATERIAL_KEY)) {
            material = MapMaterial;
        } else if (SchematicsEnabled && pieces[0].equals(SCHEMATIC_MATERIAL_KEY)) {
            material = SchematicMaterial;
            schematicName = pieces[1];
        } else {
            try {
                if (pieces.length > 0) {
                    try {
                        Integer id = Integer.parseInt(pieces[0]);
                        material = Material.getMaterial((int)id);
                    }
                    catch (Exception ex) {
                        material = Material.getMaterial((String)pieces[0].toUpperCase());
                    }
                }
                if (material != null && !material.isBlock()) {
                    material = null;
                }
            }
            catch (Exception ex) {
                material = null;
            }
            try {
                if (pieces.length > 1) {
                    data = Byte.parseByte(pieces[1]);
                }
            }
            catch (Exception ex) {
                data = 0;
            }
        }
        if (material == null) {
            return null;
        }
        return new MaterialBrushData(material, data, schematicName);
    }

    public static boolean isValidMaterial(String materialKey) {
        return Wand.parseMaterialKey(materialKey) != null;
    }

    private void updateActiveMaterial() {
        if (this.mage == null) {
            return;
        }
        if (this.activeMaterial == null) {
            this.mage.clearBuildingMaterial();
        } else {
            String[] pieces = StringUtils.split((String)this.activeMaterial, (String)":");
            MaterialBrush brush = this.mage.getBrush();
            if (this.activeMaterial.equals(COPY_MATERIAL_KEY)) {
                brush.enableCopying();
            } else if (this.activeMaterial.equals(CLONE_MATERIAL_KEY)) {
                brush.enableCloning();
            } else if (this.activeMaterial.equals(REPLICATE_MATERIAL_KEY)) {
                brush.enableReplication();
            } else if (this.activeMaterial.equals(MAP_MATERIAL_KEY)) {
                brush.enableMap();
            } else if (this.activeMaterial.equals(ERASE_MATERIAL_KEY)) {
                brush.enableErase();
            } else if (pieces.length > 1 && pieces[0].equals(SCHEMATIC_MATERIAL_KEY)) {
                brush.enableSchematic(pieces[1]);
            } else {
                MaterialBrushData material = Wand.parseMaterialKey(this.activeMaterial);
                if (material != null) {
                    brush.setMaterial(material.getMaterial(), material.getData());
                }
            }
        }
    }

    public void toggleInventory() {
        if (!this.hasInventory) {
            return;
        }
        if (!this.isInventoryOpen()) {
            this.openInventory();
        } else {
            this.closeInventory();
        }
    }

    public void cycleInventory() {
        if (!this.hasInventory) {
            return;
        }
        if (this.isInventoryOpen()) {
            this.saveInventory();
            this.openInventoryPage = (this.openInventoryPage + 1) % this.inventories.size();
            this.updateInventory();
            if (this.mage != null && this.inventories.size() > 1) {
                this.mage.playSound(Sound.CHEST_OPEN, 0.3f, 1.5f);
                this.mage.getPlayer().updateInventory();
            }
        }
    }

    private void openInventory() {
        if (this.mage == null) {
            return;
        }
        WandMode wandMode = this.getMode();
        if (wandMode == WandMode.CHEST) {
            int i = 0;
            while (i < 9) {
                ItemStack hotbarItem = this.hotbar.getItem(i);
                if (hotbarItem != null && hotbarItem.getType() != Material.AIR) {
                    this.hotbar.setItem(i, null);
                    this.addToInventory(hotbarItem);
                }
                ++i;
            }
            this.inventoryIsOpen = true;
            this.mage.playSound(Sound.CHEST_OPEN, 0.4f, 0.2f);
            this.updateInventory();
            this.mage.getPlayer().openInventory(this.getDisplayInventory());
        } else if (wandMode == WandMode.INVENTORY) {
            if (this.mage.hasStoredInventory()) {
                return;
            }
            if (this.mage.storeInventory()) {
                this.inventoryIsOpen = true;
                this.mage.playSound(Sound.CHEST_OPEN, 0.4f, 0.2f);
                this.updateInventory();
                this.mage.getPlayer().updateInventory();
            }
        }
    }

    public void closeInventory() {
        if (!this.isInventoryOpen()) {
            return;
        }
        this.saveInventory();
        this.inventoryIsOpen = false;
        if (this.mage != null) {
            this.mage.playSound(Sound.CHEST_CLOSE, 0.4f, 0.2f);
            if (this.getMode() == WandMode.INVENTORY) {
                this.mage.restoreInventory();
                Player player = this.mage.getPlayer();
                player.setItemInHand(this.item);
                player.updateInventory();
            } else {
                this.mage.getPlayer().closeInventory();
            }
        }
        this.saveState();
    }

    protected void updateSpeed(Player player) {
        if (this.speedIncrease > 0.0f) {
            try {
                float newWalkSpeed = this.defaultWalkSpeed + this.speedIncrease * WandLevel.maxWalkSpeedIncrease;
                newWalkSpeed = Math.min(WandLevel.maxWalkSpeed, newWalkSpeed);
                if (newWalkSpeed != player.getWalkSpeed()) {
                    player.setWalkSpeed(newWalkSpeed);
                }
                float newFlySpeed = this.defaultFlySpeed + this.speedIncrease * WandLevel.maxFlySpeedIncrease;
                if ((newFlySpeed = Math.min(WandLevel.maxFlySpeed, newFlySpeed)) != player.getFlySpeed()) {
                    player.setFlySpeed(newFlySpeed);
                }
            }
            catch (Exception ex2) {
                try {
                    player.setWalkSpeed(this.defaultWalkSpeed);
                    player.setFlySpeed(this.defaultFlySpeed);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void activate(Mage mage) {
        Player player = mage.getPlayer();
        if (!Wand.hasActiveWand(player)) {
            this.controller.getLogger().warning("Wand activated without holding a wand!");
            try {
                throw new Exception("Wand activated without holding a wand!");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
        }
        this.activate(mage, player.getItemInHand());
    }

    public void activate(Mage mage, ItemStack wandItem) {
        this.item = wandItem;
        this.mage = mage;
        Player player = mage.getPlayer();
        this.saveState();
        mage.setActiveWand(this);
        if (this.owner.length() == 0) {
            this.takeOwnership(player);
        }
        this.updateSpeed(player);
        if (this.usesMana()) {
            this.storedXpLevel = player.getLevel();
            this.storedXpProgress = player.getExp();
            this.storedXp = 0;
            this.updateMana();
        }
        this.updateActiveMaterial();
        this.updateName();
        this.updateLore();
        this.updateEffects();
    }

    protected void updateEffects() {
        if (this.mage == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        if (player == null) {
            return;
        }
        if (this.effectBubbles) {
            InventoryUtils.addPotionEffect((LivingEntity)player, this.effectColor);
        }
        if (this.effectParticle != null && this.particleCounter++ % this.particleFrequency == 0) {
            if (this.effectPlayer == null) {
                this.effectPlayer = new EffectRing((Plugin)this.controller.getPlugin());
                this.effectPlayer.setParticleCount(2);
                this.effectPlayer.setIterations(2);
                this.effectPlayer.setRadius(2.0f);
                this.effectPlayer.setSize(5);
                this.effectPlayer.setMaterial(this.mage.getLocation().getBlock().getRelative(BlockFace.DOWN));
            }
            this.effectPlayer.setParticleType(this.effectParticle);
            this.effectPlayer.setParticleData(this.effectParticleData);
            this.effectPlayer.setParticleCount(this.effectParticleCount);
            this.effectPlayer.start(player.getEyeLocation(), null);
        }
    }

    protected void updateMana() {
        if (this.mage != null && this.xpMax > 0 && this.xpRegeneration > 0) {
            Player player = this.mage.getPlayer();
            player.setLevel(0);
            player.setExp((float)this.xp / (float)this.xpMax);
        }
    }

    public boolean isInventoryOpen() {
        return this.mage != null && this.inventoryIsOpen;
    }

    public void deactivate() {
        if (this.mage == null) {
            return;
        }
        this.saveState();
        if (this.effectBubbles) {
            InventoryUtils.removePotionEffect((LivingEntity)this.mage.getPlayer());
        }
        this.mage.deactivateAllSpells();
        if (this.isInventoryOpen()) {
            this.closeInventory();
        }
        this.mage.restoreInventory();
        if (this.usesMana()) {
            this.mage.getPlayer().setExp(this.storedXpProgress);
            this.mage.getPlayer().setLevel(this.storedXpLevel);
            this.mage.getPlayer().giveExp(this.storedXp);
            this.storedXp = 0;
            this.storedXpProgress = 0.0f;
            this.storedXpLevel = 0;
        }
        if (this.speedIncrease > 0.0f) {
            try {
                this.mage.getPlayer().setWalkSpeed(this.defaultWalkSpeed);
                this.mage.getPlayer().setFlySpeed(this.defaultFlySpeed);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.mage.setActiveWand(null);
        this.mage = null;
    }

    public Spell getActiveSpell() {
        if (this.mage == null) {
            return null;
        }
        return this.mage.getSpell(this.activeSpell);
    }

    public boolean cast() {
        Spell spell = this.getActiveSpell();
        if (spell != null && spell.cast()) {
            this.use();
            return true;
        }
        return false;
    }

    protected void use() {
        if (this.mage == null) {
            return;
        }
        if (this.uses > 0) {
            --this.uses;
            if (this.uses <= 0) {
                Player player = this.mage.getPlayer();
                this.mage.playSound(Sound.ITEM_BREAK, 1.0f, 0.8f);
                PlayerInventory playerInventory = player.getInventory();
                playerInventory.setItemInHand(new ItemStack(Material.AIR, 1));
                player.updateInventory();
                this.deactivate();
            } else {
                this.updateName();
                this.updateLore();
                this.saveState();
            }
        }
    }

    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        if (this.mage == null) {
            return;
        }
        if (this.usesMana()) {
            this.storedXp += event.getAmount();
            event.setAmount(0);
        }
    }

    public void tick() {
        if (this.mage == null) {
            return;
        }
        Player player = this.mage.getPlayer();
        this.updateSpeed(player);
        if (this.usesMana()) {
            this.xp = Math.min(this.xpMax, this.xp + this.xpRegeneration);
            this.updateMana();
        }
        double maxHealth = player.getMaxHealth();
        if (this.healthRegeneration > 0 && player.getHealth() < maxHealth) {
            player.setHealth(Math.min(maxHealth, player.getHealth() + (double)this.healthRegeneration));
        }
        double maxFoodLevel = 20.0;
        if (this.hungerRegeneration > 0 && (double)player.getFoodLevel() < maxFoodLevel) {
            player.setExhaustion(0.0f);
            player.setFoodLevel(Math.min(20, player.getFoodLevel() + this.hungerRegeneration));
        }
        if (this.damageReductionFire > 0.0f && player.getFireTicks() > 0) {
            player.setFireTicks(0);
        }
        this.updateEffects();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Wand)) {
            return false;
        }
        Wand otherWand = (Wand)other;
        if (this.id == null || otherWand.id == null) {
            return false;
        }
        return otherWand.id.equals(this.id);
    }

    public MagicController getMaster() {
        return this.controller;
    }

    public void cycleSpells(ItemStack newItem) {
        Set<String> spellsSet;
        ArrayList<String> spells;
        if (Wand.isWand(newItem)) {
            this.item = newItem;
        }
        if ((spells = new ArrayList<String>(spellsSet = this.getSpells())).size() == 0) {
            return;
        }
        if (this.activeSpell == null) {
            this.activeSpell = spells.get(0).split("@")[0];
            return;
        }
        int spellIndex = 0;
        int i = 0;
        while (i < spells.size()) {
            if (spells.get(i).split("@")[0].equals(this.activeSpell)) {
                spellIndex = i;
                break;
            }
            ++i;
        }
        spellIndex = (spellIndex + 1) % spells.size();
        this.setActiveSpell(spells.get(spellIndex).split("@")[0]);
    }

    public void cycleMaterials(ItemStack newItem) {
        Set<String> materialsSet;
        ArrayList<String> materials;
        if (Wand.isWand(newItem)) {
            this.item = newItem;
        }
        if ((materials = new ArrayList<String>(materialsSet = this.getMaterialKeys())).size() == 0) {
            return;
        }
        if (this.activeMaterial == null) {
            this.activeMaterial = materials.get(0).split("@")[0];
            return;
        }
        int materialIndex = 0;
        int i = 0;
        while (i < materials.size()) {
            if (materials.get(i).split("@")[0].equals(this.activeMaterial)) {
                materialIndex = i;
                break;
            }
            ++i;
        }
        materialIndex = (materialIndex + 1) % materials.size();
        this.activateBrush(materials.get(materialIndex).split("@")[0]);
    }

    public boolean hasExperience() {
        return this.xpRegeneration > 0;
    }

    public void organizeInventory(Mage mage) {
        WandOrganizer organizer = new WandOrganizer(this, mage);
        organizer.organize();
        this.openInventoryPage = 0;
        this.saveState();
    }

    public void organizeInventory() {
        WandOrganizer organizer = new WandOrganizer(this, null);
        organizer.organize();
        this.openInventoryPage = 0;
        this.saveState();
    }

    public Mage getActivePlayer() {
        return this.mage;
    }

    public String getId() {
        return this.id;
    }

    protected void clearInventories() {
        this.inventories.clear();
    }

    public int getEffectColor() {
        return this.effectColor;
    }

    public Inventory getHotbar() {
        return this.hotbar;
    }

    public WandMode getMode() {
        return this.mode != null ? this.mode : this.controller.getDefaultWandMode();
    }
}

