/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.TNTPrimed;
import org.bukkit.util.Vector;

public class GrenadeSpell
extends Spell {
    int defaultSize = 6;

    public SpellResult onCast(ConfigurationNode parameters) {
        int size = parameters.getInt("size", this.defaultSize);
        size = (int)(this.mage.getRadiusMultiplier() * (float)size);
        int fuse = parameters.getInt("fuse", 80);
        boolean useFire = parameters.getBoolean("fire", false);
        Block target = this.getNextBlock();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (!this.mage.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        Location loc = target.getLocation();
        TNTPrimed grenade = (TNTPrimed)this.getPlayer().getWorld().spawnEntity(loc, EntityType.PRIMED_TNT);
        if (grenade == null) {
            return SpellResult.FAIL;
        }
        Vector aim = this.mage.getLocation().getDirection();
        grenade.setVelocity(aim);
        grenade.setYield((float)size);
        grenade.setFuseTicks(fuse);
        grenade.setIsIncendiary(useFire);
        return SpellResult.CAST;
    }
}

