/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class BlinkSpell
extends Spell {
    private int verticalSearchDistance = 255;

    protected SpellResult ascend() {
        Location targetLocation = this.getPlayer().getLocation();
        targetLocation.setY(targetLocation.getY() + 2.0);
        Location location = this.findPlaceToStand(targetLocation, true);
        if (location != null) {
            this.castMessage("You ascend");
            this.setTarget(location);
            this.getPlayer().teleport(location);
            return SpellResult.CAST;
        }
        this.mage.castMessage("Nowhere to go up");
        return SpellResult.NO_TARGET;
    }

    protected SpellResult descend() {
        Location targetLocation = this.getPlayer().getLocation();
        targetLocation.setY(targetLocation.getY() - 2.0);
        Location location = this.findPlaceToStand(targetLocation, false);
        if (location != null) {
            this.castMessage("You descend");
            this.setTarget(location);
            this.getPlayer().teleport(location);
            return SpellResult.CAST;
        }
        this.mage.castMessage("Nowhere to go down");
        return SpellResult.NO_TARGET;
    }

    public SpellResult onCast(ConfigurationNode parameters) {
        String elevateType = parameters.getString("type", "");
        boolean autoAscend = parameters.getBoolean("allow_ascend", true);
        boolean autoDescend = parameters.getBoolean("allow_descend", true);
        boolean autoPassthrough = parameters.getBoolean("allow_passthrough", true);
        if (elevateType.equals("descend") || this.getYRotation() < -80.0 && autoDescend) {
            return this.descend();
        }
        if (elevateType.equals("ascend") || this.getYRotation() > 80.0 && autoAscend) {
            return this.ascend();
        }
        if (autoPassthrough) {
            Block firstBlock = this.getNextBlock();
            if (firstBlock != null && firstBlock.getType() != Material.AIR && !this.isWater(firstBlock.getType())) {
                this.setReverseTargeting(true);
                this.setTargetHeightRequired(2);
                this.targetThrough(Material.AIR);
            } else {
                this.targetThrough(Material.GLASS);
                this.targetThrough(Material.THIN_GLASS);
                this.targetThrough(Material.WATER);
                this.targetThrough(Material.STATIONARY_WATER);
            }
        } else {
            this.targetThrough(Material.GLASS);
            this.targetThrough(Material.THIN_GLASS);
            this.targetThrough(Material.WATER);
            this.targetThrough(Material.STATIONARY_WATER);
        }
        Block target = this.getTargetBlock();
        Block face = this.getLastBlock();
        if (target == null) {
            this.castMessage("Nowhere to blink to");
            return SpellResult.NO_TARGET;
        }
        World world = this.getPlayer().getWorld();
        Block destination = face;
        int distanceUp = 0;
        int distanceDown = 0;
        if (this.isReverseTargeting()) {
            destination = target;
        }
        Block groundBlock = destination.getRelative(BlockFace.DOWN);
        while (distanceDown < this.verticalSearchDistance && !this.isOkToStandOn(groundBlock.getType())) {
            destination = groundBlock;
            groundBlock = destination.getRelative(BlockFace.DOWN);
            ++distanceDown;
        }
        Block ledge = null;
        if (!this.isReverseTargeting()) {
            ledge = target;
            Block inFront = face;
            Block oneUp = null;
            Block twoUp = null;
            do {
                oneUp = ledge.getRelative(BlockFace.UP);
                twoUp = oneUp.getRelative(BlockFace.UP);
                inFront = inFront.getRelative(BlockFace.UP);
                ledge = ledge.getRelative(BlockFace.UP);
            } while (++distanceUp < this.verticalSearchDistance && this.isOkToStandIn(inFront.getType()) && (!this.isOkToStandOn(groundBlock.getType()) || !this.isOkToStandIn(oneUp.getType()) || !this.isOkToStandIn(twoUp.getType())));
        }
        if (ledge != null && distanceUp < distanceDown) {
            destination = ledge;
        }
        Block oneUp = destination.getRelative(BlockFace.UP);
        Block twoUp = oneUp.getRelative(BlockFace.UP);
        if (!this.isOkToStandIn(oneUp.getType()) || !this.isOkToStandIn(twoUp.getType())) {
            this.castMessage("You can't fit in there!");
            return SpellResult.NO_TARGET;
        }
        this.castMessage("Blink!");
        Location targetLocation = new Location(world, (double)destination.getX() + 0.5, (double)destination.getY(), (double)destination.getZ() + 0.5, this.getPlayer().getLocation().getYaw(), this.getPlayer().getLocation().getPitch());
        this.setTarget(targetLocation);
        this.getPlayer().teleport(targetLocation);
        return SpellResult.CAST;
    }
}

