/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.effects.EffectRing;
import com.elmakers.mine.bukkit.effects.EffectTrail;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.Collection;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.util.Vector;

public class PotionEffectSpell
extends Spell {
    public SpellResult onCast(ConfigurationNode parameters) {
        Location effectLocation;
        Player targetEntity = null;
        String targetType = parameters.getString("target", "other");
        if (!targetType.equals("self")) {
            this.targetEntity(LivingEntity.class);
            Target target = this.getTarget();
            if (target != null && target.isEntity() && target.getEntity() instanceof LivingEntity) {
                targetEntity = (LivingEntity)target.getEntity();
            }
        }
        if (targetEntity == null && !targetType.equals("other")) {
            targetEntity = this.getPlayer();
        }
        if (targetEntity == null) {
            return SpellResult.NO_TARGET;
        }
        ParticleType particleType = ParticleType.fromName(parameters.getString("particle", ""), ParticleType.INSTANT_SPELL);
        if (targetEntity == this.getPlayer()) {
            effectLocation = this.getPlayer().getEyeLocation();
            EffectRing effect = new EffectRing((Plugin)this.controller.getPlugin(), effectLocation, 4, 8);
            effect.setParticleType(particleType);
            effect.setParticleCount(8);
            effect.setEffectData(2.0f);
            effect.setInvert(true);
            effect.start();
        } else {
            Mage targetMage;
            if (targetEntity instanceof Player && (targetMage = this.controller.getMage(targetEntity)).isSuperProtected()) {
                return SpellResult.NO_TARGET;
            }
            effectLocation = this.getPlayer().getEyeLocation();
            Vector effectDirection = effectLocation.getDirection();
            EffectTrail effect = new EffectTrail((Plugin)this.controller.getPlugin(), effectLocation, effectDirection, 32);
            effect.setParticleType(particleType);
            effect.setParticleCount(8);
            effect.setEffectData(2.0f);
            effect.setSpeed(3.0f);
            effect.start();
        }
        Collection<PotionEffect> effects = PotionEffectSpell.getPotionEffects(parameters);
        targetEntity.addPotionEffects(effects);
        return SpellResult.SUCCESS;
    }
}

