/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.populator;

import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.plugins.magic.populator.MagicRunnable;
import com.elmakers.mine.bukkit.plugins.magic.populator.WandChestPopulator;
import com.elmakers.mine.bukkit.utilities.NMSUtils;
import java.util.Random;
import org.bukkit.Chunk;
import org.bukkit.World;

public class WandChestRunnable
extends MagicRunnable {
    private World world;
    private int dx = 1;
    private int dz = 0;
    private int segmentLength = 1;
    private int x;
    private int z;
    private int segmentPassed = 0;
    private int chunksProcessed = 0;
    private boolean generate = false;
    static final int messageInterval = 100;
    WandChestPopulator populator;
    Random random;

    public WandChestRunnable(MagicController controller, World world, int maxy) {
        super(controller.getLogger());
        this.world = world;
        this.random = new Random();
        if (maxy > 0) {
            this.populator = controller.getWandChestPopulator();
            this.populator.setMaxY(maxy);
        }
    }

    public void finish() {
        super.finish();
        this.populator = null;
        this.world = null;
    }

    public void setGenerate(boolean generate) {
        this.generate = generate;
    }

    public void run() {
        Chunk chunk = this.world.getChunkAt(this.x, this.z);
        if (!chunk.isLoaded()) {
            chunk.load(this.generate);
            if (this.generate) {
                this.logger.info("Loading/Generating chunk at " + chunk.getX() + ", " + chunk.getZ());
            }
        } else {
            if (!NMSUtils.isDone(chunk)) {
                if (this.generate) {
                    if (!chunk.load(true)) {
                        this.logger.info("Failed to generate chunk at " + chunk.getX() + ", " + chunk.getZ());
                        this.finish();
                    } else {
                        this.logger.info("Generating chunk at " + chunk.getX() + ", " + chunk.getZ());
                        this.finish();
                    }
                } else {
                    this.logger.info("Done populating chests, found ungenerated chunk");
                    this.finish();
                }
                return;
            }
            if (this.chunksProcessed % 100 == 0) {
                if (this.populator != null) {
                    this.logger.info("Looking for chests, processed " + this.chunksProcessed + " chunks");
                } else {
                    this.logger.info("Looking for wands, searched " + this.chunksProcessed + " chunks");
                }
            }
            ++this.chunksProcessed;
            if (this.populator != null) {
                this.populator.populate(this.world, this.random, chunk);
            }
            this.x += this.dx;
            this.z += this.dz;
            ++this.segmentPassed;
            if (this.segmentPassed == this.segmentLength) {
                this.segmentPassed = 0;
                int odx = this.dx;
                this.dx = -this.dz;
                this.dz = odx;
                if (this.dz == 0) {
                    ++this.segmentLength;
                }
            }
        }
    }
}

