/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effects;

import com.elmakers.mine.bukkit.effects.EffectPlayer;
import com.elmakers.mine.bukkit.effects.EffectRing;
import com.elmakers.mine.bukkit.effects.EffectTrail;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class SpellEffect {
    public int speed = 2;
    public int period = 2;
    public int ringSize = 8;
    public int range = 16;
    public float particleOffsetX = 0.5f;
    public float particleOffsetY = 0.5f;
    public float particleOffsetZ = 0.5f;
    public ParticleType particleType = ParticleType.SPELL;
    public Effect effect = null;
    public int particleCount = 8;
    public int data = 0;
    private Color color1 = Color.PURPLE;

    public EffectPlayer startTrailEffect(Mage mage, Location location, Location target) {
        Vector toTarget = target.toVector().subtract(location.toVector());
        int length = (int)Math.ceil(toTarget.length());
        return this.startTrailEffect(mage, location, toTarget, length);
    }

    public EffectPlayer startTrailEffect(Mage mage, Location playerLocation) {
        return this.startTrailEffect(mage, playerLocation, playerLocation.getDirection());
    }

    public EffectPlayer startTrailEffect(Mage mage, Location location, Vector direction) {
        return this.startTrailEffect(mage, location, direction, this.range);
    }

    protected EffectPlayer startTrailEffect(Mage mage, Location location, Vector direction, int length) {
        EffectTrail effect = new EffectTrail((Plugin)mage.getController().getPlugin(), location, direction, length);
        this.startEffect(mage, effect);
        return effect;
    }

    public EffectPlayer startRingEffect(Mage mage, Location location) {
        EffectRing effect = new EffectRing((Plugin)mage.getController().getPlugin(), location, this.range, this.ringSize);
        this.startEffect(mage, effect);
        return effect;
    }

    protected void startEffect(Mage mage, EffectPlayer effectPlayer) {
        effectPlayer.setEffect(this.effect);
        effectPlayer.setData(this.data);
        effectPlayer.setParticleType(this.particleType);
        effectPlayer.setParticleCount(this.particleCount);
        Color effectColor = mage.getEffectColor();
        effectColor = effectColor == null ? this.color1 : effectColor;
        effectPlayer.setEffectData(effectColor.asRGB());
        effectPlayer.setParticleOffset(this.particleOffsetX, this.particleOffsetY, this.particleOffsetZ);
        effectPlayer.setSpeed(this.speed);
        effectPlayer.setPeriod(this.period);
        effectPlayer.start();
    }
}

