/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effects;

import com.elmakers.mine.bukkit.effects.EffectUtils;
import com.elmakers.mine.bukkit.effects.ParticleType;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.FireworkEffect;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;

public abstract class EffectPlayer
implements Runnable {
    protected final Plugin plugin;
    protected Effect effect = null;
    protected int period = 1;
    protected int data = 0;
    protected FireworkEffect fireworkEffect = null;
    protected int power = 0;
    protected ParticleType particleType = null;
    protected String particleSubType = "";
    protected float xOffset = 0.0f;
    protected float yOffset = 0.0f;
    protected float zOffset = 0.0f;
    protected float effectData = 0.0f;
    protected int particleCount = 10;

    public EffectPlayer(Plugin plugin) {
        this.plugin = plugin;
    }

    public void setEffect(Effect effect) {
        this.effect = effect;
    }

    public void setFireworkEffect(FireworkEffect fireworkEffect, int power) {
        this.fireworkEffect = fireworkEffect;
        this.power = power;
    }

    public void setParticleType(ParticleType particleType) {
        this.particleType = particleType;
    }

    public void setParticleSubType(String particleSubType) {
        this.particleSubType = particleSubType;
    }

    public void start() {
        this.schedule();
    }

    protected void schedule() {
        Bukkit.getScheduler().scheduleSyncDelayedTask(this.plugin, (Runnable)this, (long)this.period);
    }

    public void setPeriod(int period) {
        this.period = period;
    }

    public void setData(int data) {
        this.data = data;
    }

    protected void playEffect(Location location) {
        if (this.effect != null) {
            location.getWorld().playEffect(location, this.effect, this.data);
        }
        if (this.fireworkEffect != null) {
            EffectUtils.spawnFireworkEffect(location, this.fireworkEffect, this.power);
        }
        if (this.particleType != null) {
            EffectUtils.playEffect(location, this.particleType, this.particleSubType, this.xOffset, this.yOffset, this.zOffset, this.effectData, this.particleCount);
        }
    }

    public abstract void setSpeed(float var1);

    public float getEffectData() {
        return this.effectData;
    }

    public void setEffectData(float effectData) {
        this.effectData = effectData;
    }

    public int getParticleCount() {
        return this.particleCount;
    }

    public void setParticleCount(int particleCount) {
        this.particleCount = particleCount;
    }

    public void setParticleOffset(float xOffset, float yOffset, float zOffset) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }
}

