/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.MaterialAndData;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.bukkit.Material;
import org.bukkit.util.Vector;

public class Schematic {
    private static Class<?> vectorClass;
    private static Class<?> cuboidClipboardClass;
    private static Class<?> blockClass;
    private static Constructor<?> vectorConstructor;
    private static Method getBlockMethod;
    private static Method getIdMethod;
    private static Method getDataMethod;
    private static Method getSizeMethod;
    private static Method getBlockXMethod;
    private static Method getBlockYMethod;
    private static Method getBlockZMethod;
    private final Object weSchematic;
    private Vector center;
    private Vector size;

    private static boolean checkClasses() {
        try {
            if (vectorClass == null) {
                vectorClass = Class.forName("com.sk89q.worldedit.Vector");
            }
            if (vectorClass != null) {
                if (vectorConstructor == null) {
                    vectorConstructor = vectorClass.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
                if (getBlockXMethod == null) {
                    getBlockXMethod = vectorClass.getMethod("getBlockX", new Class[0]);
                }
                if (getBlockYMethod == null) {
                    getBlockYMethod = vectorClass.getMethod("getBlockY", new Class[0]);
                }
                if (getBlockZMethod == null) {
                    getBlockZMethod = vectorClass.getMethod("getBlockZ", new Class[0]);
                }
            }
            if (cuboidClipboardClass == null) {
                cuboidClipboardClass = Class.forName("com.sk89q.worldedit.CuboidClipboard");
            }
            if (cuboidClipboardClass != null) {
                if (getBlockMethod == null) {
                    getBlockMethod = cuboidClipboardClass.getMethod("getBlock", vectorClass);
                }
                if (getSizeMethod == null) {
                    getSizeMethod = cuboidClipboardClass.getMethod("getSize", new Class[0]);
                }
            }
            if (blockClass == null) {
                blockClass = Class.forName("com.sk89q.worldedit.foundation.Block");
            }
            if (blockClass != null) {
                if (getIdMethod == null) {
                    getIdMethod = blockClass.getMethod("getId", new Class[0]);
                }
                if (getDataMethod == null) {
                    getDataMethod = blockClass.getMethod("getData", new Class[0]);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return vectorClass != null && vectorConstructor != null && cuboidClipboardClass != null && getBlockMethod != null && blockClass != null && getSizeMethod != null && getBlockXMethod != null && getBlockYMethod != null && getBlockZMethod != null;
    }

    public Schematic(Object schematic) {
        this.weSchematic = schematic;
        if (Schematic.checkClasses()) {
            try {
                Object weSize = getSizeMethod.invoke(this.weSchematic, new Object[0]);
                this.size = new Vector(((Integer)getBlockXMethod.invoke(weSize, new Object[0])).intValue(), ((Integer)getBlockYMethod.invoke(weSize, new Object[0])).intValue(), ((Integer)getBlockZMethod.invoke(weSize, new Object[0])).intValue());
                this.center = new Vector(Math.floor(this.size.getBlockX() / 2), 0.0, Math.floor(this.size.getBlockZ() / 2));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (this.center == null) {
            this.center = new Vector(0, 0, 0);
        }
        if (this.size == null) {
            this.size = new Vector(0, 0, 0);
        }
    }

    public boolean contains(Vector v) {
        int x = v.getBlockX() + this.center.getBlockX();
        int y = v.getBlockY() + this.center.getBlockY();
        int z = v.getBlockZ() + this.center.getBlockZ();
        return x >= 0 && x <= this.size.getBlockX() && y >= 0 && y <= this.size.getBlockY() && z >= 0 && z <= this.size.getBlockZ();
    }

    public MaterialAndData getBlock(Vector v) {
        if (!Schematic.checkClasses()) {
            return null;
        }
        int x = v.getBlockX() + this.center.getBlockX();
        int y = v.getBlockY() + this.center.getBlockY();
        int z = v.getBlockZ() + this.center.getBlockZ();
        if (y < 0) {
            y = -y;
        }
        try {
            Object vector = vectorConstructor.newInstance(x, y, z);
            Object baseBlock = getBlockMethod.invoke(this.weSchematic, vector);
            return new MaterialAndData(Material.getMaterial((int)((Integer)getIdMethod.invoke(baseBlock, new Object[0]))), (byte)((Integer)getDataMethod.invoke(baseBlock, new Object[0])).intValue());
        }
        catch (ArrayIndexOutOfBoundsException vector) {
        }
        catch (InvocationTargetException vector) {
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

