/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.MaterialBrush;
import com.elmakers.mine.bukkit.blocks.SimpleBlockAction;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

public class ReplaceMaterialAction
extends SimpleBlockAction {
    protected Mage mage;
    protected MaterialBrush brush;
    protected Set<Material> replaceable = new HashSet<Material>();
    private boolean spawnFallingBlocks = false;
    private Vector fallingBlockVelocity = null;

    public ReplaceMaterialAction(Mage mage, Block targetBlock, MaterialBrush brush) {
        this.mage = mage;
        this.replaceable.add(targetBlock.getType());
        this.brush = brush;
    }

    public ReplaceMaterialAction(Mage playerSpells, MaterialBrush brush) {
        this.mage = playerSpells;
        this.brush = brush;
    }

    public void addReplaceable(Material material) {
        this.replaceable.add(material);
    }

    public SpellResult perform(Block block) {
        if (this.brush == null) {
            return SpellResult.FAILURE;
        }
        if (!this.mage.hasBuildPermission(block)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.mage.isIndestructible(block)) {
            return SpellResult.FAILURE;
        }
        if (this.replaceable == null || this.replaceable.contains(block.getType())) {
            Material previousMaterial = block.getType();
            byte previousData = block.getData();
            if (this.brush.isDifferent(block)) {
                this.brush.update(this.mage, block.getLocation());
                this.brush.modify(block);
                this.mage.getController().updateBlock(block);
                if (this.spawnFallingBlocks) {
                    FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation(), previousMaterial, previousData);
                    falling.setDropItem(false);
                    if (this.fallingBlockVelocity != null) {
                        falling.setVelocity(this.fallingBlockVelocity);
                    }
                }
            }
            super.perform(block);
            return SpellResult.SUCCESS;
        }
        return SpellResult.FAILURE;
    }
}

