/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.wand;

import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;

public class LostWand {
    private Location location;
    private String id;
    private String name;
    private String description;
    private String owner;

    public LostWand(String id, ConfigurationNode config) {
        this.id = id;
        this.load(config);
    }

    public LostWand(Wand wand, Location location) {
        this.update(wand, location);
    }

    public void update(Wand wand, Location location) {
        this.location = location;
        this.id = wand.getId();
        this.name = wand.getName();
        this.owner = wand.getOwner();
        this.description = wand.getHTMLDescription();
    }

    public void update(LostWand other) {
        this.location = other.location;
        this.name = other.getName();
        this.owner = other.getOwner();
        String description = other.getDescription();
        if (description != null && description.length() > 0) {
            this.description = description;
        }
    }

    public boolean isValid() {
        return this.location != null && this.id != null && this.id.length() > 0;
    }

    public void save(ConfigurationNode configNode) {
        try {
            configNode.setProperty("location", this.location);
            configNode.setProperty("name", this.name);
            configNode.setProperty("description", this.description);
            configNode.setProperty("owner", this.owner);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void load(ConfigurationNode configNode) {
        try {
            if (configNode == null) {
                return;
            }
            this.location = configNode.getLocation("location");
            this.name = configNode.getString("name");
            this.description = configNode.getString("description");
            this.owner = configNode.getString("owner");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof LostWand)) {
            return false;
        }
        LostWand other = (LostWand)obj;
        return other.id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }
}

