/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

public class TorchSpell
extends Spell {
    public SpellResult onCast(ConfigurationNode parameters) {
        if (parameters.containsKey("weather")) {
            String weatherString = parameters.getString("weather");
            World world = this.getLocation().getWorld();
            if (weatherString.equals("storm")) {
                world.setStorm(true);
                world.setThundering(true);
            } else {
                world.setStorm(false);
                world.setThundering(false);
            }
        }
        if (parameters.containsKey("time")) {
            long targetTime = 0L;
            String typeString = parameters.getString("time", "day");
            String timeDescription = "day";
            if (typeString.equalsIgnoreCase("toggle")) {
                long currentTime = this.getTime();
                typeString = currentTime > 13000L ? "day" : "night";
            }
            if (typeString.equalsIgnoreCase("night")) {
                targetTime = 13000L;
                timeDescription = "night";
            } else {
                try {
                    targetTime = Long.parseLong(typeString);
                    timeDescription = "raw: " + targetTime;
                }
                catch (NumberFormatException ex) {
                    targetTime = 0L;
                }
            }
            this.setTime(targetTime);
            this.castMessage("Changed time to " + timeDescription);
            return SpellResult.SUCCESS;
        }
        boolean allowNight = parameters.getBoolean("allow_night", false);
        boolean allowDay = parameters.getBoolean("allow_day", false);
        if (this.getYRotation() > 80.0 && allowDay) {
            this.castMessage("FLAME ON!");
            this.setTime(0L);
            return SpellResult.SUCCESS;
        }
        if (this.getYRotation() < -80.0 && allowNight) {
            this.castMessage("FLAME OFF!");
            this.setTime(13000L);
            return SpellResult.SUCCESS;
        }
        Block target = this.getTargetBlock();
        Block face = this.getLastBlock();
        if (target == null || face == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        boolean isAir = face.getType() == Material.AIR;
        boolean isAttachmentSlippery = target.getType() == Material.GLASS || target.getType() == Material.ICE;
        boolean replaceAttachment = target.getType() == Material.SNOW || target.getType() == Material.NETHERRACK || target.getType() == Material.SOUL_SAND;
        boolean isWater = face.getType() == Material.STATIONARY_WATER || face.getType() == Material.WATER;
        boolean isNether = target.getType() == Material.NETHERRACK || target.getType() == Material.SOUL_SAND;
        Material targetMaterial = Material.TORCH;
        if (isWater || isAttachmentSlippery || isNether) {
            targetMaterial = Material.GLOWSTONE;
            replaceAttachment = true;
        }
        boolean allowLightstone = parameters.getBoolean("allow_glowstone", false);
        if (face == null || !isAir && !isWater || targetMaterial == Material.GLOWSTONE && !allowLightstone) {
            this.castMessage("Can't put a torch there");
            return SpellResult.NO_TARGET;
        }
        if (!replaceAttachment) {
            target = face;
        }
        this.castMessage("Flame on!");
        BlockList torchBlock = new BlockList();
        target.setType(targetMaterial);
        torchBlock.add(target);
        this.mage.registerForUndo(torchBlock);
        this.controller.updateBlock(target);
        return SpellResult.SUCCESS;
    }
}

