/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class StairsSpell
extends BlockSpell {
    private int defaultDepth = 4;
    private int defaultWidth = 3;
    private int defaultHeight = 3;
    private int torchFrequency = 4;

    public SpellResult onCast(ConfigurationNode parameters) {
        Block targetBlock = this.getTargetBlock();
        if (targetBlock == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        this.defaultDepth = parameters.getInteger("depth", this.defaultDepth);
        this.defaultWidth = parameters.getInteger("width", this.defaultWidth);
        this.defaultHeight = parameters.getInteger("height", this.defaultHeight);
        this.torchFrequency = parameters.getInteger("torch_frequency", this.torchFrequency);
        this.createStairs(targetBlock);
        return SpellResult.SUCCESS;
    }

    protected void createStairs(Block targetBlock) {
        Block bottomBlock;
        BlockFace vertDirection = BlockFace.UP;
        BlockFace horzDirection = this.getPlayerFacing();
        int depth = this.defaultDepth;
        int height = this.defaultHeight;
        int width = this.defaultWidth;
        BlockList tunneledBlocks = new BlockList();
        BlockList stairBlocks = new BlockList();
        Material fillMaterial = targetBlock.getType();
        BlockFace toTheLeft = StairsSpell.goLeft(horzDirection);
        BlockFace toTheRight = StairsSpell.goRight(horzDirection);
        Block bottomLeftBlock = bottomBlock = targetBlock;
        int i = 0;
        while (i < width / 2) {
            bottomLeftBlock = bottomLeftBlock.getRelative(toTheLeft);
            ++i;
        }
        targetBlock = bottomLeftBlock;
        Material stairsMaterial = Material.COBBLESTONE_STAIRS;
        int d = 0;
        while (d < depth) {
            bottomBlock = bottomLeftBlock;
            int w = 0;
            while (w < width) {
                targetBlock = bottomBlock;
                int h = 0;
                while (h < height) {
                    if (this.isDestructible(targetBlock) && this.hasBuildPermission(targetBlock)) {
                        boolean useStairs;
                        Block checkBlock = null;
                        checkBlock = w == 0 ? targetBlock.getRelative(toTheLeft) : targetBlock.getRelative(toTheRight);
                        boolean useTorch = this.torchFrequency > 0 && (w == 0 || w == width - 1) && h == 1 && d % this.torchFrequency == 0 && checkBlock.getType() != Material.AIR;
                        boolean bl = useStairs = h == 0;
                        if (useStairs) {
                            stairBlocks.add(targetBlock);
                            targetBlock.setType(stairsMaterial);
                        } else if (useTorch) {
                            tunneledBlocks.add(targetBlock);
                            targetBlock.setType(Material.TORCH);
                        } else {
                            tunneledBlocks.add(targetBlock);
                            targetBlock.setType(Material.AIR);
                        }
                        Block standingBlock = targetBlock.getRelative(BlockFace.DOWN);
                        if (standingBlock.getType() == Material.AIR) {
                            stairBlocks.add(standingBlock);
                            standingBlock.setType(fillMaterial);
                        }
                    }
                    targetBlock = targetBlock.getRelative(BlockFace.UP);
                    ++h;
                }
                bottomBlock = bottomBlock.getRelative(toTheRight);
                ++w;
            }
            bottomLeftBlock = bottomLeftBlock.getRelative(horzDirection);
            bottomLeftBlock = bottomLeftBlock.getRelative(vertDirection);
            ++d;
        }
        this.mage.registerForUndo(tunneledBlocks);
        this.mage.registerForUndo(stairBlocks);
        this.castMessage("Tunneled through " + tunneledBlocks.size() + "blocks and created " + stairBlocks.size() + " stairs");
    }

    protected void createSpiralStairs(Block targetBlock) {
    }
}

