/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.effects.EffectTrail;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class ShrinkSpell
extends Spell {
    private int DEFAULT_PLAYER_DAMAGE = 1;
    private int DEFAULT_ENTITY_DAMAGE = 100;
    private static final int maxEffectRange = 16;
    private static final int effectSpeed = 1;
    private static final int effectPeriod = 2;
    private static final float particleData = 2.0f;
    private static final int particleCount = 6;

    public SpellResult onCast(ConfigurationNode parameters) {
        String castType = parameters.getString("type");
        if (castType != null && castType.equalsIgnoreCase("self")) {
            this.dropHead(this.getPlayer().getLocation(), this.getPlayer().getName(), null, (byte)3);
            return SpellResult.SUCCESS;
        }
        String giveName = parameters.getString("name");
        if (giveName != null) {
            this.dropHead(this.getPlayer().getLocation(), giveName, null, (byte)3);
            return SpellResult.SUCCESS;
        }
        int effectRange = Math.min(this.getMaxRange(), 16);
        Location effectLocation = this.getPlayer().getEyeLocation();
        Vector effectDirection = effectLocation.getDirection();
        EffectTrail effectTrail = new EffectTrail((Plugin)this.controller.getPlugin(), effectLocation, effectDirection, effectRange);
        effectTrail.setParticleType(ParticleType.INSTANT_SPELL);
        effectTrail.setParticleCount(6);
        effectTrail.setEffectData(2.0f);
        effectTrail.setParticleOffset(0.2f, 0.2f, 0.2f);
        effectTrail.setSpeed(1.0f);
        effectTrail.setPeriod(2);
        effectTrail.start();
        this.targetEntity(LivingEntity.class);
        Target target = this.getTarget();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        if (target.isEntity()) {
            if (!(target.getEntity() instanceof LivingEntity)) {
                return SpellResult.NO_TARGET;
            }
            int playerDamage = parameters.getInteger("player_damage", this.DEFAULT_PLAYER_DAMAGE);
            int entityDamage = parameters.getInteger("entity_damage", this.DEFAULT_ENTITY_DAMAGE);
            Entity targetEntity = target.getEntity();
            LivingEntity li = (LivingEntity)targetEntity;
            String ownerName = null;
            String itemName = null;
            byte data = 3;
            if (li instanceof Player) {
                li.damage((double)(this.mage.getDamageMultiplier() * (float)playerDamage), (Entity)this.getPlayer());
                ownerName = ((Player)li).getName();
            } else {
                li.damage((double)(this.mage.getDamageMultiplier() * (float)entityDamage));
                switch (li.getType()) {
                    case CREEPER: {
                        data = 4;
                        ownerName = null;
                        break;
                    }
                    case ZOMBIE: {
                        data = 2;
                        ownerName = null;
                        break;
                    }
                    case SKELETON: {
                        Skeleton skeleton = (Skeleton)li;
                        data = (byte)(skeleton.getSkeletonType() != Skeleton.SkeletonType.NORMAL ? 1 : 0);
                        ownerName = null;
                        break;
                    }
                    default: {
                        ownerName = this.getMobSkin(li.getType());
                        if (ownerName == null) break;
                        itemName = String.valueOf(li.getType().getName()) + " Head";
                    }
                }
            }
            if ((ownerName != null || data != 3) && li.isDead()) {
                this.dropHead(targetEntity.getLocation(), ownerName, itemName, data);
            }
            this.castMessage("Boogidie Boogidie");
        } else {
            Block targetBlock = target.getBlock();
            String blockSkin = this.getBlockSkin(targetBlock.getType());
            if (blockSkin == null) {
                return SpellResult.NO_TARGET;
            }
            if (!this.hasBuildPermission(targetBlock)) {
                return SpellResult.INSUFFICIENT_PERMISSION;
            }
            if (this.mage.isIndestructible(targetBlock)) {
                return SpellResult.NO_TARGET;
            }
            BlockList shrunk = new BlockList();
            shrunk.add(targetBlock);
            this.dropHead(targetBlock.getLocation(), blockSkin, targetBlock.getType().name(), (byte)3);
            targetBlock.setType(Material.AIR);
            this.mage.registerForUndo(shrunk);
            this.castMessage("Shrink!");
        }
        return SpellResult.SUCCESS;
    }

    protected void dropHead(Location location, String ownerName, String itemName, byte data) {
        ItemStack shrunkenHead = new ItemStack(Material.SKULL_ITEM, 1, 0, Byte.valueOf(data));
        if (ownerName != null) {
            shrunkenHead = InventoryUtils.getCopy(shrunkenHead);
            ItemMeta itemMeta = shrunkenHead.getItemMeta();
            if (itemName != null) {
                itemMeta.setDisplayName(itemName);
            }
            shrunkenHead.setItemMeta(itemMeta);
            InventoryUtils.setMeta(shrunkenHead, "SkullOwner", ownerName);
        }
        location.getWorld().dropItemNaturally(location, shrunkenHead);
    }
}

