/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.effects.EffectUtils;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.MagicPlugin;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.wand.LostWand;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class RecallSpell
extends Spell {
    public Location location;
    public boolean isActive;
    private int disableDistance = 5;
    private static int MAX_RETRY_COUNT = 8;
    private static int RETRY_INTERVAL = 10;
    private int retryCount = 0;

    public SpellResult onCast(ConfigurationNode parameters) {
        boolean autoResurrect = parameters.getBoolean("auto_resurrect", true);
        boolean autoSpawn = parameters.getBoolean("allow_spawn", true);
        String typeString = parameters.getString("type", "");
        if (typeString.equals("spawn")) {
            this.castMessage("Returning you home");
            this.tryTeleport(this.getPlayer().getWorld().getSpawnLocation());
            return SpellResult.SUCCESS;
        }
        if (typeString.equals("wand")) {
            Location wandLocation;
            List<LostWand> lostWands = this.mage.getLostWands();
            Location location = wandLocation = lostWands.size() > 0 ? lostWands.get(0).getLocation() : null;
            if (wandLocation == null) {
                this.sendMessage("No recorded lost wands for you. Sorry!");
                return SpellResult.NO_TARGET;
            }
            this.tryTeleport(wandLocation);
            return SpellResult.SUCCESS;
        }
        if (typeString.equals("death") || this.getYRotation() < -70.0 && autoResurrect) {
            Location deathLocation = this.mage.getLastDeathLocation();
            if (deathLocation == null) {
                this.sendMessage("No recorded death location. Sorry!");
                return SpellResult.NO_TARGET;
            }
            this.tryTeleport(deathLocation);
            return SpellResult.SUCCESS;
        }
        if (this.getYRotation() > 70.0) {
            if (!this.isActive && autoSpawn) {
                this.castMessage("Returning you home");
                this.tryTeleport(this.getPlayer().getWorld().getSpawnLocation());
            } else {
                if (!this.isActive) {
                    return SpellResult.NO_TARGET;
                }
                double distanceSquared = this.getPlayer().getLocation().distanceSquared(this.location);
                if (distanceSquared < (double)(this.disableDistance * this.disableDistance) && autoSpawn) {
                    this.castMessage("Returning you home");
                    this.tryTeleport(this.getPlayer().getWorld().getSpawnLocation());
                } else {
                    this.castMessage("Returning you to your marker");
                    this.tryTeleport(this.location);
                }
            }
            return SpellResult.SUCCESS;
        }
        if (!this.isActive) {
            return this.placeMarker(this.getTargetBlock());
        }
        return this.placeMarker(this.getTargetBlock());
    }

    protected boolean removeMarker() {
        if (!this.isActive || this.location == null) {
            return false;
        }
        this.isActive = false;
        return true;
    }

    protected void tryTeleport(final Location targetLocation) {
        Player player;
        Chunk chunk = targetLocation.getBlock().getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
            if (this.retryCount < MAX_RETRY_COUNT) {
                MagicPlugin plugin = this.controller.getPlugin();
                final RecallSpell me = this;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                    public void run() {
                        me.tryTeleport(targetLocation);
                    }
                }, (long)RETRY_INTERVAL);
                return;
            }
        }
        if ((player = this.getPlayer()) != null) {
            Location playerLocation = player.getLocation();
            targetLocation.setYaw(playerLocation.getYaw());
            targetLocation.setPitch(playerLocation.getPitch());
            player.teleport(this.tryFindPlaceToStand(targetLocation));
        }
    }

    protected SpellResult placeMarker(Block target) {
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = target.getRelative(BlockFace.UP);
        if (targetBlock.getType() != Material.AIR) {
            targetBlock = this.getFaceBlock();
        }
        if (targetBlock.getType() != Material.AIR) {
            this.castMessage("Can't place a marker there");
            return SpellResult.NO_TARGET;
        }
        if (this.removeMarker()) {
            this.castMessage("You move your recall marker");
        } else {
            this.castMessage("You place a recall marker");
        }
        this.location = this.getPlayer().getLocation();
        this.location.setX((double)targetBlock.getX());
        this.location.setY((double)targetBlock.getY());
        this.location.setZ((double)targetBlock.getZ());
        this.getPlayer().setCompassTarget(this.location);
        EffectUtils.playEffect(targetBlock.getLocation(), ParticleType.CLOUD, 1.0f, 1);
        this.isActive = true;
        return SpellResult.SUCCESS;
    }

    public void onLoad(ConfigurationNode node) {
        this.isActive = node.getBoolean("active", false);
        this.location = node.getLocation("location");
    }

    public void onSave(ConfigurationNode node) {
        node.setProperty("active", this.isActive);
        node.setProperty("location", this.location);
    }
}

