/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.SimpleBlockAction;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.World;
import org.bukkit.block.Block;

public class LightningSpell
extends Spell {
    public SpellResult onCast(ConfigurationNode parameters) {
        Target target = this.getTarget();
        if (!target.hasTarget()) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        int radius = parameters.getInt("radius", 1);
        radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        double ratio = radius < 2 ? 1.0 : (radius < 4 ? 0.5 : 0.25);
        ShockAction action = new ShockAction(ratio, 5);
        if (radius <= 1) {
            action.perform(target.getBlock());
        } else {
            this.coverSurface(target.getLocation(), radius, action);
        }
        this.castMessage("Zapped " + action.getBlocks().size() + " blocks");
        return SpellResult.SUCCESS;
    }

    public class ShockAction
    extends SimpleBlockAction {
        protected double density;
        protected int thunderThreshold;

        public ShockAction(double density, int thunderThreshold) {
            this.density = density;
            this.thunderThreshold = thunderThreshold;
        }

        public SpellResult perform(Block block) {
            if (Math.random() > this.density) {
                return SpellResult.COST_FREE;
            }
            World world = block.getWorld();
            world.strikeLightning(block.getLocation());
            super.perform(block);
            return SpellResult.SUCCESS;
        }
    }
}

