/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.blocks.MaterialAndData;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.utilities.MaterialMapCanvas;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.map.MapCanvas;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;
import org.bukkit.util.Vector;

public class MaterialBrush
extends MaterialAndData {
    private BrushMode mode = BrushMode.MATERIAL;
    private Location cloneLocation = null;
    private Location cloneTarget = null;
    private Location materialTarget = null;
    private final MagicController controller;
    private short mapId = (short)-1;
    private MaterialMapCanvas mapCanvas = null;
    private Material mapMaterialBase = Material.STAINED_CLAY;

    public MaterialBrush(MagicController controller, Material material, byte data) {
        super(material, data);
        this.controller = controller;
    }

    public void setMaterial(Material material, byte data) {
        if (!this.controller.isRestricted(material) && material.isBlock()) {
            super.setMaterial(material, data);
            this.mode = BrushMode.MATERIAL;
        }
    }

    public void enableCloning() {
        this.mode = BrushMode.CLONE;
    }

    public void enableErase() {
        this.setMaterial(Material.AIR);
    }

    public void enableMap() {
        this.mode = BrushMode.MAP;
        if (this.material == Material.WOOL || this.material == Material.STAINED_CLAY || this.material == Material.STAINED_GLASS || this.material == Material.STAINED_GLASS_PANE || this.material == Material.CARPET) {
            this.mapMaterialBase = this.material;
        }
    }

    public void enableReplication() {
        this.mode = BrushMode.REPLICATE;
    }

    public void setData(byte data) {
        this.data = data;
    }

    public void setMapId(short mapId) {
        this.mapCanvas = null;
        this.mapId = mapId;
    }

    public void setCloneLocation(Location cloneFrom) {
        this.cloneLocation = cloneFrom;
        this.materialTarget = cloneFrom;
        this.cloneTarget = null;
    }

    public void clearCloneTarget() {
        this.cloneTarget = null;
    }

    public boolean hasCloneTarget() {
        return this.cloneLocation != null && this.cloneTarget != null;
    }

    public void enableCopying() {
        this.mode = BrushMode.COPY;
    }

    public boolean isReady() {
        if ((this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) && this.materialTarget != null) {
            Block block = this.materialTarget.getBlock();
            return block.getChunk().isLoaded();
        }
        return true;
    }

    public void setTarget(Location target) {
        if (!(this.mode != BrushMode.REPLICATE && this.mode != BrushMode.CLONE && this.mode != BrushMode.MAP || this.cloneTarget != null && this.mode != BrushMode.CLONE && target.getWorld().getName().equals(this.cloneTarget.getWorld().getName()))) {
            this.cloneTarget = target;
        }
        if (this.mode == BrushMode.COPY) {
            Block block = target.getBlock();
            this.updateFrom(block, this.controller.getRestrictedMaterials());
        }
    }

    public Location toTargetLocation(Location target) {
        if (this.cloneLocation == null || this.cloneTarget == null) {
            return null;
        }
        Location translated = this.cloneLocation.clone();
        translated.subtract(this.cloneTarget.toVector());
        translated.add(target.toVector());
        return translated;
    }

    public Location fromTargetLocation(World targetWorld, Location target) {
        if (this.cloneLocation == null || this.cloneTarget == null) {
            return null;
        }
        Location translated = target.clone();
        translated.setX((double)translated.getBlockX());
        translated.setY((double)translated.getBlockY());
        translated.setZ((double)translated.getBlockZ());
        Vector cloneVector = new Vector(this.cloneLocation.getBlockX(), this.cloneLocation.getBlockY(), this.cloneLocation.getBlockZ());
        translated.subtract(cloneVector);
        Vector cloneTargetVector = new Vector(this.cloneTarget.getBlockX(), this.cloneTarget.getBlockY(), this.cloneTarget.getBlockZ());
        translated.add(cloneTargetVector);
        translated.setWorld(targetWorld);
        return translated;
    }

    public boolean update(Mage fromMage, Location target) {
        if (this.cloneLocation != null && (this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE)) {
            if (this.cloneTarget == null) {
                this.cloneTarget = target;
            }
            this.materialTarget = this.toTargetLocation(target);
            Block block = this.materialTarget.getBlock();
            if (!block.getChunk().isLoaded()) {
                return false;
            }
            this.updateFrom(block, this.controller.getRestrictedMaterials());
        }
        if (this.mode == BrushMode.MAP && this.mapId >= 0) {
            if (this.mapCanvas == null && fromMage != null) {
                try {
                    List renderers;
                    MapView mapView = Bukkit.getMap((short)this.mapId);
                    if (mapView != null && (renderers = mapView.getRenderers()).size() > 0) {
                        this.mapCanvas = new MaterialMapCanvas();
                        MapRenderer renderer = (MapRenderer)renderers.get(0);
                        renderer.initialize(mapView);
                        renderer.render(mapView, (MapCanvas)this.mapCanvas, fromMage.getPlayer());
                    }
                }
                catch (Exception mapView) {
                    // empty catch block
                }
            }
            if (this.mapCanvas != null && this.cloneTarget != null) {
                Vector diff = target.toVector().subtract(this.cloneTarget.toVector());
                DyeColor mapColor = this.mapCanvas.getDyeColor(Math.abs(diff.getBlockX()) % MaterialMapCanvas.CANVAS_WIDTH, Math.abs(diff.getBlockZ()) % MaterialMapCanvas.CANVAS_HEIGHT);
                if (mapColor != null) {
                    this.updateTo(this.mapMaterialBase, mapColor.getData());
                } else {
                    this.updateTo(Material.AIR, (byte)0);
                }
            }
        }
        return true;
    }

    public void prepare() {
        Block block;
        if (this.cloneLocation != null && !(block = this.cloneTarget.getBlock()).getChunk().isLoaded()) {
            block.getChunk().load(true);
        }
    }

    public void load(ConfigurationNode node) {
        try {
            this.cloneLocation = node.getLocation("clone_location");
            this.cloneTarget = node.getLocation("clone_target");
            this.materialTarget = node.getLocation("material_target");
            this.mapId = (short)node.getInt("map_id", this.mapId);
            this.material = node.getMaterial("material", this.material);
            this.data = (byte)node.getInt("data", this.data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.controller.getPlugin().getLogger().warning("Failed to load brush data: " + ex.getMessage());
        }
    }

    public void save(ConfigurationNode node) {
        try {
            if (this.cloneLocation != null) {
                node.setProperty("clone_location", this.cloneLocation);
            }
            if (this.cloneTarget != null) {
                node.setProperty("clone_target", this.cloneTarget);
            }
            if (this.materialTarget != null) {
                node.setProperty("material_target", this.materialTarget);
            }
            node.setProperty("map_id", this.mapId);
            node.setProperty("material", this.material);
            node.setProperty("data", this.data);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.controller.getLogger().warning("Failed to save brush data: " + ex.getMessage());
        }
    }

    public boolean isReplicating() {
        return this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BrushMode {
        MATERIAL,
        COPY,
        CLONE,
        REPLICATE,
        MAP;

    }
}

