/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.effects;

import com.elmakers.mine.bukkit.effects.EffectPlayer;
import org.bukkit.Location;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EffectRing
extends EffectPlayer {
    protected final Location start;
    protected final int length;
    protected final int count;
    protected boolean invert = false;
    protected int played = 0;
    protected float speed = 1.0f;

    public EffectRing(Plugin plugin, Location start, int length, int count) {
        super(plugin);
        this.start = start.clone();
        this.length = length;
        this.count = count;
    }

    public void setSpeed(float speed) {
        this.speed = speed;
    }

    public void setInvert(boolean invert) {
        this.invert = true;
    }

    public void run() {
        int iteration = this.played + 1;
        float radius = this.invert ? (float)(1 + this.length - iteration) * this.speed : (float)iteration * this.speed;
        float fullRing = (1.0f + radius * 2.0f) * (1.0f + radius * 2.0f);
        int scaledCount = Math.min((int)Math.ceil(fullRing), this.count);
        double startRadians = Math.random() * Math.PI * 2.0;
        int i = 0;
        while (i < scaledCount) {
            double radians = (double)i / (double)scaledCount * Math.PI * 2.0 + startRadians;
            Vector direction = new Vector(Math.cos(radians) * (double)radius, 0.0, Math.sin(radians) * (double)radius);
            Location loc = this.start.clone();
            loc.add(direction);
            this.playEffect(loc);
            ++i;
        }
        ++this.played;
        if (this.played < this.length) {
            this.schedule();
        }
    }
}

