/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.effects.EffectUtils;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.MagicPlugin;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PhaseSpell
extends Spell {
    private static int MAX_RETRY_COUNT = 8;
    private static int RETRY_INTERVAL = 10;
    private int retryCount = 0;

    public SpellResult onCast(ConfigurationNode parameters) {
        int maxY = 255;
        Location playerLocation = this.getPlayer().getEyeLocation();
        String worldName = playerLocation.getWorld().getName();
        Location targetLocation = null;
        if (worldName.contains("_the_end")) {
            World targetWorld = Bukkit.getWorld((String)(worldName = worldName.replace("_the_end", "")));
            if (targetWorld != null) {
                targetLocation = targetWorld.getSpawnLocation();
            }
        } else if (worldName.contains("_nether")) {
            World targetWorld = Bukkit.getWorld((String)(worldName = worldName.replace("_nether", "")));
            if (targetWorld != null) {
                targetLocation = new Location(targetWorld, playerLocation.getX() * 8.0, playerLocation.getY(), playerLocation.getZ() * 8.0);
            }
        } else {
            maxY = 125;
            World targetWorld = Bukkit.getWorld((String)(worldName = String.valueOf(worldName) + "_nether"));
            if (targetWorld != null) {
                targetLocation = new Location(targetWorld, playerLocation.getX() / 8.0, playerLocation.getY(), playerLocation.getZ() / 8.0);
            }
        }
        if (targetLocation == null) {
            return SpellResult.NO_TARGET;
        }
        this.retryCount = 0;
        this.tryPhase(targetLocation, maxY);
        return SpellResult.SUCCESS;
    }

    protected void tryPhase(final Location targetLocation, final int maxY) {
        Player player;
        Chunk chunk = targetLocation.getBlock().getChunk();
        if (!chunk.isLoaded()) {
            chunk.load(true);
            if (this.retryCount < MAX_RETRY_COUNT) {
                MagicPlugin plugin = this.controller.getPlugin();
                final PhaseSpell me = this;
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)plugin, new Runnable(){

                    public void run() {
                        me.tryPhase(targetLocation, maxY);
                    }
                }, (long)RETRY_INTERVAL);
                return;
            }
        }
        if ((player = this.getPlayer()) != null) {
            Location playerLocation = player.getLocation();
            targetLocation.setYaw(playerLocation.getYaw());
            targetLocation.setPitch(playerLocation.getPitch());
            player.teleport(this.tryFindPlaceToStand(targetLocation, 4, maxY));
            EffectUtils.playEffect(playerLocation, ParticleType.PORTAL, 1.0f, 16);
            playerLocation.getWorld().playSound(playerLocation, Sound.ENDERMAN_TELEPORT, 1.0f, 1.5f);
            EffectUtils.playEffect(targetLocation, ParticleType.PORTAL, 1.0f, 16);
            playerLocation.getWorld().playSound(targetLocation, Sound.ENDERMAN_TELEPORT, 1.0f, 1.5f);
        }
    }
}

