/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.effects.EffectRing;
import com.elmakers.mine.bukkit.effects.EffectTrail;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class FlingSpell
extends Spell {
    private final long safetyLength = 20000L;
    private long lastFling = 0L;
    protected int defaultMaxSpeedAtElevation = 64;
    protected double defaultMinMagnitude = 1.5;
    protected double defaultMaxMagnitude = 6.0;
    private static final int effectSpeed = 2;
    private static final int effectPeriod = 2;
    private static final int maxEffectRange = 16;
    private static final int maxRingEffectRange = 4;
    private static final int ringEffectAmount = 6;

    public SpellResult onCast(ConfigurationNode parameters) {
        int height = 0;
        Block playerBlock = this.getPlayer().getLocation().getBlock();
        int maxSpeedAtElevation = parameters.getInt("cruising_altitude", this.defaultMaxSpeedAtElevation);
        double minMagnitude = parameters.getDouble("min_speed", this.defaultMinMagnitude);
        double maxMagnitude = parameters.getDouble("max_speed", this.defaultMaxMagnitude);
        double yOffset = parameters.getDouble("yo", 0.0);
        Double yValue = parameters.getDouble("dy", null);
        Double xValue = parameters.getDouble("dx", null);
        Double zValue = parameters.getDouble("dz", null);
        while (height < maxSpeedAtElevation && playerBlock.getType() == Material.AIR) {
            playerBlock = playerBlock.getRelative(BlockFace.DOWN);
            ++height;
        }
        double heightModifier = maxSpeedAtElevation > 0 ? (double)height / (double)maxSpeedAtElevation : 1.0;
        double magnitude = minMagnitude + (maxMagnitude - minMagnitude) * heightModifier;
        Vector velocity = this.mage.getLocation().getDirection();
        if (yValue != null) {
            velocity.setY(yValue.doubleValue());
        } else if (yOffset > 0.0) {
            velocity.setY(velocity.getY() + yOffset);
        }
        if (xValue != null) {
            velocity.setX(xValue.doubleValue());
        }
        if (zValue != null) {
            velocity.setZ(zValue.doubleValue());
        }
        if (this.getPlayer().getLocation().getBlockY() >= 256) {
            velocity.setY(0);
        }
        int effectRange = Math.min(this.getMaxRange(), 8);
        Location effectLocation = this.getPlayer().getEyeLocation();
        Vector effectDirection = effectLocation.getDirection();
        EffectTrail effect = new EffectTrail((Plugin)this.controller.getPlugin(), effectLocation, effectDirection, effectRange);
        effect.setParticleType(ParticleType.SPELL);
        effect.setParticleCount(3);
        Color effectColor = this.mage.getEffectColor();
        effect.setEffectData(effectColor != null ? effectColor.asRGB() : 255);
        effect.setParticleOffset(2.0f, 2.0f, 2.0f);
        effect.setSpeed(2.0f);
        effect.setPeriod(2);
        effect.start();
        velocity.multiply(magnitude);
        this.getPlayer().setVelocity(velocity);
        this.castMessage("Whee!");
        this.controller.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
        this.lastFling = System.currentTimeMillis();
        return SpellResult.SUCCESS;
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        this.controller.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
        if (this.lastFling == 0L) {
            return;
        }
        if (this.lastFling + 20000L > System.currentTimeMillis()) {
            event.setCancelled(true);
            this.lastFling = 0L;
            Location effectLocation = event.getEntity().getLocation();
            Block block = event.getEntity().getLocation().getBlock();
            block = block.getRelative(BlockFace.DOWN);
            int effectRange = Math.min(this.getMaxRange(), 2);
            EffectRing effect = new EffectRing((Plugin)this.controller.getPlugin(), effectLocation, effectRange, 6);
            effect.setEffect(Effect.STEP_SOUND);
            effect.setData(block.getTypeId());
            effect.setSpeed(2.0f);
            effect.setPeriod(2);
            effect.start();
        }
    }
}

