/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.ConstructBatch;
import com.elmakers.mine.bukkit.blocks.ConstructionType;
import com.elmakers.mine.bukkit.effects.EffectUtils;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.effects.SpellEffect;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.HashSet;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class ConstructSpell
extends BrushSpell {
    private ConstructionType defaultConstructionType = ConstructionType.SPHERE;
    private int defaultRadius = 2;
    private Block targetBlock = null;
    private static final int DEFAULT_MAX_DIMENSION = 128;

    public SpellResult onCast(ConfigurationNode parameters) {
        String typeString;
        ConstructionType testType;
        Block target = this.getTarget().getBlock();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        int timeToLive = parameters.getInt("undo", 0);
        int radius = parameters.getInt("radius", this.defaultRadius);
        radius = parameters.getInt("size", radius);
        boolean falling = parameters.getBoolean("falling", false);
        float force = 0.0f;
        force = (float)parameters.getDouble("speed", force);
        String targetString = parameters.getString("target", "");
        if (targetString.equals("select")) {
            if (this.targetBlock == null) {
                this.targetBlock = target;
                Location effectLocation = this.targetBlock.getLocation();
                effectLocation.add(0.5, 0.5, 0.5);
                EffectUtils.playEffect(effectLocation, ParticleType.HAPPY_VILLAGER, 0.3f, 0.3f, 0.3f, 1.5f, 10);
                this.castMessage("Cast again to construct");
                this.activate();
                SpellEffect effect = this.getEffect("target");
                effect.particleType = ParticleType.WATER_DRIPPING;
                effect.startTrailEffect(this.mage, this.getEyeLocation(), effectLocation);
                return SpellResult.COST_FREE;
            }
            radius = (int)this.targetBlock.getLocation().distance(target.getLocation());
            target = this.targetBlock;
        } else {
            radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        }
        int maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)parameters.getInteger("max_dimension", 128));
        int diameter = radius * 2;
        if (diameter > maxDimension) {
            this.sendMessage("Dimension is too big!");
            return SpellResult.FAILURE;
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (parameters.getBoolean("replace", false)) {
            HashSet<Material> destructible = new HashSet<Material>();
            if (this.targetBlock != null) {
                destructible.add(this.targetBlock.getType());
            } else {
                destructible.add(target.getType());
            }
            this.setDestructible(destructible);
        }
        if (parameters.containsKey("y_offset")) {
            target = target.getRelative(BlockFace.UP, parameters.getInt("y_offset", 0));
        }
        MaterialBrush buildWith = this.getMaterialBrush();
        buildWith.setTarget(target.getLocation());
        ConstructionType conType = this.defaultConstructionType;
        boolean hollow = false;
        String fillType = parameters.getString("fill", "");
        hollow = fillType.equals("hollow");
        Vector forceVector = null;
        if (falling && force != 0.0f) {
            forceVector = this.getPlayer().getLocation().getDirection();
            forceVector.setY(-forceVector.getY()).normalize().multiply(force);
        }
        if ((testType = ConstructionType.parseString(typeString = parameters.getString("type", ""), ConstructionType.UNKNOWN)) != ConstructionType.UNKNOWN) {
            conType = testType;
        }
        ConstructBatch batch = new ConstructBatch(this, target.getLocation(), conType, radius, !hollow, falling);
        if (forceVector != null) {
            batch.setFallingBlockVelocity(forceVector);
        }
        if (parameters.containsKey("y_max")) {
            batch.setYMax(parameters.getInteger("y_max", null));
        }
        if (parameters.containsKey("y_min")) {
            batch.setYMin(parameters.getInteger("y_min", null));
        }
        if (timeToLive > 0) {
            batch.setTimeToLive(timeToLive);
        }
        this.mage.addPendingBlockBatch(batch);
        SpellEffect effect = this.getEffect("cast");
        effect.particleType = null;
        effect.effect = Effect.STEP_SOUND;
        effect.data = buildWith.getMaterial().getId();
        effect.startTrailEffect(this.mage, this.getEyeLocation(), target.getLocation());
        if (this.targetBlock != null) {
            effect.startTrailEffect(this.mage, this.getEyeLocation(), this.targetBlock.getLocation());
        }
        this.deactivate();
        return SpellResult.SUCCESS;
    }

    public void onDeactivate() {
        this.targetBlock = null;
    }

    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.sendMessage("Cancelled construct");
            this.deactivate();
            return true;
        }
        return false;
    }
}

