/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.plugins.magic.MagicController;
import com.elmakers.mine.bukkit.utilities.borrowed.MaterialAndData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class MaterialBrush
extends MaterialAndData {
    private BrushMode mode = BrushMode.MATERIAL;
    private Location cloneLocation = null;
    private Location cloneTarget = null;
    private Location materialTarget = null;
    private final MagicController controller;

    public MaterialBrush(MagicController controller, Material material, byte data) {
        super(material, data);
        this.controller = controller;
    }

    public void setMaterial(Material material, byte data) {
        if (!this.controller.isRestricted(material) && material.isBlock()) {
            super.setMaterial(material, data);
            this.mode = BrushMode.MATERIAL;
        }
    }

    public void enableCloning() {
        this.mode = BrushMode.CLONE;
    }

    public void enableErase() {
        this.setMaterial(Material.AIR);
    }

    public void enableReplication() {
        this.mode = BrushMode.REPLICATE;
    }

    public void setData(byte data) {
        this.data = data;
    }

    public void setCloneLocation(Location cloneFrom) {
        this.cloneLocation = cloneFrom;
        this.materialTarget = cloneFrom;
        this.cloneTarget = null;
    }

    public boolean hasCloneTarget() {
        return this.cloneLocation != null && this.cloneTarget != null;
    }

    public void enableCopying() {
        this.mode = BrushMode.COPY;
    }

    public boolean isReady() {
        if ((this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) && this.materialTarget != null) {
            Block block = this.materialTarget.getBlock();
            return block.getChunk().isLoaded();
        }
        return true;
    }

    public void setTarget(Location target) {
        if (!(this.mode != BrushMode.REPLICATE && this.mode != BrushMode.CLONE || this.cloneTarget != null && this.mode != BrushMode.CLONE && target.getWorld().getName().equals(this.cloneTarget.getWorld().getName()))) {
            this.cloneTarget = target;
        }
        if (this.mode == BrushMode.COPY) {
            Block block = target.getBlock();
            this.updateFrom(block, this.controller.getRestrictedMaterials());
        }
    }

    public Location toTargetLocation(Location target) {
        if (this.cloneLocation == null || this.cloneTarget == null) {
            return null;
        }
        Location translated = this.cloneLocation.clone();
        translated.subtract(this.cloneTarget.toVector());
        translated.add(target.toVector());
        return translated;
    }

    public Location fromTargetLocation(World targetWorld, Location target) {
        if (this.cloneLocation == null || this.cloneTarget == null) {
            return null;
        }
        Location translated = target.clone();
        translated.setX((double)translated.getBlockX());
        translated.setY((double)translated.getBlockY());
        translated.setZ((double)translated.getBlockZ());
        Vector cloneVector = new Vector(this.cloneLocation.getBlockX(), this.cloneLocation.getBlockY(), this.cloneLocation.getBlockZ());
        translated.subtract(cloneVector);
        Vector cloneTargetVector = new Vector(this.cloneTarget.getBlockX(), this.cloneTarget.getBlockY(), this.cloneTarget.getBlockZ());
        translated.add(cloneTargetVector);
        translated.setWorld(targetWorld);
        return translated;
    }

    public boolean update(Location target) {
        if (this.cloneLocation != null && (this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE)) {
            if (this.cloneTarget == null) {
                this.cloneTarget = target;
            }
            this.materialTarget = this.toTargetLocation(target);
            Block block = this.materialTarget.getBlock();
            if (!block.getChunk().isLoaded()) {
                return false;
            }
            this.updateFrom(block, this.controller.getRestrictedMaterials());
        }
        return true;
    }

    public void prepare() {
        Block block;
        if (this.cloneLocation != null && !(block = this.cloneTarget.getBlock()).getChunk().isLoaded()) {
            block.getChunk().load(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BrushMode {
        MATERIAL,
        COPY,
        CLONE,
        REPLICATE;

    }
}

