/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.ConstructionType;
import com.elmakers.mine.bukkit.blocks.VolumeBatch;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MaterialBrush;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Painting;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class ConstructBatch
extends VolumeBatch {
    private final BlockList constructedBlocks = new BlockList();
    private final Location center;
    private final int radius;
    private final ConstructionType type;
    private final boolean fill;
    private final Mage mage;
    private final BrushSpell spell;
    private final boolean spawnFallingBlocks;
    private Vector fallingBlockVelocity = null;
    private boolean copyEntities = true;
    private Integer maxDY = null;
    private Integer minDY = null;
    private int x = 0;
    private int y = 0;
    private int z = 0;

    public ConstructBatch(BrushSpell spell, Location center, ConstructionType type, int radius, boolean fill, boolean spawnFallingBlocks) {
        super(spell.getMage().getController(), center.getWorld().getName());
        this.center = center;
        this.radius = radius;
        this.type = type;
        this.fill = fill;
        this.spawnFallingBlocks = spawnFallingBlocks;
        this.mage = spell.getMage();
        this.spell = spell;
    }

    public void setFallingBlockVelocity(Vector velocity) {
        this.fallingBlockVelocity = velocity;
    }

    public void setYMax(int maxDY) {
        this.maxDY = maxDY;
    }

    public void setYMin(int minDY) {
        this.minDY = minDY;
    }

    public int process(int maxBlocks) {
        int processedBlocks = 0;
        int yBounds = this.radius;
        if (this.maxDY != null || this.minDY != null) {
            yBounds = Math.max(this.minDY == null ? this.radius : this.minDY, this.maxDY == null ? this.radius : this.maxDY);
        }
        yBounds = Math.min(yBounds, 255);
        while (processedBlocks <= maxBlocks && this.x <= this.radius) {
            if (!this.fillBlock(this.x, this.y, this.z)) {
                return processedBlocks;
            }
            ++this.y;
            if (this.y > yBounds) {
                this.y = 0;
                ++this.z;
                if (this.z > this.radius) {
                    this.z = 0;
                    ++this.x;
                }
            }
            ++processedBlocks;
        }
        if (this.x > this.radius) {
            this.finish();
        }
        return processedBlocks;
    }

    public void finish() {
        if (!this.finished) {
            super.finish();
            MaterialBrush brush = this.spell.getMaterialBrush();
            if (this.copyEntities && brush != null && brush.hasCloneTarget()) {
                Location cloneLocation = brush.toTargetLocation(this.center);
                World sourceWorld = cloneLocation.getWorld();
                int radiusSquared = this.radius * this.radius;
                List entities = sourceWorld.getEntities();
                for (Entity entity : entities) {
                    Location targetLocation;
                    Location attachedLocation;
                    if (entity instanceof Painting) {
                        if (entity.getLocation().distanceSquared(cloneLocation) > (double)radiusSquared) continue;
                        Painting painting = (Painting)entity;
                        attachedLocation = painting.getLocation().getBlock().getRelative(painting.getAttachedFace()).getLocation();
                        targetLocation = brush.fromTargetLocation(this.center.getWorld(), attachedLocation);
                        try {
                            Painting newPainting = (Painting)this.center.getWorld().spawnEntity(targetLocation, EntityType.PAINTING);
                            if (newPainting == null) continue;
                            targetLocation = brush.fromTargetLocation(this.center.getWorld(), painting.getLocation());
                            newPainting.teleport(targetLocation);
                            newPainting.setArt(painting.getArt());
                            newPainting.setFacingDirection(painting.getFacing());
                        }
                        catch (Exception ex) {
                            this.center.getWorld().dropItemNaturally(targetLocation, new ItemStack(Material.PAINTING, 1));
                        }
                        continue;
                    }
                    if (!(entity instanceof ItemFrame) || entity.getLocation().distanceSquared(cloneLocation) > (double)radiusSquared) continue;
                    ItemFrame itemFrame = (ItemFrame)entity;
                    attachedLocation = itemFrame.getLocation().getBlock().getRelative(itemFrame.getAttachedFace()).getLocation();
                    targetLocation = brush.fromTargetLocation(this.center.getWorld(), attachedLocation);
                    ItemStack itemStack = InventoryUtils.getCopy(itemFrame.getItem());
                    try {
                        ItemFrame newItemFrame = (ItemFrame)this.center.getWorld().spawnEntity(targetLocation, EntityType.ITEM_FRAME);
                        if (newItemFrame == null) continue;
                        targetLocation = brush.fromTargetLocation(this.center.getWorld(), itemFrame.getLocation());
                        newItemFrame.teleport(targetLocation);
                        newItemFrame.setFacingDirection(itemFrame.getFacing());
                        newItemFrame.setRotation(itemFrame.getRotation());
                        if (itemStack == null) continue;
                        newItemFrame.setItem(itemStack);
                    }
                    catch (Exception ex) {
                        if (itemStack != null) {
                            this.center.getWorld().dropItemNaturally(targetLocation, itemStack);
                        }
                        this.center.getWorld().dropItemNaturally(targetLocation, new ItemStack(Material.ITEM_FRAME, 1));
                    }
                }
            }
            this.mage.registerForUndo(this.constructedBlocks);
            this.mage.castMessage("Constructed " + this.constructedBlocks.size() + " blocks");
        }
    }

    public void setCopyEntities(boolean doCopy) {
        this.copyEntities = doCopy;
    }

    public boolean fillBlock(int x, int y, int z) {
        boolean fillBlock = false;
        switch (this.type) {
            case SPHERE: {
                int maxDistanceSquared = this.radius * this.radius;
                float mx = (float)x - 0.5f;
                float my = (float)y - 0.5f;
                float mz = (float)z - 0.5f;
                int distanceSquared = (int)(mx * mx + my * my + mz * mz);
                if (this.fill) {
                    fillBlock = distanceSquared <= maxDistanceSquared;
                    break;
                }
                int outerDistanceSquared = (int)((mx += 1.0f) * mx + (my += 1.0f) * my + (mz += 1.0f) * mz);
                fillBlock = maxDistanceSquared >= distanceSquared && maxDistanceSquared <= outerDistanceSquared;
                break;
            }
            case PYRAMID: {
                int elevation = this.radius - y;
                if (this.fill) {
                    fillBlock = x <= elevation && z <= elevation;
                    break;
                }
                fillBlock = x == elevation && z <= elevation || z == elevation && x <= elevation;
                break;
            }
            default: {
                fillBlock = this.fill ? true : x == this.radius || y == this.radius || z == this.radius;
            }
        }
        boolean success = true;
        if (fillBlock) {
            success = success && this.constructBlock(x, y, z);
            success = success && this.constructBlock(-x, y, z);
            success = success && this.constructBlock(x, -y, z);
            success = success && this.constructBlock(x, y, -z);
            success = success && this.constructBlock(-x, -y, z);
            success = success && this.constructBlock(x, -y, -z);
            success = success && this.constructBlock(-x, y, -z);
            success = success && this.constructBlock(-x, -y, -z);
        }
        return success;
    }

    public int getDistanceSquared(int x, int y, int z) {
        return x * x + y * y + z * z;
    }

    public boolean constructBlock(int dx, int dy, int dz) {
        if (this.minDY != null && dy < this.minDY) {
            return true;
        }
        if (this.maxDY != null && dy > this.maxDY) {
            return true;
        }
        int x = this.center.getBlockX() + dx;
        int y = this.center.getBlockY() + dy;
        int z = this.center.getBlockZ() + dz;
        if (y < 0 || y > 255) {
            return true;
        }
        Block block = this.center.getWorld().getBlockAt(x, y, z);
        MaterialBrush brush = this.spell.getMaterialBrush();
        brush.update(block.getLocation());
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load();
            return false;
        }
        if (!brush.isReady()) {
            brush.prepare();
            return false;
        }
        if (!this.spell.isDestructible(block)) {
            return true;
        }
        if (!this.spell.hasBuildPermission(block)) {
            return true;
        }
        Material previousMaterial = block.getType();
        byte previousData = block.getData();
        if (brush.isDifferent(block)) {
            this.updateBlock(this.center.getWorld().getName(), x, y, z);
            this.constructedBlocks.add(block);
            brush.modify(block);
            if (this.spawnFallingBlocks) {
                FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation(), previousMaterial, previousData);
                falling.setDropItem(false);
                if (this.fallingBlockVelocity != null) {
                    falling.setVelocity(this.fallingBlockVelocity);
                }
            }
        }
        return true;
    }

    public void setTimeToLive(int timeToLive) {
        this.constructedBlocks.setTimeToLive(timeToLive);
    }
}

