/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities.borrowed;

import com.elmakers.mine.bukkit.blocks.BlockData;
import com.elmakers.mine.bukkit.utilities.CSVParser;
import com.elmakers.mine.bukkit.utilities.borrowed.MaterialAndData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationNode {
    protected Map<String, Object> root;
    protected static CSVParser csv = new CSVParser();

    public ConfigurationNode createChild(String name) {
        HashMap newChild = new HashMap();
        this.setProperty(name, newChild);
        Object raw = this.getProperty(name);
        if (raw instanceof Map) {
            return new ConfigurationNode((Map)raw);
        }
        return null;
    }

    public ConfigurationNode() {
        this.root = new HashMap<String, Object>();
    }

    public ConfigurationNode(ConfigurationNode copy) {
        HashMap<String, Object> newRoot = new HashMap<String, Object>();
        if (copy != null) {
            newRoot.putAll(copy.root);
        }
        this.root = newRoot;
    }

    public ConfigurationNode(Map<String, Object> root) {
        this.root = root;
    }

    public Map<String, Object> getAll() {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Set<String> keys = this.root.keySet();
        for (String k : keys) {
            Object tmp = this.root.get(k);
            if (tmp instanceof Map) {
                Map<String, Object> rec = this.recursiveBuilder((Map)tmp);
                Set<String> subkeys = rec.keySet();
                for (String sk : subkeys) {
                    map.put(String.valueOf(k) + "." + sk, rec.get(sk));
                }
                continue;
            }
            map.put(k, tmp);
        }
        return map;
    }

    protected Map<String, Object> recursiveBuilder(Map<String, Object> node) {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        Set<String> keys = node.keySet();
        for (String k : keys) {
            Object tmp = node.get(k);
            if (tmp instanceof Map) {
                Map<String, Object> rec = this.recursiveBuilder((Map)tmp);
                Set<String> subkeys = rec.keySet();
                for (String sk : subkeys) {
                    map.put(String.valueOf(k) + "." + sk, rec.get(sk));
                }
                continue;
            }
            map.put(k, tmp);
        }
        return map;
    }

    public Object getProperty(String path) {
        boolean isFloat = false;
        try {
            Double.parseDouble(path);
            isFloat = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (isFloat || !path.contains(".")) {
            Object val = this.root.get(path);
            if (val == null) {
                try {
                    return this.root.get(Integer.parseInt(path));
                }
                catch (Exception ex) {
                    try {
                        return this.root.get(Double.parseDouble(path));
                    }
                    catch (Exception ex2) {
                        try {
                            return this.root.get(Float.valueOf(Float.parseFloat(path)));
                        }
                        catch (Exception ex3) {
                            return null;
                        }
                    }
                }
            }
            return val;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        int i = 0;
        while (i < parts.length) {
            Object o = node.get(parts[i]);
            if (o == null) {
                return null;
            }
            if (i == parts.length - 1) {
                return o;
            }
            try {
                node = (Map)o;
            }
            catch (ClassCastException e) {
                return null;
            }
            ++i;
        }
        return null;
    }

    public static String fromLocation(Location location) {
        return String.valueOf(location.getX()) + "," + location.getY() + "," + location.getZ() + "," + location.getWorld().getName();
    }

    public void setProperty(String path, Object value) {
        BlockData blockValue;
        if (value instanceof Material) {
            Material matValue = (Material)value;
            value = matValue.name().toLowerCase();
        }
        if (value instanceof Location) {
            value = ConfigurationNode.fromLocation((Location)value);
        }
        if (value instanceof BlockData) {
            blockValue = (BlockData)value;
            value = blockValue.toString();
        }
        if (value instanceof Block) {
            blockValue = (Block)value;
            value = String.valueOf(ConfigurationNode.fromLocation(blockValue.getLocation())) + "|" + blockValue.getTypeId() + ":" + blockValue.getData();
        }
        if (!path.contains(".")) {
            this.root.put(path, value);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        int i = 0;
        while (i < parts.length) {
            HashMap o = node.get(parts[i]);
            if (i == parts.length - 1) {
                node.put((String)parts[i], (Object)value);
                return;
            }
            if (o == null || !(o instanceof Map)) {
                o = new HashMap();
                node.put(parts[i], o);
            }
            node = o;
            ++i;
        }
    }

    public String getString(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        return o.toString();
    }

    public Material getMaterial(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        return ConfigurationNode.toMaterial(o);
    }

    public MaterialAndData getMaterialAndData(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        return ConfigurationNode.toMaterialAndData(o);
    }

    public Location getLocation(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        return ConfigurationNode.toLocation(o);
    }

    public static Location toLocation(Object o) {
        if (o instanceof Location) {
            return (Location)o;
        }
        if (o instanceof String) {
            try {
                String[] pieces = StringUtils.split((String)((String)o), (char)',');
                double x = Double.parseDouble(pieces[0]);
                double y = Double.parseDouble(pieces[1]);
                double z = Double.parseDouble(pieces[2]);
                World world = null;
                world = pieces.length > 3 ? Bukkit.getWorld((String)pieces[3]) : (World)Bukkit.getWorlds().get(0);
                return new Location(world, x, y, z);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static Material toMaterial(Object o) {
        if (o instanceof Material) {
            return (Material)o;
        }
        if (o instanceof Integer) {
            return Material.values()[(Integer)o];
        }
        if (o instanceof String) {
            String matName = (String)o;
            try {
                Integer value = Integer.parseInt(matName);
                if (value != null) {
                    return Material.getMaterial((int)value);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return Material.getMaterial((String)matName.toUpperCase());
        }
        return null;
    }

    public static MaterialAndData toMaterialAndData(Object o) {
        if (o instanceof MaterialAndData) {
            return (MaterialAndData)o;
        }
        if (o instanceof String) {
            String matName = (String)o;
            Material material = null;
            byte data = 0;
            String[] pieces = StringUtils.split((String)matName, (char)':');
            if (pieces.length > 1) {
                try {
                    data = Byte.parseByte(pieces[1]);
                }
                catch (NumberFormatException ex) {
                    data = 0;
                }
            }
            try {
                Integer value = Integer.parseInt(pieces[0]);
                if (value != null) {
                    material = Material.getMaterial((int)value);
                }
            }
            catch (NumberFormatException ex) {
                material = Material.getMaterial((String)pieces[0].toUpperCase());
            }
            if (material == null) {
                return null;
            }
            return new MaterialAndData(material, data);
        }
        return null;
    }

    public MaterialAndData getMaterialAndData(String path, Material def) {
        return this.getMaterialAndData(path, def, (byte)0);
    }

    public MaterialAndData getMaterialAndData(String path, Material def, byte defData) {
        MaterialAndData o = this.getMaterialAndData(path);
        return o == null ? new MaterialAndData(def, defData) : o;
    }

    public Material getMaterial(String path, Material def) {
        Material o = this.getMaterial(path);
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public String getString(String path, String def) {
        String o = this.getString(path);
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public int getInt(String path, int def) {
        Integer o = ConfigurationNode.castInt(this.getProperty(path));
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public Integer getInteger(String path, Integer def) {
        Integer o = ConfigurationNode.castInt(this.getProperty(path));
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public int getInteger(String path, int def) {
        return this.getInt(path, def);
    }

    public long getLong(String path, long def) {
        Long o = ConfigurationNode.castLong(this.getProperty(path));
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public Set<Material> getMaterials(String key, String csvList) {
        List<String> defaultMatNames = csv.parseStrings(csvList);
        List<String> materialData = this.getStringList(key, defaultMatNames);
        TreeSet<String> matNames = new TreeSet<String>();
        TreeSet<Material> materials = new TreeSet<Material>();
        for (String matName : materialData) {
            Material material = ConfigurationNode.toMaterial(matName);
            if (material == null) continue;
            materials.add(material);
            matNames.add(material.name().toLowerCase());
        }
        this.setProperty(key, matNames);
        return materials;
    }

    public Set<Material> getMaterials(String key, Collection<Material> def) {
        ArrayList<String> defaultMatNames = new ArrayList<String>();
        for (Material mat : def) {
            defaultMatNames.add(mat.name().toLowerCase());
        }
        List<String> materialData = this.getStringList(key, defaultMatNames);
        TreeSet<String> matNames = new TreeSet<String>();
        TreeSet<Material> materials = new TreeSet<Material>();
        for (String matName : materialData) {
            Material material = ConfigurationNode.toMaterial(matName);
            if (material == null) continue;
            materials.add(material);
            matNames.add(material.name().toLowerCase());
        }
        this.setProperty(key, matNames);
        return materials;
    }

    public double getDouble(String path, double def) {
        Double o = ConfigurationNode.castDouble(this.getProperty(path));
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public Double getDouble(String path, Double def) {
        Double o = ConfigurationNode.castDouble(this.getProperty(path));
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public boolean getBoolean(String path, boolean def) {
        Boolean o = ConfigurationNode.castBoolean(this.getProperty(path));
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public Boolean getBoolean(String path, Boolean def) {
        Boolean o = ConfigurationNode.castBoolean(this.getProperty(path));
        if (o == null) {
            this.setProperty(path, def);
            return def;
        }
        return o;
    }

    public BlockData getBlockData(String path) {
        return BlockData.fromString(this.getString(path));
    }

    public List<String> getKeys(String path) {
        if (path == null) {
            return this.getKeys();
        }
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            return new ArrayList<String>(((Map)o).keySet());
        }
        return null;
    }

    public List<String> getKeys() {
        Set<String> keys = this.root.keySet();
        ArrayList<String> stringKeys = new ArrayList<String>();
        for (String key : keys) {
            stringKeys.add(key.toString());
        }
        return stringKeys;
    }

    public List<Object> getList(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            return (List)o;
        }
        if (o instanceof String) {
            List<String> strings = csv.parseStrings((String)o);
            ArrayList<Object> list = new ArrayList<Object>();
            list.addAll(strings);
            return list;
        }
        return null;
    }

    public List<String> getStringList(String path, List<String> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            if (def != null) {
                this.setProperty(path, def);
                return def;
            }
            return new ArrayList<String>();
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : raw) {
            if (o == null) continue;
            list.add(o.toString());
        }
        return list;
    }

    public List<Integer> getIntList(String path, List<Integer> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object o : raw) {
            Integer i = ConfigurationNode.castInt(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    public List<Double> getDoubleList(String path, List<Double> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Double> list = new ArrayList<Double>();
        for (Object o : raw) {
            Double i = ConfigurationNode.castDouble(o);
            if (i == null) continue;
            list.add(i);
        }
        return list;
    }

    public List<Boolean> getBooleanList(String path, List<Boolean> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (Object o : raw) {
            Boolean tetsu = ConfigurationNode.castBoolean(o);
            if (tetsu == null) continue;
            list.add(tetsu);
        }
        return list;
    }

    public List<ConfigurationNode> getNodeList(String path, List<ConfigurationNode> def) {
        List<Object> raw = this.getList(path);
        if (raw == null) {
            return def != null ? def : new ArrayList();
        }
        ArrayList<ConfigurationNode> list = new ArrayList<ConfigurationNode>();
        for (Object o : raw) {
            if (!(o instanceof Map)) continue;
            list.add(new ConfigurationNode((Map)o));
        }
        return list;
    }

    public ConfigurationNode getNode(String path) {
        Object raw = this.getProperty(path);
        if (raw instanceof Map) {
            return new ConfigurationNode((Map)raw);
        }
        return null;
    }

    public boolean containsKey(String path) {
        Object test = this.getProperty(path);
        return test != null;
    }

    public ConfigurationNode getNode(String path, ConfigurationNode def) {
        Object raw = this.getProperty(path);
        if (raw instanceof Map) {
            return new ConfigurationNode((Map)raw);
        }
        this.setProperty(path, def.getAll());
        return def;
    }

    public Map<String, ConfigurationNode> getNodes(String path) {
        Object o = this.getProperty(path);
        if (o == null) {
            return null;
        }
        if (o instanceof Map) {
            HashMap<String, ConfigurationNode> nodes = new HashMap<String, ConfigurationNode>();
            for (Map.Entry entry : ((Map)o).entrySet()) {
                if (!(entry.getValue() instanceof Map)) continue;
                nodes.put((String)entry.getKey(), new ConfigurationNode((Map)entry.getValue()));
            }
            return nodes;
        }
        return null;
    }

    private static Integer castInt(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (int)((Byte)o);
        }
        if (o instanceof Integer) {
            return (Integer)o;
        }
        if (o instanceof Double) {
            return (int)((Double)o).doubleValue();
        }
        if (o instanceof Float) {
            return (int)((Float)o).floatValue();
        }
        if (o instanceof Long) {
            return (int)((Long)o).longValue();
        }
        if (o instanceof String) {
            try {
                return Integer.parseInt((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    private static Long castLong(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return (long)((Byte)o);
        }
        if (o instanceof Integer) {
            return (long)((Integer)o);
        }
        if (o instanceof Double) {
            return (long)((Double)o).doubleValue();
        }
        if (o instanceof Float) {
            return (long)((Float)o).floatValue();
        }
        if (o instanceof Long) {
            return (long)((Long)o);
        }
        if (o instanceof String) {
            try {
                return Long.parseLong((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    private static Double castDouble(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Float) {
            return ((Float)o).floatValue();
        }
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Byte) {
            return (double)((Byte)o);
        }
        if (o instanceof Integer) {
            return (double)((Integer)o);
        }
        if (o instanceof Long) {
            return (double)((Long)o);
        }
        if (o instanceof String) {
            try {
                return Double.parseDouble((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    private static Boolean castBoolean(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            try {
                return Boolean.parseBoolean((String)o);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public void removeProperty(String path) {
        if (!path.contains(".")) {
            this.root.remove(path);
            return;
        }
        String[] parts = path.split("\\.");
        Map node = this.root;
        int i = 0;
        while (i < parts.length) {
            Object o = node.get(parts[i]);
            if (i == parts.length - 1) {
                node.remove(parts[i]);
                return;
            }
            node = (Map)o;
            ++i;
        }
    }
}

