/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities.borrowed;

import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationException;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import com.elmakers.mine.bukkit.utilities.borrowed.EmptyNullRepresenter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;

public class Configuration
extends ConfigurationNode {
    private Yaml yaml;
    private File file;
    private InputStream inputStream;
    private String header = null;

    public Configuration(File file) {
        super(new HashMap<String, Object>());
        DumperOptions options = new DumperOptions();
        options.setIndent(4);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml((BaseConstructor)new SafeConstructor(), (Representer)new EmptyNullRepresenter(), options);
        this.file = file;
    }

    public Configuration(InputStream inputStream) {
        super(new HashMap<String, Object>());
        DumperOptions options = new DumperOptions();
        options.setIndent(4);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml((BaseConstructor)new SafeConstructor(), (Representer)new EmptyNullRepresenter(), options);
        this.inputStream = inputStream;
    }

    public void load() {
        try {
            try {
                if (this.inputStream == null) {
                    this.inputStream = new FileInputStream(this.file);
                }
                this.read(this.yaml.load((Reader)new UnicodeReader(this.inputStream)));
            }
            catch (IOException e) {
                this.root = new HashMap();
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            catch (ConfigurationException e) {
                this.root = new HashMap();
                try {
                    if (this.inputStream != null) {
                        this.inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        finally {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void setHeader(String ... headerLines) {
        StringBuilder header = new StringBuilder();
        String[] stringArray = headerLines;
        int n = headerLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (header.length() > 0) {
                header.append("\r\n");
            }
            header.append(line);
            ++n2;
        }
        this.setHeader(header.toString());
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public boolean save() {
        FileOutputStream stream = null;
        if (this.file == null) {
            return false;
        }
        File parent = this.file.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        try {
            stream = new FileOutputStream(this.file);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)stream, "UTF-8");
            if (this.header != null) {
                writer.append(this.header);
                writer.append("\r\n");
            }
            this.yaml.dump((Object)this.root, (Writer)writer);
            return true;
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return false;
    }

    private void read(Object input) throws ConfigurationException {
        try {
            this.root = input == null ? new HashMap() : (Map)input;
        }
        catch (ClassCastException e) {
            throw new ConfigurationException("Root document must be an key-value structure");
        }
    }

    public static ConfigurationNode getEmptyNode() {
        return new ConfigurationNode(new HashMap<String, Object>());
    }
}

