/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import java.util.HashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.util.Vector;

public class Targeting {
    private boolean allowMaxRange = false;
    private double hLength = 0.0;
    private int lastX = 0;
    private int lastY = 0;
    private int lastZ = 0;
    private double length = 0.0;
    private final Player player;
    private Location playerLocation;
    private int range = 200;
    private boolean reverseTargeting = false;
    private final double step = 0.2;
    private int targetHeightRequired = 1;
    private boolean targetingComplete = false;
    private final HashMap<Material, Boolean> targetThroughMaterials = new HashMap();
    private int targetX = 0;
    private int targetY = 0;
    private int targetZ = 0;
    private final double viewHeight = 1.65;
    private double xOffset = 0.0;
    private double xRotation = 0.0;
    private double yOffset = 0.0;
    private double yRotation = 0.0;
    private double zOffset = 0.0;

    public BlockFace goLeft(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    public BlockFace goRight(BlockFace direction) {
        switch (direction) {
            case EAST: {
                return BlockFace.SOUTH;
            }
            case SOUTH: {
                return BlockFace.WEST;
            }
            case WEST: {
                return BlockFace.NORTH;
            }
            case NORTH: {
                return BlockFace.EAST;
            }
        }
        return direction;
    }

    public Targeting(Player player) {
        this.player = player;
        this.reset();
    }

    public Location findPlaceToStand(Location playerLoc, boolean goUp) {
        int step = goUp ? 1 : -1;
        int x = (int)Math.round(playerLoc.getX() - 0.5);
        int y = (int)Math.round(playerLoc.getY() + (double)step + (double)step);
        int z = (int)Math.round(playerLoc.getZ() - 0.5);
        World world = this.player.getWorld();
        while (4 < y && y < 125) {
            Block block = world.getBlockAt(x, y, z);
            Block blockOneUp = world.getBlockAt(x, y + 1, z);
            Block blockTwoUp = world.getBlockAt(x, y + 2, z);
            if (this.isOkToStandOn(block.getType()) && this.isOkToStandIn(blockOneUp.getType()) && this.isOkToStandIn(blockTwoUp.getType())) {
                return new Location(world, (double)x + 0.5, (double)y + 1.0, (double)z + 0.5, playerLoc.getYaw(), playerLoc.getPitch());
            }
            y += step;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    protected void findTargetBlock() {
        if (!this.targetingComplete) ** GOTO lbl14
        return;
lbl-1000:
        // 1 sources

        {
            block = this.getCurBlock();
            if (!this.isTargetable(block.getType())) continue;
            enoughSpace = true;
            i = 1;
            while (i < this.targetHeightRequired) {
                if (!this.isTargetable((block = block.getRelative(BlockFace.UP)).getType())) {
                    enoughSpace = false;
                    break;
                }
                ++i;
            }
            if (enoughSpace) break;
lbl14:
            // 3 sources

            ** while (this.getNextBlock() != null)
        }
lbl15:
        // 2 sources

        this.targetingComplete = true;
    }

    public Vector getAimVector() {
        return new Vector(0.0 - Math.sin(Math.toRadians(this.playerLocation.getYaw())), 0.0 - Math.sin(Math.toRadians(this.playerLocation.getPitch())), Math.cos(Math.toRadians(this.playerLocation.getYaw())));
    }

    public Block getBlockAt(int x, int y, int z) {
        World world = this.player.getWorld();
        return world.getBlockAt(x, y, z);
    }

    public Block getCurBlock() {
        if (this.length > (double)this.range && !this.allowMaxRange) {
            return null;
        }
        return this.getBlockAt(this.targetX, this.targetY, this.targetZ);
    }

    public double getDistance(Location source, Location target) {
        return Math.sqrt(Math.pow(source.getX() - target.getX(), 2.0) + Math.pow(source.getY() - target.getY(), 2.0) + Math.pow(source.getZ() - target.getZ(), 2.0));
    }

    public double getDistance(Player player, Block target) {
        Location loc = player.getLocation();
        return Math.sqrt(Math.pow(loc.getX() - (double)target.getX(), 2.0) + Math.pow(loc.getY() - (double)target.getY(), 2.0) + Math.pow(loc.getZ() - (double)target.getZ(), 2.0));
    }

    public Block getFaceBlock() {
        this.findTargetBlock();
        if (this.getCurBlock() != null) {
            return this.getLastBlock();
        }
        return null;
    }

    public Block getLastBlock() {
        return this.getBlockAt(this.lastX, this.lastY, this.lastZ);
    }

    public Block getNextBlock() {
        this.lastX = this.targetX;
        this.lastY = this.targetY;
        this.lastZ = this.targetZ;
        do {
            this.length += 0.2;
            this.hLength = this.length * Math.cos(Math.toRadians(this.yRotation));
            this.yOffset = this.length * Math.sin(Math.toRadians(this.yRotation));
            this.xOffset = this.hLength * Math.cos(Math.toRadians(this.xRotation));
            this.zOffset = this.hLength * Math.sin(Math.toRadians(this.xRotation));
            this.targetX = (int)Math.floor(this.xOffset + this.playerLocation.getX());
            this.targetY = (int)Math.floor(this.yOffset + this.playerLocation.getY() + 1.65);
            this.targetZ = (int)Math.floor(this.zOffset + this.playerLocation.getZ());
        } while (this.length <= (double)this.range && this.targetX == this.lastX && this.targetY == this.lastY && this.targetZ == this.lastZ);
        if (this.length > (double)this.range) {
            if (this.allowMaxRange) {
                return this.getBlockAt(this.targetX, this.targetY, this.targetZ);
            }
            return null;
        }
        return this.getBlockAt(this.targetX, this.targetY, this.targetZ);
    }

    public Block getPlayerBlock() {
        Block playerBlock = null;
        Location playerLoc = this.player.getLocation();
        int x = (int)Math.round(playerLoc.getX() - 0.5);
        int y = (int)Math.round(playerLoc.getY() - 0.5);
        int z = (int)Math.round(playerLoc.getZ() - 0.5);
        int dy = 0;
        while (dy > -3 && (playerBlock == null || this.isOkToStandIn(playerBlock.getType()))) {
            playerBlock = this.player.getWorld().getBlockAt(x, y + dy, z);
            --dy;
        }
        return playerBlock;
    }

    public BlockFace getPlayerFacing() {
        float playerRot = this.getPlayerRotation();
        BlockFace direction = BlockFace.NORTH;
        if (playerRot <= 45.0f || playerRot > 315.0f) {
            direction = BlockFace.WEST;
        } else if (playerRot > 45.0f && playerRot <= 135.0f) {
            direction = BlockFace.NORTH;
        } else if (playerRot > 135.0f && playerRot <= 225.0f) {
            direction = BlockFace.EAST;
        } else if (playerRot > 225.0f && playerRot <= 315.0f) {
            direction = BlockFace.SOUTH;
        }
        return direction;
    }

    public float getPlayerRotation() {
        float playerRot = this.player.getLocation().getYaw();
        while (playerRot < 0.0f) {
            playerRot += 360.0f;
        }
        while (playerRot > 360.0f) {
            playerRot -= 360.0f;
        }
        return playerRot;
    }

    protected Location getProjectileSpawnLocation() {
        Block spawnBlock = this.getPlayerBlock();
        int height = 2;
        double hLength = 2.0;
        double xOffset = hLength * Math.cos(Math.toRadians(this.xRotation));
        double zOffset = hLength * Math.sin(Math.toRadians(this.xRotation));
        Vector aimVector = new Vector(xOffset + 0.5, (double)height + 0.5, zOffset + 0.5);
        Location location = new Location(this.player.getWorld(), (double)spawnBlock.getX() + aimVector.getX(), (double)spawnBlock.getY() + aimVector.getY(), (double)spawnBlock.getZ() + aimVector.getZ(), this.player.getLocation().getYaw(), this.player.getLocation().getPitch());
        return location;
    }

    public Block getTargetBlock() {
        this.findTargetBlock();
        return this.getCurBlock();
    }

    public int getTargetHeightRequired() {
        return this.targetHeightRequired;
    }

    public double getXRotation() {
        return this.xRotation;
    }

    public double getYRotation() {
        return this.yRotation;
    }

    public boolean isOkToStandIn(Material mat) {
        return mat == Material.AIR || mat == Material.WATER || mat == Material.STATIONARY_WATER;
    }

    public boolean isOkToStandOn(Material mat) {
        return mat != Material.AIR && mat != Material.LAVA && mat != Material.STATIONARY_LAVA;
    }

    public boolean isReverseTargeting() {
        return this.reverseTargeting;
    }

    public boolean isTargetable(Material mat) {
        Boolean checkMat = this.targetThroughMaterials.get(mat);
        if (this.reverseTargeting) {
            return checkMat != null && checkMat != false;
        }
        return checkMat == null || checkMat == false;
    }

    public void noTargetThrough(Material mat) {
        this.targetThroughMaterials.put(mat, false);
    }

    public void reset() {
        this.playerLocation = this.player.getLocation();
        this.length = 0.0;
        this.targetHeightRequired = 1;
        this.xRotation = (this.playerLocation.getYaw() + 90.0f) % 360.0f;
        this.yRotation = this.playerLocation.getPitch() * -1.0f;
        this.reverseTargeting = false;
        this.targetX = (int)Math.floor(this.playerLocation.getX());
        this.targetY = (int)Math.floor(this.playerLocation.getY() + 1.65);
        this.targetZ = (int)Math.floor(this.playerLocation.getZ());
        this.lastX = this.targetX;
        this.lastY = this.targetY;
        this.lastZ = this.targetZ;
        this.targetingComplete = false;
    }

    public void setMaxRange(int range, boolean allow) {
        this.range = range;
        this.allowMaxRange = allow;
    }

    public void setReverseTargeting(boolean reverse) {
        this.reverseTargeting = reverse;
    }

    public void setTargetHeightRequired(int height) {
        this.targetHeightRequired = height;
    }

    public void targetThrough(Material mat) {
        this.targetThroughMaterials.put(mat, true);
    }
}

