/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import com.elmakers.mine.bukkit.utilities.borrowed.Configuration;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.Plugin;

public class Messages {
    private static final String messagesFileName = "messages.yml";
    private static final String messagesFileNameDefaults = "messages.defaults.yml";
    public static Map<String, String> messageMap = new HashMap<String, String>();

    public static void loadProperties(ConfigurationNode messages) {
        Map<String, Object> allMap = messages.getAll();
        for (Map.Entry<String, Object> entry : allMap.entrySet()) {
            messageMap.put(entry.getKey(), (String)entry.getValue());
        }
    }

    public static void load(Plugin plugin) {
        File dataFolder = plugin.getDataFolder();
        File oldDefaults = new File(dataFolder, messagesFileNameDefaults);
        oldDefaults.delete();
        plugin.getLogger().info("Overwriting file messages.defaults.yml");
        plugin.saveResource(messagesFileNameDefaults, false);
        plugin.getLogger().info("Loading default localizations from messages.defaults.yml");
        Messages.loadProperties(plugin.getResource(messagesFileNameDefaults));
        File propertiesFile = new File(dataFolder, messagesFileName);
        if (propertiesFile.exists()) {
            plugin.getLogger().info("Overriding default localizations using " + propertiesFile);
            Messages.loadProperties(propertiesFile);
        }
    }

    private static void loadProperties(File propertiesFile) {
        Messages.loadProperties(new Configuration(propertiesFile));
    }

    private static void loadProperties(InputStream properties) {
        Messages.loadProperties(new Configuration(properties));
    }

    private static void loadProperties(Configuration properties) {
        properties.load();
        Messages.loadProperties((ConfigurationNode)properties);
    }

    public static void reset() {
        messageMap.clear();
    }

    public static String get(String key, String defaultValue) {
        return messageMap.containsKey(key) ? messageMap.get(key) : defaultValue;
    }

    public static String get(String key) {
        return Messages.get(key, key);
    }
}

