/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.effects.EffectRing;
import com.elmakers.mine.bukkit.effects.EffectTrail;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class LevitateSpell
extends Spell {
    private long levitateEnded;
    private final long safetyLength = 10000L;
    private static final int effectSpeed = 2;
    private static final int effectPeriod = 2;
    private static final int maxEffectRange = 16;
    private static final int maxRingEffectRange = 4;
    private static final int ringEffectAmount = 6;

    public SpellResult onCast(ConfigurationNode parameters) {
        if (this.getPlayer().getAllowFlight()) {
            this.deactivate();
            return SpellResult.COST_FREE;
        }
        this.activate();
        return SpellResult.SUCCESS;
    }

    public void onDeactivate() {
        this.getPlayer().setFlying(false);
        this.getPlayer().setAllowFlight(false);
        this.controller.registerEvent(SpellEventType.PLAYER_DAMAGE, this);
        this.levitateEnded = System.currentTimeMillis();
        this.castMessage("You feel heavier");
    }

    public void onActivate() {
        int effectRange = Math.min(this.getMaxRange(), 8);
        Location effectLocation = this.getPlayer().getEyeLocation();
        Vector effectDirection = new Vector(0, 1, 0);
        EffectTrail effect = new EffectTrail((Plugin)this.controller.getPlugin(), effectLocation, effectDirection, effectRange);
        effect.setParticleType(ParticleType.SPELL);
        effect.setParticleCount(3);
        Color effectColor = this.mage.getEffectColor();
        effect.setEffectData(effectColor != null ? effectColor.asRGB() : 0xFF00FF);
        effect.setParticleOffset(4.0f, 4.0f, 4.0f);
        effect.setSpeed(2.0f);
        effect.setPeriod(2);
        effect.start();
        Vector velocity = this.getPlayer().getVelocity();
        velocity.setY(velocity.getY() + 2.0);
        this.getPlayer().setVelocity(velocity);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.controller.getPlugin(), new Runnable(){

            public void run() {
                LevitateSpell.this.getPlayer().setAllowFlight(true);
                LevitateSpell.this.getPlayer().setFlying(true);
            }
        }, 2L);
        this.castMessage("You feel lighter");
    }

    public void onPlayerDamage(EntityDamageEvent event) {
        if (event.getCause() != EntityDamageEvent.DamageCause.FALL) {
            return;
        }
        this.controller.unregisterEvent(SpellEventType.PLAYER_DAMAGE, this);
        if (this.levitateEnded == 0L) {
            return;
        }
        if (this.levitateEnded + 10000L > System.currentTimeMillis()) {
            event.setCancelled(true);
            this.levitateEnded = 0L;
            Location effectLocation = event.getEntity().getLocation();
            Block block = event.getEntity().getLocation().getBlock();
            block = block.getRelative(BlockFace.DOWN);
            int effectRange = Math.min(this.getMaxRange(), 2);
            EffectRing effect = new EffectRing((Plugin)this.controller.getPlugin(), effectLocation, effectRange, 6);
            effect.setEffect(Effect.STEP_SOUND);
            effect.setData(block.getTypeId());
            effect.setSpeed(2.0f);
            effect.setPeriod(2);
            effect.start();
        }
    }
}

