/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.BlockRecurse;
import com.elmakers.mine.bukkit.blocks.FillBatch;
import com.elmakers.mine.bukkit.blocks.ReplaceMaterialAction;
import com.elmakers.mine.bukkit.effects.EffectUtils;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class FillSpell
extends BrushSpell {
    private static final int DEFAULT_MAX_DIMENSION = 128;
    private static final int DEFAULT_MAX_VOLUME = 512;
    private Block targetBlock = null;
    private final BlockRecurse blockRecurse = new BlockRecurse();

    public SpellResult onCast(ConfigurationNode parameters) {
        this.noTargetThrough(Material.STATIONARY_WATER);
        this.noTargetThrough(Material.WATER);
        Block targetBlock = this.getTargetBlock();
        boolean singleBlock = false;
        boolean recurse = false;
        String typeString = parameters.getString("type", "");
        singleBlock = typeString.equals("single");
        recurse = typeString.equals("recurse");
        if (targetBlock == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialBrush buildWith = this.getMaterialBrush();
        Material material = buildWith.getMaterial();
        byte data = buildWith.getData();
        if (recurse) {
            this.deactivate();
            int size = parameters.getInt("size", 8);
            size = (int)(this.mage.getRadiusMultiplier() * (float)size);
            this.blockRecurse.setMaxRecursion(size);
            Material targetMaterial = targetBlock.getType();
            ReplaceMaterialAction action = new ReplaceMaterialAction(this.mage, targetBlock, buildWith);
            if (targetMaterial == Material.STATIONARY_WATER) {
                action.addReplaceable(Material.WATER);
            } else if (targetMaterial == Material.WATER) {
                action.addReplaceable(Material.STATIONARY_WATER);
            } else if (targetMaterial == Material.STATIONARY_LAVA) {
                action.addReplaceable(Material.LAVA);
            } else if (targetMaterial == Material.LAVA) {
                action.addReplaceable(Material.STATIONARY_LAVA);
            }
            this.blockRecurse.recurse(targetBlock, action);
            this.mage.registerForUndo(action.getBlocks());
            this.controller.updateBlock(targetBlock);
            this.castMessage("Filled " + action.getBlocks().size() + " blocks with " + material.name().toLowerCase());
            return SpellResult.SUCCESS;
        }
        if (singleBlock) {
            this.deactivate();
            BlockList filledBlocks = new BlockList();
            filledBlocks.add(targetBlock);
            targetBlock.setType(material);
            targetBlock.setData(data);
            this.controller.updateBlock(targetBlock);
            this.castMessage("Painting with " + material.name().toLowerCase());
            this.mage.registerForUndo(filledBlocks);
            return SpellResult.SUCCESS;
        }
        if (this.targetBlock != null) {
            FillBatch batch = new FillBatch(this, targetBlock.getLocation(), this.targetBlock.getLocation(), buildWith);
            int maxDimension = parameters.getInteger("max_dimension", 128);
            int maxVolume = parameters.getInteger("max_volume", 512);
            maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)maxDimension);
            maxVolume = (int)(this.mage.getConstructionMultiplier() * (float)maxVolume);
            if (!batch.checkDimension(maxDimension)) {
                this.sendMessage("Dimension is too big!");
                return SpellResult.FAILURE;
            }
            if (!batch.checkVolume(maxVolume)) {
                this.sendMessage("Volume is too big!");
                return SpellResult.FAILURE;
            }
            this.mage.addPendingBlockBatch(batch);
            this.deactivate();
            return SpellResult.SUCCESS;
        }
        Location effectLocation = targetBlock.getLocation();
        effectLocation.add(0.5, 0.5, 0.5);
        EffectUtils.playEffect(effectLocation, ParticleType.HAPPY_VILLAGER, 0.3f, 0.3f, 0.3f, 1.0f, 16);
        this.targetBlock = targetBlock;
        this.activate();
        buildWith.setTarget(targetBlock.getLocation());
        this.castMessage("Cast again to fill with " + material.name().toLowerCase());
        return SpellResult.SUCCESS;
    }

    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.sendMessage("Cancelled fill");
            this.targetBlock = null;
            return true;
        }
        return false;
    }

    public void onDeactivate() {
        this.targetBlock = null;
    }
}

