/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.player.PlayerEvent;

public class FamiliarSpell
extends Spell {
    private String DEFAULT_FAMILIARS = "Chicken,Sheep,Cow,Pig,Wolf,Villager,MushroomCow,Snowman,Ozelot,VillagerGolem,HorseEntity";
    private String DEFAULT_MONSTERS = "Creeper,PigZombie,Skeleton,Spider,Zombie,Ghast,Giant,Silverfish,Enderman,CaveSpider,Blaze,LavaSlime,Bat,Witch";
    private final Random rand = new Random();
    private PlayerFamiliar familiars = new PlayerFamiliar();

    public SpellResult onCast(ConfigurationNode parameters) {
        Block originalTarget;
        if (!this.mage.hasBuildPermission(this.getPlayer().getLocation().getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        this.noTargetThrough(Material.STATIONARY_WATER);
        this.noTargetThrough(Material.WATER);
        this.targetEntity(LivingEntity.class);
        Target target = this.getTarget();
        if (target == null || !target.hasTarget()) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = originalTarget = target.getBlock();
        LivingEntity targetEntity = null;
        boolean hasFamiliar = this.familiars.hasFamiliar();
        if (hasFamiliar) {
            boolean isFamiliar;
            boolean bl = isFamiliar = target.isEntity() && this.familiars.isFamiliar(target.getEntity());
            if (isFamiliar) {
                this.castMessage("You release your familiar(s)");
                this.checkListener();
                this.familiars.releaseFamiliar(target.getEntity());
                return SpellResult.SUCCESS;
            }
            this.familiars.releaseFamiliar();
        }
        if (target.isEntity()) {
            targetBlock = targetBlock.getRelative(BlockFace.SOUTH);
            Entity e = target.getEntity();
            if (e instanceof LivingEntity) {
                targetEntity = (LivingEntity)e;
            }
        }
        targetBlock = targetBlock.getRelative(BlockFace.UP);
        EntityType famType = EntityType.PIG;
        FamiliarClass famClass = FamiliarClass.FRIENDLY;
        int famCount = parameters.getInt("count", 1);
        String famTypeName = parameters.getString("type", "");
        if (famTypeName.equalsIgnoreCase("any")) {
            famClass = FamiliarClass.ANY;
        } else if (famTypeName.equalsIgnoreCase("mob")) {
            famClass = FamiliarClass.MONSTER;
        } else if (famTypeName.length() > 1) {
            String testType = famTypeName.toUpperCase();
            EntityType[] entityTypeArray = EntityType.values();
            int n = entityTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                EntityType ct = entityTypeArray[n2];
                String name = ct.getName();
                if (name != null && name.toUpperCase().equals(testType)) {
                    famType = ct;
                    famClass = FamiliarClass.SPECIFIC;
                }
                ++n2;
            }
        }
        if (originalTarget.getType() == Material.WATER || originalTarget.getType() == Material.STATIONARY_WATER) {
            famType = EntityType.SQUID;
            famClass = FamiliarClass.SPECIFIC;
        }
        ArrayList<Creature> newFamiliars = new ArrayList<Creature>();
        int spawnCount = 0;
        int i = 0;
        while (i < famCount) {
            Creature entity;
            if (famClass != FamiliarClass.SPECIFIC) {
                if (famClass == FamiliarClass.ANY) {
                    int randomFamiliar = this.rand.nextInt(EntityType.values().length - 1);
                    famType = EntityType.values()[randomFamiliar];
                } else {
                    List<String> types = csv.parseStrings(this.DEFAULT_FAMILIARS);
                    if (famClass == FamiliarClass.MONSTER) {
                        types = csv.parseStrings(this.DEFAULT_MONSTERS);
                    }
                    int randomFamiliar = this.rand.nextInt(types.size());
                    famType = EntityType.fromName((String)types.get(randomFamiliar));
                }
            }
            Location targetLoc = targetBlock.getLocation();
            if (famCount > 1) {
                targetLoc.setX(targetLoc.getX() + (double)this.rand.nextInt(2 * famCount) - (double)famCount);
                targetLoc.setZ(targetLoc.getZ() + (double)this.rand.nextInt(2 * famCount) - (double)famCount);
            }
            if (famType != null && (entity = this.spawnFamiliar(targetLoc, famType, targetEntity)) != null) {
                newFamiliars.add(entity);
                ++spawnCount;
            }
            ++i;
        }
        String typeMessage = "";
        if (famClass == FamiliarClass.SPECIFIC) {
            typeMessage = " " + famType.name().toLowerCase();
        } else if (famClass != FamiliarClass.ANY) {
            typeMessage = " " + famClass.name().toLowerCase();
        }
        this.castMessage("You create " + spawnCount + typeMessage + " familiar(s)!");
        this.familiars.setFamiliars(newFamiliars);
        this.checkListener();
        return SpellResult.SUCCESS;
    }

    protected Creature spawnFamiliar(Location target, EntityType famType, LivingEntity targetEntity) {
        Entity famEntity;
        Creature familiar;
        block4: {
            familiar = null;
            famEntity = this.getPlayer().getWorld().spawnEntity(target, famType);
            if (famEntity instanceof Creature) break block4;
            return null;
        }
        try {
            familiar = (Creature)famEntity;
            if (targetEntity != null) {
                familiar.setTarget(targetEntity);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return familiar;
    }

    protected void checkListener() {
        if (this.familiars.hasFamiliar()) {
            this.controller.registerEvent(SpellEventType.PLAYER_QUIT, this);
        } else {
            this.controller.unregisterEvent(SpellEventType.PLAYER_QUIT, this);
        }
    }

    public void onPlayerQuit(PlayerEvent event) {
        if (this.familiars.hasFamiliar()) {
            this.familiars.releaseFamiliar();
            this.checkListener();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FamiliarClass {
        SPECIFIC,
        ANY,
        FRIENDLY,
        MONSTER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class PlayerFamiliar {
        public List<Creature> familiars = null;

        public boolean hasFamiliar() {
            return this.familiars != null;
        }

        public void setFamiliars(List<Creature> f) {
            this.familiars = f;
        }

        public void releaseFamiliar() {
            if (this.familiars != null) {
                for (Creature familiar : this.familiars) {
                    familiar.setHealth(0.0);
                }
                this.familiars = null;
            }
        }

        public void releaseFamiliar(Entity entity) {
            if (this.familiars != null) {
                ArrayList<Creature> iterate = new ArrayList<Creature>(this.familiars);
                for (Creature familiar : iterate) {
                    if (familiar.getUniqueId() != entity.getUniqueId()) continue;
                    familiar.setHealth(0.0);
                    this.familiars.remove(familiar);
                }
                this.familiars = null;
            }
        }

        public boolean isFamiliar(Entity e) {
            if (this.familiars == null) {
                return false;
            }
            for (Creature c : this.familiars) {
                if (c.getEntityId() != e.getEntityId()) continue;
                return true;
            }
            return false;
        }
    }
}

