/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.effects.EffectTrail;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.BlockSpell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class DisintegrateSpell
extends BlockSpell {
    private static final int DEFAULT_PLAYER_DAMAGE = 1;
    private static final int DEFAULT_ENTITY_DAMAGE = 100;
    private static final int maxEffectRange = 16;
    private static final int effectSpeed = 1;
    private static final int effectPeriod = 2;
    private static final float particleData = 1.0f;
    private static final int particleCount = 6;

    public SpellResult onCast(ConfigurationNode parameters) {
        Entity targetEntity;
        int effectRange = Math.min(this.getMaxRange(), 16);
        Location effectLocation = this.getPlayer().getEyeLocation();
        Vector effectDirection = effectLocation.getDirection();
        EffectTrail effectTrail = new EffectTrail((Plugin)this.controller.getPlugin(), effectLocation, effectDirection, effectRange);
        effectTrail.setParticleType(ParticleType.LAVA_DRIPPING);
        effectTrail.setParticleCount(6);
        effectTrail.setEffectData(1.0f);
        effectTrail.setParticleOffset(0.2f, 0.2f, 0.2f);
        effectTrail.setSpeed(1.0f);
        effectTrail.setPeriod(2);
        effectTrail.start();
        Target target = this.getTarget();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        int playerDamage = parameters.getInteger("player_damage", 1);
        int entityDamage = parameters.getInteger("entity_damage", 100);
        if (target.isEntity() && (targetEntity = target.getEntity()) instanceof LivingEntity) {
            LivingEntity li = (LivingEntity)targetEntity;
            if (li instanceof Player) {
                li.damage((double)(this.mage.getDamageMultiplier() * (float)playerDamage), (Entity)this.getPlayer());
            } else {
                li.damage((double)(this.mage.getDamageMultiplier() * (float)entityDamage), (Entity)this.getPlayer());
            }
            this.castMessage("ZOT!");
            return SpellResult.SUCCESS;
        }
        if (!target.hasTarget()) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = target.getBlock();
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.mage.isIndestructible(targetBlock)) {
            return SpellResult.NO_TARGET;
        }
        if (this.isUnderwater()) {
            targetBlock.setType(Material.STATIONARY_WATER);
        } else {
            targetBlock.setType(Material.AIR);
        }
        BlockList disintigrated = new BlockList();
        disintigrated.add(targetBlock);
        this.mage.registerForUndo(disintigrated);
        this.castMessage("ZAP!");
        return SpellResult.SUCCESS;
    }
}

