/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.MaterialList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.BlockVector;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BoundingBox {
    protected BlockVector max;
    protected BlockVector min;

    public BoundingBox() {
    }

    public BoundingBox(BlockVector min, BlockVector max) {
        this.min = min;
        this.max = max;
    }

    public BoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.min = new BlockVector(Math.min(minX, maxX), Math.min(minY, maxY), Math.min(minZ, maxZ));
        this.max = new BlockVector(Math.max(minX, maxX), Math.max(minY, maxY), Math.max(minZ, maxZ));
    }

    public BoundingBox centered(BlockVector newCenter) {
        return this;
    }

    public BoundingBox contain(BlockVector newPoint) {
        if (this.contains(newPoint)) {
            return this;
        }
        BlockVector newMin = new BlockVector(Vector.getMinimum((Vector)this.min, (Vector)newPoint));
        BlockVector newMax = new BlockVector(Vector.getMaximum((Vector)this.max, (Vector)newPoint));
        BoundingBox newBB = new BoundingBox(newMin, newMax);
        return newBB;
    }

    public boolean contains(BlockVector p) {
        return p.isInAABB((Vector)this.min, (Vector)this.max);
    }

    public void fill(World world, Material material) {
        this.fill(world, material, null, null);
    }

    public void fill(World world, Material material, MaterialList destructable) {
        this.fill(world, material, destructable, null);
    }

    public void fill(World world, Material material, MaterialList destructable, BlockList affected) {
        int x = this.min.getBlockX();
        while (x < this.max.getBlockX()) {
            int y = this.min.getBlockY();
            while (y < this.max.getBlockY()) {
                int z = this.min.getBlockZ();
                while (z < this.max.getBlockZ()) {
                    Block block = world.getBlockAt(x, y, z);
                    if (destructable == null) {
                        if (affected != null) {
                            affected.add(block);
                        }
                        block.setType(material);
                    } else {
                        Material blockType = block.getType();
                        if (destructable.contains(blockType)) {
                            if (affected != null) {
                                affected.add(block);
                            }
                            block.setType(material);
                        }
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public void getBlocks(World world, List<Block> blocks) {
        int x = this.min.getBlockX();
        while (x < this.max.getBlockX()) {
            int y = this.min.getBlockY();
            while (y < this.max.getBlockY()) {
                int z = this.min.getBlockZ();
                while (z < this.max.getBlockZ()) {
                    Block block = world.getBlockAt(x, y, z);
                    blocks.add(block);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public BlockVector getCenter() {
        Vector center = new Vector(this.min.getX(), this.min.getY(), this.min.getZ());
        center = center.getMidpoint((Vector)this.max);
        return new BlockVector(center);
    }

    public BoundingBox getFace(BlockFace face) {
        return this.getFace(face, 1, 0);
    }

    public BoundingBox getFace(BlockFace face, int thickness, int offset) {
        switch (face) {
            case UP: {
                return new BoundingBox(this.min.getBlockX(), this.max.getBlockY() + offset, this.min.getBlockZ(), this.max.getBlockX(), this.max.getBlockY() + offset + thickness, this.max.getBlockZ());
            }
            case DOWN: {
                return new BoundingBox(this.min.getBlockX(), this.min.getBlockY() - offset - thickness, this.min.getBlockZ(), this.max.getBlockX(), this.min.getBlockY() - offset, this.max.getBlockZ());
            }
            case WEST: {
                return new BoundingBox(this.min.getBlockX(), this.min.getBlockY(), this.max.getBlockZ() + offset, this.max.getBlockX(), this.max.getBlockY(), this.max.getBlockZ() + offset + thickness);
            }
            case EAST: {
                return new BoundingBox(this.min.getBlockX(), this.min.getBlockY(), this.min.getBlockZ() - offset - thickness, this.max.getBlockX(), this.max.getBlockY(), this.min.getBlockZ() - offset);
            }
            case SOUTH: {
                return new BoundingBox(this.max.getBlockX() + offset, this.min.getBlockY(), this.min.getBlockZ(), this.max.getBlockX() + offset + thickness, this.max.getBlockY(), this.max.getBlockZ());
            }
            case NORTH: {
                return new BoundingBox(this.min.getBlockX() - offset - thickness, this.min.getBlockY(), this.min.getBlockZ(), this.min.getBlockX() - offset, this.max.getBlockY(), this.max.getBlockZ());
            }
        }
        return null;
    }

    public BlockVector getMax() {
        return this.max;
    }

    public BlockVector getMin() {
        return this.min;
    }

    public int getSizeX() {
        return this.max.getBlockX() - this.min.getBlockX();
    }

    public int getSizeY() {
        return this.max.getBlockY() - this.min.getBlockY();
    }

    public int getSizeZ() {
        return this.max.getBlockZ() - this.min.getBlockZ();
    }

    public BoundingBox scale(double scale) {
        return new BoundingBox(this.min, this.max);
    }

    public void setMax(BlockVector max) {
        this.max = max;
    }

    public void setMin(BlockVector min) {
        this.min = min;
    }

    public BoundingBox translate(BlockVector direction) {
        return this;
    }
}

