/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.util.Vector;

public class IterateSpell
extends BrushSpell {
    private int DEFAULT_SIZE = 16;

    public SpellResult onCast(ConfigurationNode parameters) {
        int timeToLive = parameters.getInt("undo", 0);
        boolean incrementData = parameters.getBoolean("increment_data", false);
        int size = parameters.getInt("size", this.DEFAULT_SIZE);
        size = (int)(this.mage.getConstructionMultiplier() * (float)size);
        Block target = this.getTargetBlock();
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(target) || !this.hasBuildPermission(this.getPlayer().getLocation().getBlock())) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        int iterateBlocks = (int)this.getPlayer().getLocation().distance(target.getLocation());
        if (iterateBlocks <= 0) {
            return SpellResult.NO_TARGET;
        }
        iterateBlocks = Math.min(iterateBlocks, size);
        Vector targetLoc = new Vector(target.getX(), target.getY(), target.getZ());
        Vector playerLoc = new Vector(this.getPlayer().getLocation().getX(), this.getPlayer().getLocation().getY() + 1.0, this.getPlayer().getLocation().getZ());
        Vector aim = targetLoc;
        aim.subtract(playerLoc);
        aim.normalize();
        targetLoc = playerLoc;
        targetLoc.add(aim);
        targetLoc.add(aim);
        MaterialBrush buildWith = this.getMaterialBrush();
        buildWith.setTarget(target.getLocation());
        buildWith.update(target.getLocation());
        BlockList iteratedBlocks = new BlockList();
        int i = 0;
        while (i < iterateBlocks) {
            Block currentTarget = target.getWorld().getBlockAt(targetLoc.getBlockX(), targetLoc.getBlockY(), targetLoc.getBlockZ());
            if (currentTarget.getType() == Material.AIR && this.isDestructible(currentTarget) && this.hasBuildPermission(currentTarget)) {
                iteratedBlocks.add(currentTarget);
                buildWith.update(currentTarget.getLocation());
                Material material = buildWith.getMaterial();
                byte data = buildWith.getData();
                if (incrementData) {
                    data = (byte)(i > 15 ? 15 : (byte)i);
                }
                currentTarget.setType(material);
                currentTarget.setData(data);
                this.controller.updateBlock(currentTarget);
                Location effectLocation = currentTarget.getLocation();
                effectLocation.getWorld().playEffect(effectLocation, Effect.STEP_SOUND, material.getId());
            }
            targetLoc.add(aim);
            ++i;
        }
        if (iteratedBlocks.size() > 0) {
            iteratedBlocks.setTimeToLive(timeToLive);
            this.mage.registerForUndo(iteratedBlocks);
        }
        this.castMessage("Filled " + iteratedBlocks.size() + " blocks");
        return SpellResult.SUCCESS;
    }
}

