/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class ExtendSpell
extends BrushSpell {
    int MAX_SEARCH_DISTANCE = 16;

    public SpellResult onCast(ConfigurationNode parameters) {
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            this.castMessage("You need to be standing on something");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(playerBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        BlockFace direction = this.getPlayerFacing();
        Block attachBlock = playerBlock;
        Block targetBlock = attachBlock.getRelative(direction);
        MaterialBrush buildWith = this.getMaterialBrush();
        buildWith.setTarget(targetBlock.getLocation());
        Material material = buildWith.getMaterial();
        byte data = buildWith.getData();
        int distance = 0;
        while (this.isTargetable(targetBlock.getType()) && distance <= this.MAX_SEARCH_DISTANCE) {
            ++distance;
            attachBlock = targetBlock;
            targetBlock = attachBlock.getRelative(direction);
        }
        if (this.isTargetable(targetBlock.getType())) {
            this.castMessage("Can't bridge any further");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(targetBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        BlockList bridgeBlocks = new BlockList();
        bridgeBlocks.add(targetBlock);
        targetBlock.setType(material);
        targetBlock.setData(data);
        this.castMessage("A bridge extends!");
        this.mage.registerForUndo(bridgeBlocks);
        this.controller.updateBlock(targetBlock);
        return SpellResult.SUCCESS;
    }
}

