/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.ConstructBatch;
import com.elmakers.mine.bukkit.blocks.ConstructionType;
import com.elmakers.mine.bukkit.effects.EffectUtils;
import com.elmakers.mine.bukkit.effects.ParticleType;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.util.Vector;

public class ConstructSpell
extends BrushSpell {
    private ConstructionType defaultConstructionType = ConstructionType.SPHERE;
    private int defaultRadius = 2;
    private Block targetBlock = null;
    private static final int DEFAULT_MAX_DIMENSION = 128;

    public SpellResult onCast(ConfigurationNode parameters) {
        String typeString;
        ConstructionType testType;
        this.targetThrough(Material.GLASS);
        Block target = this.getTarget().getBlock();
        if (target == null) {
            this.initializeTargeting(this.getPlayer());
            this.noTargetThrough(Material.GLASS);
            target = this.getTarget().getBlock();
        }
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        int timeToLive = parameters.getInt("undo", 0);
        int radius = parameters.getInt("radius", this.defaultRadius);
        radius = parameters.getInt("size", radius);
        boolean falling = parameters.getBoolean("falling", false);
        float force = 0.0f;
        force = (float)parameters.getDouble("speed", force);
        String targetString = parameters.getString("target", "");
        if (targetString.equals("select")) {
            if (this.targetBlock == null) {
                this.targetBlock = target;
                Location effectLocation = this.targetBlock.getLocation();
                effectLocation.add(0.5, 0.5, 0.5);
                EffectUtils.playEffect(effectLocation, ParticleType.HAPPY_VILLAGER, 0.3f, 0.3f, 0.3f, 1.5f, 10);
                this.castMessage("Cast again to construct");
                this.activate();
                return SpellResult.COST_FREE;
            }
            radius = (int)this.targetBlock.getLocation().distance(target.getLocation());
            target = this.targetBlock;
        } else {
            radius = (int)(this.mage.getRadiusMultiplier() * (float)radius);
        }
        int maxDimension = (int)(this.mage.getConstructionMultiplier() * (float)parameters.getInteger("max_dimension", 128));
        int diameter = radius * 2;
        if (diameter > maxDimension) {
            this.sendMessage("Dimension is too big!");
            return SpellResult.FAILURE;
        }
        if (parameters.containsKey("y_offset")) {
            target = target.getRelative(BlockFace.UP, parameters.getInt("y_offset", 0));
        }
        if (!this.hasBuildPermission(target)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        MaterialBrush buildWith = this.getMaterialBrush();
        buildWith.setTarget(target.getLocation());
        ConstructionType conType = this.defaultConstructionType;
        boolean hollow = false;
        String fillType = parameters.getString("fill", "");
        hollow = fillType.equals("hollow");
        Vector forceVector = null;
        if (falling && force != 0.0f) {
            forceVector = this.getPlayer().getLocation().getDirection();
            forceVector.setY(-forceVector.getY()).normalize().multiply(force);
        }
        if ((testType = ConstructionType.parseString(typeString = parameters.getString("type", ""), ConstructionType.UNKNOWN)) != ConstructionType.UNKNOWN) {
            conType = testType;
        }
        this.fillArea(target, radius, buildWith, !hollow, conType, timeToLive, falling, forceVector);
        this.deactivate();
        return SpellResult.SUCCESS;
    }

    public void fillArea(Block target, int radius, MaterialBrush brush, boolean fill, ConstructionType type, int timeToLive, boolean falling, Vector forceVector) {
        ConstructBatch batch = new ConstructBatch(this, target.getLocation(), type, radius, fill, falling);
        if (forceVector != null) {
            batch.setFallingBlockVelocity(forceVector);
        }
        if (timeToLive > 0) {
            batch.setTimeToLive(timeToLive);
        }
        this.mage.addPendingBlockBatch(batch);
    }

    public void onDeactivate() {
        this.targetBlock = null;
    }

    public boolean onCancel() {
        if (this.targetBlock != null) {
            this.sendMessage("Cancelled construct");
            this.targetBlock = null;
            return true;
        }
        return false;
    }
}

