/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.essentials.MagicItemDb;
import com.elmakers.mine.bukkit.essentials.Mailer;
import com.elmakers.mine.bukkit.plugins.magic.BrushSpell;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MagicPlugin;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellEventType;
import com.elmakers.mine.bukkit.plugins.magic.populator.WandChestPopulator;
import com.elmakers.mine.bukkit.plugins.magic.wand.Wand;
import com.elmakers.mine.bukkit.plugins.magic.wand.WandLevel;
import com.elmakers.mine.bukkit.utilities.CSVParser;
import com.elmakers.mine.bukkit.utilities.InventoryUtils;
import com.elmakers.mine.bukkit.utilities.Messages;
import com.elmakers.mine.bukkit.utilities.SetActiveItemSlotTask;
import com.elmakers.mine.bukkit.utilities.URLMap;
import com.elmakers.mine.bukkit.utilities.borrowed.Configuration;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.block.BlockPhysicsEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.enchantment.EnchantItemEvent;
import org.bukkit.event.enchantment.PrepareItemEnchantEvent;
import org.bukkit.event.entity.EntityCombustEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.ItemDespawnEvent;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.inventory.CraftItemEvent;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.inventory.PrepareItemCraftEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.inventory.CraftingInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapCommonAPI;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MagicController
implements Listener {
    private final String spellsFileName = "spells.yml";
    private final String propertiesFileName = "magic.yml";
    private final String playersFileName = "players.yml";
    private final String spellsFileNameDefaults = "spells.defaults.yml";
    private final String propertiesFileNameDefaults = "magic.defaults.yml";
    static final String DEFAULT_BUILDING_MATERIALS = "0,1,2,3,4,5,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,29,33,34,35,41,42,43,45,46,47,48,49,52,53,55,56,57,58,60,61,62,65,66,67,73,74,79,80,81,82,83,84,85,86,87,88,89,90,91,92,93,94,95,96,97,98,99,100,101,102,103,104,105,106,107,108,109";
    static final String DEFAULT_INDESTRUCTIBLE_MATERIALS = "7,54,130";
    static final String DEFAULT_DESTRUCTIBLE_MATERIALS = "0,1,2,3,4,8,9,10,11,12,13,87,88";
    static final String DEFAULT_TARGET_THROUGH_MATERIALS = "0";
    static final String STICKY_MATERIALS = "37,38,39,50,51,55,59,63,64,65,66,68,70,71,72,75,76,77,78,83";
    static final String STICKY_MATERIALS_DOUBLE_HEIGHT = "64,71,";
    private Set<Material> buildingMaterials = new TreeSet<Material>();
    private Set<Material> indestructibleMaterials = new TreeSet<Material>();
    private Set<Material> destructibleMaterials = new TreeSet<Material>();
    private Set<Material> stickyMaterials = new TreeSet<Material>();
    private Set<Material> stickyMaterialsDoubleHeight = new TreeSet<Material>();
    private Set<Material> targetThroughMaterials = new TreeSet<Material>();
    private long physicsDisableTimeout = 0L;
    private int undoQueueDepth = 256;
    private boolean wandCycling = false;
    private boolean showMessages = true;
    private boolean showCastMessages = false;
    private String messagePrefix = "";
    private String castMessagePrefix = "";
    private boolean soundsEnabled = true;
    private boolean fillWands = false;
    private boolean indestructibleWands = true;
    private boolean keepWandsOnDeath = true;
    private int messageThrottle = 0;
    private int clickCooldown = 150;
    private boolean blockPopulatorEnabled = false;
    private boolean craftingEnabled = false;
    private boolean enchantingEnabled = false;
    private boolean combiningEnabled = false;
    private boolean organizingEnabled = false;
    private boolean essentialsSignsEnabled = false;
    private boolean dynmapUpdate = true;
    private boolean dynmapShowWands = true;
    private float maxDamagePowerMultiplier = 2.0f;
    private float maxConstructionPowerMultiplier = 5.0f;
    private float maxRadiusPowerMultiplier = 1.5f;
    private float maxRangePowerMultiplier = 3.0f;
    private float castCommandCostReduction = 1.0f;
    private float castCommandCooldownReduction = 1.0f;
    private ConfigurationNode blockPopulatorConfig = null;
    private int maxBlockUpdates = 100;
    private int autoUndo = 0;
    private final HashMap<String, Spell> spells = new HashMap();
    private final HashMap<String, Mage> mages = new HashMap();
    private Recipe wandRecipe = null;
    private Material wandRecipeUpperMaterial = Material.DIAMOND;
    private Material wandRecipeLowerMaterial = Material.BLAZE_ROD;
    private String recipeOutputTemplate = "random(1)";
    private MagicPlugin plugin = null;
    private boolean regionManagerEnabled = true;
    private Object regionManager = null;
    private DynmapCommonAPI dynmap = null;
    private Mailer mailer = null;
    private Material defaultMaterial = Material.DIRT;

    public MagicController(MagicPlugin plugin) {
        this.plugin = plugin;
    }

    public Mage getMage(Player player) {
        Mage mage = this.mages.get(player.getName());
        if (mage == null) {
            mage = new Mage(this, player);
            this.mages.put(player.getName(), mage);
        }
        mage.setPlayer(player);
        return mage;
    }

    public Mage getMage(String playerName) {
        if (!this.mages.containsKey(playerName)) {
            this.mages.put(playerName, new Mage(this, null));
        }
        return this.mages.get(playerName);
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString) {
        this.createSpell(template, name, icon, description, category, parameterString, null, null);
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString, String propertiesString) {
        this.createSpell(template, name, icon, description, category, parameterString, propertiesString, null);
    }

    public void createSpell(Spell template, String name, Material icon, String description, String category, String parameterString, String propertiesString, String costsString) {
        ConfigurationNode spellNode = new ConfigurationNode();
        ConfigurationNode parameterNode = spellNode.createChild("parameters");
        ConfigurationNode propertiesNode = spellNode.createChild("properties");
        if (parameterString != null && parameterString.length() > 0) {
            String[] parameters = parameterString.split(" ");
            Spell.addParameters(parameters, parameterNode);
        }
        if (propertiesString != null && propertiesString.length() > 0) {
            String[] properties = propertiesString.split(" ");
            Spell.addParameters(properties, propertiesNode);
        }
        if (costsString != null && costsString.length() > 0) {
            ArrayList costs = new ArrayList();
            String[] costPairs = costsString.split(" ");
            int i = 0;
            while (i < costPairs.length - 1) {
                try {
                    int amount = Integer.parseInt(costPairs[i + 1]);
                    HashMap<String, Object> cost = new HashMap<String, Object>();
                    cost.put("material", costPairs[i]);
                    cost.put("amount", amount);
                    costs.add(cost);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                i += 2;
            }
            spellNode.setProperty("costs", costs);
        }
        spellNode.setProperty("description", description);
        spellNode.setProperty("icon", icon);
        spellNode.setProperty("category", category);
        template.initialize(this);
        template.loadTemplate(name, spellNode);
        this.addSpell(template);
    }

    public void addSpell(Spell variant) {
        Spell conflict = this.spells.get(variant.getKey());
        if (conflict != null) {
            this.getLogger().log(Level.WARNING, "Duplicate spell name: '" + conflict.getKey() + "'");
        } else {
            this.spells.put(variant.getKey(), variant);
        }
    }

    public Set<Material> getBuildingMaterials() {
        return this.buildingMaterials;
    }

    public Set<Material> getDestructibleMaterials() {
        return this.destructibleMaterials;
    }

    public Set<Material> getTargetThroughMaterials() {
        return this.targetThroughMaterials;
    }

    public float getMaxDamagePowerMultiplier() {
        return this.maxDamagePowerMultiplier;
    }

    public float getMaxConstructionPowerMultiplier() {
        return this.maxConstructionPowerMultiplier;
    }

    public float getMaxRadiusPowerMultiplier() {
        return this.maxRadiusPowerMultiplier;
    }

    public float getMaxRangePowerMultiplier() {
        return this.maxRangePowerMultiplier;
    }

    public int getAutoUndoInterval() {
        return this.autoUndo;
    }

    public int getUndoQueueDepth() {
        return this.undoQueueDepth;
    }

    public String undoAny(Block target) {
        for (String playerName : this.mages.keySet()) {
            Mage mage = this.getMage(playerName);
            if (!mage.undo(target)) continue;
            return playerName;
        }
        return null;
    }

    public boolean undo(String playerName) {
        Mage mage = this.getMage(playerName);
        return mage.undo();
    }

    public boolean commitAll() {
        boolean undid = false;
        for (Mage mage : this.mages.values()) {
            boolean bl = undid = undid || mage.commit();
        }
        return undid;
    }

    public void registerEvent(SpellEventType type, Spell spell) {
        Mage spells = this.getMage(spell.getPlayer());
        spells.registerEvent(type, spell);
    }

    public void unregisterEvent(SpellEventType type, Spell spell) {
        Mage spells = this.getMage(spell.getPlayer());
        spells.unregisterEvent(type, spell);
    }

    public boolean cancel(Player player) {
        Mage mage = this.getMage(player);
        return mage.cancel();
    }

    public String getMessagePrefix() {
        return this.messagePrefix;
    }

    public String getCastMessagePrefix() {
        return this.castMessagePrefix;
    }

    public boolean showCastMessages() {
        return this.showCastMessages;
    }

    public boolean showMessages() {
        return this.showMessages;
    }

    public int getMessageThrottle() {
        return this.messageThrottle;
    }

    public boolean soundsEnabled() {
        return this.soundsEnabled;
    }

    public boolean fillWands() {
        return this.fillWands;
    }

    public boolean isSolid(Material mat) {
        return mat != Material.AIR && mat != Material.WATER && mat != Material.STATIONARY_WATER && mat != Material.LAVA && mat != Material.STATIONARY_LAVA;
    }

    public boolean isSticky(Material mat) {
        return this.stickyMaterials.contains(mat);
    }

    public boolean isStickyAndTall(Material mat) {
        return this.stickyMaterialsDoubleHeight.contains(mat);
    }

    public boolean isAffectedByGravity(Material mat) {
        return mat == Material.GRAVEL || mat == Material.SAND || mat == Material.WOOD_DOOR || mat == Material.IRON_DOOR;
    }

    public Logger getLogger() {
        return this.plugin.getLogger();
    }

    public MagicPlugin getPlugin() {
        return this.plugin;
    }

    public boolean isIndestructible(Location location) {
        return this.isIndestructible(location.getBlock());
    }

    public boolean isIndestructible(Block block) {
        return this.indestructibleMaterials.contains(block.getType());
    }

    public boolean isDestructible(Block block) {
        return this.destructibleMaterials.contains(block.getType());
    }

    public boolean hasBuildPermission(Player player, Location location) {
        return this.hasBuildPermission(player, location.getBlock());
    }

    public boolean hasBuildPermission(Player player, Block block) {
        if (!this.regionManagerEnabled || this.regionManager == null || player == null) {
            return true;
        }
        try {
            Method canBuildMethod = this.regionManager.getClass().getMethod("canBuild", Player.class, Block.class);
            if (canBuildMethod != null) {
                return (Boolean)canBuildMethod.invoke(this.regionManager, player, block);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    public void initialize() {
        Plugin essentials;
        CSVParser csv = new CSVParser();
        this.stickyMaterials = csv.parseMaterials(STICKY_MATERIALS);
        this.stickyMaterialsDoubleHeight = csv.parseMaterials(STICKY_MATERIALS_DOUBLE_HEIGHT);
        this.buildingMaterials = csv.parseMaterials(DEFAULT_BUILDING_MATERIALS);
        this.indestructibleMaterials = csv.parseMaterials(DEFAULT_INDESTRUCTIBLE_MATERIALS);
        this.destructibleMaterials = csv.parseMaterials(DEFAULT_DESTRUCTIBLE_MATERIALS);
        this.targetThroughMaterials = csv.parseMaterials(DEFAULT_TARGET_THROUGH_MATERIALS);
        this.load();
        if (this.craftingEnabled) {
            Wand wand = new Wand(this);
            ShapedRecipe recipe = new ShapedRecipe(wand.getItem());
            recipe.shape(new String[]{"o", "i"}).setIngredient('o', this.wandRecipeUpperMaterial).setIngredient('i', this.wandRecipeLowerMaterial);
            this.wandRecipe = recipe;
        }
        if ((essentials = this.plugin.getServer().getPluginManager().getPlugin("Essentials")) != null) {
            this.mailer = new Mailer(essentials);
        }
        if (this.essentialsSignsEnabled) {
            final MagicController me = this;
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                public void run() {
                    try {
                        Plugin essentials = me.plugin.getServer().getPluginManager().getPlugin("Essentials");
                        if (essentials != null) {
                            Class<?> essentialsClass = essentials.getClass();
                            Field itemDbField = essentialsClass.getDeclaredField("itemDb");
                            itemDbField.setAccessible(true);
                            Object oldEntry = itemDbField.get(essentials);
                            if (oldEntry instanceof MagicItemDb) {
                                MagicController.this.getLogger().info("Essentials integration already set up, skipping");
                                return;
                            }
                            if (!oldEntry.getClass().getName().equals("com.earth2me.essentials.ItemDb")) {
                                MagicController.this.getLogger().info("Essentials Item DB class unexepcted: " + oldEntry.getClass().getName() + ", skipping integration");
                                return;
                            }
                            MagicItemDb newEntry = new MagicItemDb(me, essentials);
                            itemDbField.set(essentials, (Object)newEntry);
                            Field confListField = essentialsClass.getDeclaredField("confList");
                            confListField.setAccessible(true);
                            List confList = (List)confListField.get(essentials);
                            confList.remove(oldEntry);
                            confList.add(newEntry);
                            MagicController.this.getLogger().info("Essentials found, hooked up custom item handler");
                        }
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                    }
                }
            }, 5L);
        }
        if (this.regionManagerEnabled) {
            try {
                this.regionManager = this.plugin.getServer().getPluginManager().getPlugin("WorldGuard");
                Method canBuildMethod = this.regionManager.getClass().getMethod("canBuild", Player.class, Block.class);
                if (canBuildMethod != null) {
                    this.getLogger().info("WorldGuard found, will respect build permissions for construction spells");
                } else {
                    this.regionManager = null;
                }
            }
            catch (Throwable canBuildMethod) {
                // empty catch block
            }
            if (this.regionManager == null) {
                this.getLogger().info("WorldGuard not found, not using a region manager.");
            }
        } else {
            this.getLogger().info("Region manager disabled");
        }
        try {
            Plugin dynmapPlugin = this.plugin.getServer().getPluginManager().getPlugin("dynmap");
            if (!(dynmapPlugin instanceof DynmapCommonAPI)) {
                throw new Exception("Dynmap plugin found, but class is not DynmapCommonAPI");
            }
            this.dynmap = (DynmapCommonAPI)dynmapPlugin;
        }
        catch (Throwable ex) {
            this.plugin.getLogger().warning(ex.getMessage());
        }
        if (this.dynmap == null) {
            this.getLogger().info("dynmap not found, not integrating.");
        }
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            public void run() {
                for (Mage spells : MagicController.this.mages.values()) {
                    spells.tick();
                }
            }
        }, 0L, 20L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, new Runnable(){

            public void run() {
                for (Mage mage : MagicController.this.mages.values()) {
                    mage.processPendingBatches(MagicController.this.maxBlockUpdates);
                }
            }
        }, 0L, 1L);
    }

    public void updateBlock(Block block) {
        this.updateBlock(block.getWorld().getName(), block.getX(), block.getY(), block.getZ());
    }

    public void updateBlock(String worldName, int x, int y, int z) {
        if (this.dynmap != null && this.dynmapUpdate) {
            this.dynmap.triggerRenderOfBlock(worldName, x, y, z);
        }
    }

    public void updateVolume(String worldName, int minx, int miny, int minz, int maxx, int maxy, int maxz) {
        if (this.dynmap != null && this.dynmapUpdate) {
            this.dynmap.triggerRenderOfVolume(worldName, minx, miny, minz, maxx, maxy, maxz);
        }
    }

    public boolean removeMarker(String id, String group) {
        Marker marker;
        MarkerAPI markers;
        MarkerSet markerSet;
        boolean removed = false;
        if (this.dynmap != null && this.dynmapShowWands && this.dynmap.markerAPIInitialized() && (markerSet = (markers = this.dynmap.getMarkerAPI()).getMarkerSet(group)) != null && (marker = markerSet.findMarker(id)) != null) {
            removed = true;
            marker.deleteMarker();
        }
        return removed;
    }

    public boolean addMarker(String id, String group, String title, String world, int x, int y, int z, String description) {
        boolean created = false;
        if (this.dynmap != null && this.dynmapShowWands && this.dynmap.markerAPIInitialized()) {
            Marker marker;
            MarkerIcon wandIcon;
            MarkerAPI markers = this.dynmap.getMarkerAPI();
            MarkerSet markerSet = markers.getMarkerSet(group);
            if (markerSet == null) {
                markerSet = markers.createMarkerSet(group, "Wands", null, false);
            }
            if ((wandIcon = markers.getMarkerIcon("wand")) == null) {
                wandIcon = markers.createMarkerIcon("wand", "Wand", this.plugin.getResource("wand_icon32.png"));
            }
            if ((marker = markerSet.findMarker(id)) == null) {
                created = true;
                marker = markerSet.createMarker(id, title, world, x, y, z, wandIcon, false);
            } else {
                marker.setLocation(world, x, y, z);
                marker.setLabel(title);
            }
            marker.setDescription(description);
        }
        return created;
    }

    public void load() {
        final File dataFolder = this.plugin.getDataFolder();
        dataFolder.mkdirs();
        Messages.reset();
        Messages.load((Plugin)this.plugin);
        File oldDefaults = new File(dataFolder, "magic.defaults.yml");
        oldDefaults.delete();
        this.getLogger().info("Overwriting file magic.defaults.yml");
        this.plugin.saveResource("magic.defaults.yml", false);
        File propertiesFile = new File(dataFolder, "magic.yml");
        try {
            this.getLogger().info("Loading defaults from: magic.defaults.yml");
            this.loadProperties(this.plugin.getResource("magic.defaults.yml"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            if (!propertiesFile.exists()) {
                this.getLogger().info("Saving template magic.yml, edit to customize configuration.");
                this.plugin.saveResource("magic.yml", false);
            } else {
                this.getLogger().info("Loading customizations from: " + propertiesFile.getName());
                this.loadProperties(propertiesFile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        oldDefaults = new File(dataFolder, "spells.defaults.yml");
        oldDefaults.delete();
        this.getLogger().info("Overwriting file spells.defaults.yml");
        this.plugin.saveResource("spells.defaults.yml", false);
        File spellsFile = new File(dataFolder, "spells.yml");
        try {
            if (!spellsFile.exists()) {
                this.getLogger().info("Loading default spells from: spells.defaults.yml");
                this.load(this.plugin.getResource("spells.defaults.yml"));
            } else {
                this.getLogger().info("Loading spells from: " + spellsFile.getName());
                this.load(spellsFile);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            public void run() {
                File playersFile = new File(dataFolder, "players.yml");
                if (playersFile.exists()) {
                    MagicController.this.getLogger().info("Loading player data from file " + playersFile.getName());
                    Configuration playerConfiguration = new Configuration(playersFile);
                    playerConfiguration.load();
                    List<String> playerNames = playerConfiguration.getKeys();
                    for (String playerName : playerNames) {
                        MagicController.this.getMage(playerName).load(playerConfiguration.getNode(playerName));
                    }
                }
            }
        }, 5L);
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            public void run() {
                URLMap.resetAll();
                URLMap.load((Plugin)MagicController.this.plugin);
            }
        }, 20L);
        Wand.load((Plugin)this.plugin);
        this.getLogger().info("Magic: Loaded " + this.spells.size() + " spells and " + Wand.getWandTemplates().size() + " wands");
    }

    public void save() {
        File dataFolder = this.plugin.getDataFolder();
        dataFolder.mkdirs();
        File playersFile = new File(dataFolder, "players.yml");
        Configuration playerConfiguration = new Configuration(playersFile);
        for (Map.Entry<String, Mage> spellsEntry : this.mages.entrySet()) {
            ConfigurationNode playerNode = playerConfiguration.createChild(spellsEntry.getKey());
            spellsEntry.getValue().save(playerNode);
        }
        playerConfiguration.save();
    }

    protected void load(File spellsFile) {
        this.load(new Configuration(spellsFile));
    }

    protected void load(InputStream spellsConfig) {
        this.load(new Configuration(spellsConfig));
    }

    protected void load(Configuration config) {
        config.load();
        ConfigurationNode spellsNode = config.getNode("spells");
        if (spellsNode == null) {
            return;
        }
        List<String> spellKeys = spellsNode.getKeys();
        for (String key : spellKeys) {
            ConfigurationNode spellNode;
            Spell newSpell = Spell.loadSpell(key, spellNode = spellsNode.getNode(key), this);
            if (newSpell == null) {
                this.getLogger().warning("Magic: Error loading spell " + key);
                continue;
            }
            this.addSpell(newSpell);
        }
    }

    protected void loadProperties(File propertiesFile) {
        this.loadProperties(new Configuration(propertiesFile));
    }

    protected void loadProperties(InputStream properties) {
        this.loadProperties(new Configuration(properties));
    }

    protected void loadProperties(Configuration properties) {
        properties.load();
        ConfigurationNode generalNode = properties.getNode("general");
        this.undoQueueDepth = generalNode.getInteger("undo_depth", this.undoQueueDepth);
        this.wandCycling = generalNode.getBoolean("right_click_cycles", this.wandCycling);
        this.showMessages = generalNode.getBoolean("show_messages", this.showMessages);
        this.showCastMessages = generalNode.getBoolean("show_cast_messages", this.showCastMessages);
        this.messagePrefix = generalNode.getString("message_prefix", this.messagePrefix);
        this.castMessagePrefix = generalNode.getString("cast_message_prefix", this.castMessagePrefix);
        this.clickCooldown = generalNode.getInt("click_cooldown", this.clickCooldown);
        this.messageThrottle = generalNode.getInt("message_throttle", 0);
        this.maxBlockUpdates = generalNode.getInt("max_block_updates", this.maxBlockUpdates);
        this.soundsEnabled = generalNode.getBoolean("sounds", this.soundsEnabled);
        this.fillWands = generalNode.getBoolean("fill_wands", this.fillWands);
        this.indestructibleWands = generalNode.getBoolean("indestructible_wands", this.indestructibleWands);
        this.keepWandsOnDeath = generalNode.getBoolean("keep_wands_on_death", this.keepWandsOnDeath);
        this.maxDamagePowerMultiplier = (float)generalNode.getDouble("max_power_damage_multiplier", this.maxDamagePowerMultiplier);
        this.maxConstructionPowerMultiplier = (float)generalNode.getDouble("max_power_construction_multiplier", this.maxConstructionPowerMultiplier);
        this.maxRangePowerMultiplier = (float)generalNode.getDouble("max_power_range_multiplier", this.maxRangePowerMultiplier);
        this.maxRadiusPowerMultiplier = (float)generalNode.getDouble("max_power_radius_multiplier", this.maxRadiusPowerMultiplier);
        this.castCommandCostReduction = (float)generalNode.getDouble("cast_command_cost_reduction", this.castCommandCostReduction);
        this.castCommandCooldownReduction = (float)generalNode.getDouble("cast_command_cooldown_reduction", this.castCommandCooldownReduction);
        this.autoUndo = generalNode.getInteger("auto_undo", this.autoUndo);
        this.blockPopulatorEnabled = generalNode.getBoolean("enable_block_populator", this.blockPopulatorEnabled);
        this.enchantingEnabled = generalNode.getBoolean("enable_enchanting", this.enchantingEnabled);
        this.combiningEnabled = generalNode.getBoolean("enable_combining", this.combiningEnabled);
        this.organizingEnabled = generalNode.getBoolean("enable_organizing", this.organizingEnabled);
        this.essentialsSignsEnabled = generalNode.getBoolean("enable_essentials_signs", this.essentialsSignsEnabled);
        this.dynmapShowWands = generalNode.getBoolean("dynamp_show_wands", this.dynmapShowWands);
        this.dynmapUpdate = generalNode.getBoolean("dynmap_update", this.dynmapUpdate);
        this.regionManagerEnabled = generalNode.getBoolean("region_manager_enabled", this.regionManagerEnabled);
        this.blockPopulatorConfig = generalNode.getNode("populate_chests");
        this.buildingMaterials = generalNode.getMaterials("building", this.buildingMaterials);
        this.indestructibleMaterials = generalNode.getMaterials("indestructible", this.indestructibleMaterials);
        this.destructibleMaterials = generalNode.getMaterials("destructible", this.destructibleMaterials);
        this.targetThroughMaterials = generalNode.getMaterials("target_through", this.targetThroughMaterials);
        Wand.WandMaterial = generalNode.getMaterial("wand_item", Wand.WandMaterial);
        Wand.CopyMaterial = generalNode.getMaterial("copy_item", Wand.CopyMaterial);
        Wand.EraseMaterial = generalNode.getMaterial("erase_item", Wand.EraseMaterial);
        Wand.CloneMaterial = generalNode.getMaterial("clone_item", Wand.CloneMaterial);
        Wand.ReplicateMaterial = generalNode.getMaterial("replicate_item", Wand.ReplicateMaterial);
        Wand.EnchantableWandMaterial = generalNode.getMaterial("wand_item_enchantable", Wand.EnchantableWandMaterial);
        this.craftingEnabled = generalNode.getBoolean("enable_crafting", this.craftingEnabled);
        if (this.craftingEnabled) {
            this.recipeOutputTemplate = generalNode.getString("crafting_output", this.recipeOutputTemplate);
            this.wandRecipeUpperMaterial = generalNode.getMaterial("crafting_material_upper", this.wandRecipeUpperMaterial);
            this.wandRecipeLowerMaterial = generalNode.getMaterial("crafting_material_lower", this.wandRecipeLowerMaterial);
        }
    }

    protected void clear() {
        this.mages.clear();
        this.spells.clear();
    }

    public List<Spell> getAllSpells() {
        ArrayList<Spell> allSpells = new ArrayList<Spell>();
        allSpells.addAll(this.spells.values());
        return allSpells;
    }

    protected boolean allowPhysics(Block block) {
        if (this.physicsDisableTimeout == 0L) {
            return true;
        }
        if (System.currentTimeMillis() > this.physicsDisableTimeout) {
            this.physicsDisableTimeout = 0L;
        }
        return false;
    }

    public void disablePhysics(int interval) {
        this.physicsDisableTimeout = System.currentTimeMillis() + (long)interval;
    }

    public boolean hasWandPermission(Player player) {
        return this.hasPermission(player, "Magic.wand.use", true);
    }

    public boolean hasPermission(Player player, String pNode, boolean defaultValue) {
        boolean isSet = player.isPermissionSet(pNode);
        return isSet ? player.hasPermission(pNode) : defaultValue;
    }

    public boolean hasPermission(Player player, String pNode) {
        return this.hasPermission(player, pNode, false);
    }

    public boolean hasPermission(CommandSender sender, String pNode) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode, false);
    }

    public boolean hasPermission(CommandSender sender, String pNode, boolean defaultValue) {
        if (!(sender instanceof Player)) {
            return true;
        }
        return this.hasPermission((Player)sender, pNode, defaultValue);
    }

    @EventHandler
    public void onContainerClick(InventoryDragEvent event) {
        ItemStack oldStack = event.getOldCursor();
        if (oldStack != null && oldStack.hasItemMeta()) {
            event.setCancelled(true);
            return;
        }
    }

    protected void onPlayerActivateIcon(Mage mage, Wand activeWand, ItemStack icon) {
        if (icon != null && icon.getType() != Material.AIR) {
            Spell spell = mage.getSpell(Wand.getSpell(icon));
            if (spell != null) {
                mage.cancel();
                activeWand.setActiveSpell(spell.getKey());
            } else {
                Material material = icon.getType();
                if (this.buildingMaterials.contains(material) || material == Wand.EraseMaterial || material == Wand.CopyMaterial || material == Wand.CloneMaterial || material == Wand.ReplicateMaterial) {
                    activeWand.activateMaterial(material, icon.getData().getData());
                }
            }
        }
    }

    @EventHandler
    public void onPlayerEquip(PlayerItemHeldEvent event) {
        Player player = event.getPlayer();
        PlayerInventory inventory = player.getInventory();
        ItemStack next = inventory.getItem(event.getNewSlot());
        ItemStack previous = inventory.getItem(event.getPreviousSlot());
        Mage mage = this.getMage(player);
        Wand activeWand = mage.getActiveWand();
        if (activeWand != null && Wand.isWand(previous)) {
            if (activeWand.isInventoryOpen()) {
                activeWand.setItem(previous);
                this.onPlayerActivateIcon(mage, activeWand, next);
                Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)((Object)new SetActiveItemSlotTask(player, event.getPreviousSlot())), 1L);
                return;
            }
            activeWand.deactivate();
        }
        if (next != null && Wand.isWand(next)) {
            Wand newWand = new Wand(this, next);
            newWand.activate(mage);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Mage spells = this.getMage(event.getPlayer());
        spells.onPlayerMove(event);
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        if (event.getEntityType() == EntityType.PLAYER && event.getEntity() instanceof Player) {
            this.onPlayerDeath((Player)event.getEntity(), event);
        }
    }

    protected void onPlayerDeath(final Player player, EntityDeathEvent event) {
        String rule = player.getWorld().getGameRuleValue("keepInventory");
        if (rule.equals("true")) {
            return;
        }
        Mage mage = this.getMage(player);
        List drops = event.getDrops();
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            if (mage.hasStoredInventory()) {
                ItemStack[] armor;
                drops.clear();
                ItemStack[] stored = mage.getStoredInventory().getContents();
                wand.deactivate();
                ItemStack[] itemStackArray = stored;
                int n = stored.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemStack stack = itemStackArray[n2];
                    if (stack != null) {
                        drops.add(stack);
                    }
                    ++n2;
                }
                ItemStack[] itemStackArray2 = armor = player.getInventory().getArmorContents();
                int n3 = armor.length;
                n = 0;
                while (n < n3) {
                    ItemStack stack = itemStackArray2[n];
                    if (stack != null) {
                        drops.add(stack);
                    }
                    ++n;
                }
            } else {
                wand.deactivate();
            }
        }
        if (this.keepWandsOnDeath) {
            ArrayList oldDrops = new ArrayList(drops);
            final ArrayList<ItemStack> droppedWands = new ArrayList<ItemStack>();
            drops.clear();
            for (ItemStack itemStack : oldDrops) {
                if (Wand.isWand(itemStack)) {
                    droppedWands.add(itemStack);
                    continue;
                }
                drops.add(itemStack);
            }
            if (droppedWands.size() > 0) {
                Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                    public void run() {
                        for (ItemStack itemStack : droppedWands) {
                            player.getInventory().addItem(new ItemStack[]{itemStack});
                        }
                    }
                }, 5L);
            }
        }
        mage.onPlayerDeath(event);
    }

    public void onPlayerDamage(Player player, EntityDamageEvent event) {
        Mage spells = this.getMage(player);
        spells.onPlayerDamage(event);
    }

    @EventHandler
    public void onEntityCombust(EntityCombustEvent event) {
        if (!(event.getEntity() instanceof Player)) {
            return;
        }
        Mage spells = this.getMage((Player)event.getEntity());
        spells.onPlayerCombust(event);
    }

    @EventHandler
    public void onItemDespawn(ItemDespawnEvent event) {
        if ((this.indestructibleWands || this.dynmapShowWands) && Wand.isWand(event.getEntity().getItemStack())) {
            Wand wand;
            if (this.indestructibleWands) {
                event.getEntity().setTicksLived(1);
                event.setCancelled(true);
            } else if (this.dynmapShowWands && this.removeMarker("wand-" + (wand = new Wand(this, event.getEntity().getItemStack())).getId(), "Wands")) {
                this.getLogger().info("Wand despawned, removed from map");
            }
        }
    }

    @EventHandler
    public void onItemSpawn(ItemSpawnEvent event) {
        if ((this.indestructibleWands || this.dynmapShowWands) && Wand.isWand(event.getEntity().getItemStack())) {
            Wand wand;
            if (this.indestructibleWands) {
                InventoryUtils.setInvulnerable((Entity)event.getEntity());
            }
            if (this.dynmapShowWands && (wand = new Wand(this, event.getEntity().getItemStack())) != null) {
                this.addWandMarker(wand, event.getEntity().getLocation());
            }
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        Item item;
        ItemStack itemStack;
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)event.getEntity();
            this.onPlayerDamage(player, event);
        }
        if (entity instanceof Item && (this.indestructibleWands || this.dynmapShowWands) && Wand.isWand(itemStack = (item = (Item)entity).getItemStack())) {
            Wand wand;
            if (this.indestructibleWands) {
                event.setCancelled(true);
            } else if (this.dynmapShowWands && event.getDamage() >= (double)itemStack.getDurability() && this.removeMarker("wand-" + (wand = new Wand(this, item.getItemStack())).getId(), "Wands")) {
                this.plugin.getLogger().info("Wand destroyed, removed from map");
            }
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        boolean toggleInventory;
        Player player = event.getPlayer();
        Mage mage = this.getMage(player);
        if (!mage.checkLastClick(this.clickCooldown)) {
            return;
        }
        Wand wand = mage.getActiveWand();
        if (wand == null && Wand.hasActiveWand(player)) {
            if (mage.hasStoredInventory()) {
                mage.restoreInventory();
            }
            wand = Wand.getActiveWand(this, player);
            wand.activate(mage);
        }
        if (wand == null && mage.hasStoredInventory()) {
            mage.restoreInventory();
            return;
        }
        if (wand == null || !this.hasWandPermission(player)) {
            return;
        }
        if (!Wand.hasActiveWand(player)) {
            wand.deactivate();
        }
        if (event.getAction() == Action.LEFT_CLICK_AIR || event.getAction() == Action.LEFT_CLICK_BLOCK) {
            wand.cast();
        }
        boolean bl = toggleInventory = event.getAction() == Action.RIGHT_CLICK_AIR;
        if (!toggleInventory && event.getAction() == Action.RIGHT_CLICK_BLOCK) {
            Material material = event.getClickedBlock().getType();
            boolean bl2 = toggleInventory = material != Material.CHEST && material != Material.WOODEN_DOOR && material != Material.IRON_DOOR_BLOCK && material != Material.ENDER_CHEST && material != Material.ANVIL && material != Material.BREWING_STAND && material != Material.ENCHANTMENT_TABLE && material != Material.STONE_BUTTON && material != Material.LEVER && material != Material.FURNACE && material != Material.BED && material != Material.SIGN_POST && material != Material.COMMAND && material != Material.WALL_SIGN;
            if (material == Material.SIGN_POST || material == Material.WALL_SIGN) {
                wand.closeInventory();
            }
        }
        if (toggleInventory) {
            if (!mage.cancel()) {
                if (this.wandCycling) {
                    if (player.isSneaking()) {
                        Spell activeSpell = wand.getActiveSpell();
                        boolean cycleMaterials = false;
                        if (activeSpell != null && activeSpell instanceof BrushSpell) {
                            BrushSpell brushSpell = (BrushSpell)activeSpell;
                            boolean bl3 = cycleMaterials = brushSpell.hasBrushOverride() && wand.getMaterialKeys().size() > 0;
                        }
                        if (cycleMaterials) {
                            wand.cycleMaterials();
                        } else {
                            wand.cycleSpells();
                        }
                    } else {
                        wand.cycleSpells();
                    }
                } else if (wand.getHasInventory()) {
                    wand.toggleInventory();
                }
            } else {
                mage.playSound(Sound.NOTE_BASS, 1.0f, 0.7f);
            }
        }
    }

    @EventHandler
    public void onBlockPhysics(BlockPhysicsEvent event) {
        if (!this.allowPhysics(event.getBlock())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        Mage mage = this.getMage(player);
        Wand wand = Wand.getActiveWand(this, player);
        if (wand != null) {
            wand.activate(mage);
        }
    }

    @EventHandler
    public void onPlayerExpChange(PlayerExpChangeEvent event) {
        if (event.getAmount() <= 0) {
            return;
        }
        Player player = event.getPlayer();
        Mage mage = this.getMage(player);
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            wand.onPlayerExpChange(event);
        }
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        URLMap.resend(player.getName());
        Mage mage = this.getMage(player);
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            wand.deactivate();
        }
        mage.restoreInventory();
        mage.onPlayerQuit(event);
        mage.setActiveWand(null);
        mage.setPlayer(null);
    }

    @EventHandler
    public void onPluginDisable(PluginDisableEvent event) {
        for (Mage spells : this.mages.values()) {
            Player player = spells.getPlayer();
            if (player == null) continue;
            Wand wand = spells.getActiveWand();
            if (wand != null) {
                wand.deactivate();
            }
            spells.restoreInventory();
            player.updateInventory();
        }
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent event) {
        Player[] players;
        Player[] playerArray = players = this.plugin.getServer().getOnlinePlayers();
        int n = players.length;
        int n2 = 0;
        while (n2 < n) {
            Player player = playerArray[n2];
            Wand wand = Wand.getActiveWand(this, player);
            if (wand != null) {
                Mage spells = this.getMage(player);
                wand.activate(spells);
                player.updateInventory();
            }
            ++n2;
        }
        if (this.wandRecipe != null) {
            this.plugin.getServer().addRecipe(this.wandRecipe);
        }
    }

    @EventHandler
    public void onPrepareCraftItem(PrepareItemCraftEvent event) {
        Recipe recipe = event.getRecipe();
        if (this.craftingEnabled && this.wandRecipe != null && recipe.getResult().getType() == Wand.WandMaterial) {
            CraftingInventory inventory = event.getInventory();
            if (!inventory.contains(this.wandRecipeLowerMaterial) || !inventory.contains(this.wandRecipeUpperMaterial)) {
                return;
            }
            Wand wand = Wand.createWand(this, this.recipeOutputTemplate);
            if (wand == null) {
                wand = new Wand(this);
            }
            event.getInventory().setResult(wand.getItem());
        }
    }

    @EventHandler
    public void onCraftItem(CraftItemEvent event) {
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        Mage spells = this.getMage(player);
        if (spells.hasStoredInventory()) {
            event.setCancelled(true);
            return;
        }
    }

    @EventHandler
    public void onInventoryOpen(InventoryOpenEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Mage mage = this.getMage(player);
        Wand wand = mage.getActiveWand();
        if (wand != null) {
            if (event.getView().getType() == InventoryType.CRAFTING) {
                wand.updateInventoryNames(false);
            } else {
                wand.deactivate();
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        InventoryType.SlotType slotType;
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        if (this.enchantingEnabled && event.getInventory().getType() == InventoryType.ENCHANTING && (slotType = event.getSlotType()) == InventoryType.SlotType.CRAFTING) {
            Wand wand;
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            if (Wand.isWand(cursor) && (wand = new Wand(this, cursor)).isModifiable()) {
                wand.makeEnchantable(true);
            }
            if (Wand.isWand(current) && (wand = new Wand(this, current)).isModifiable()) {
                wand.makeEnchantable(false);
            }
            return;
        }
        if (event.getInventory().getType() == InventoryType.ANVIL) {
            slotType = event.getSlotType();
            ItemStack cursor = event.getCursor();
            ItemStack current = event.getCurrentItem();
            Inventory anvilInventory = event.getInventory();
            if (slotType == InventoryType.SlotType.CRAFTING) {
                Wand wand;
                if (Wand.isWand(cursor)) {
                    wand = new Wand(this, cursor);
                    wand.updateName(false);
                }
                if (Wand.isWand(current)) {
                    wand = new Wand(this, current);
                    wand.updateName(true);
                }
                return;
            }
            if (slotType == InventoryType.SlotType.RESULT && Wand.isWand(current)) {
                ItemMeta meta = current.getItemMeta();
                String newName = meta.getDisplayName();
                Wand wand = new Wand(this, current);
                Player player = (Player)event.getWhoClicked();
                wand.takeOwnership(player, newName, true);
                if (this.organizingEnabled) {
                    wand.organizeInventory();
                }
                return;
            }
            if (this.combiningEnabled && slotType == InventoryType.SlotType.RESULT) {
                ItemStack firstItem = anvilInventory.getItem(0);
                ItemStack secondItem = anvilInventory.getItem(1);
                if (Wand.isWand(firstItem) && Wand.isWand(secondItem)) {
                    Wand firstWand = new Wand(this, firstItem);
                    Wand secondWand = new Wand(this, secondItem);
                    Player player = (Player)event.getWhoClicked();
                    if (!firstWand.isModifiable() || !secondWand.isModifiable()) {
                        player.sendMessage("One of your wands can not be combined");
                        return;
                    }
                    firstWand.takeOwnership(player, firstWand.getName(), true);
                    firstWand.add(secondWand);
                    anvilInventory.setItem(0, null);
                    anvilInventory.setItem(1, null);
                    cursor.setType(Material.AIR);
                    if (this.organizingEnabled) {
                        firstWand.organizeInventory();
                    }
                    player.getInventory().addItem(new ItemStack[]{firstWand.getItem()});
                    player.sendMessage("Your wands have been combined!");
                } else if (this.organizingEnabled && Wand.isWand(firstItem)) {
                    Wand firstWand = new Wand(this, firstItem);
                    Player player = (Player)event.getWhoClicked();
                    anvilInventory.setItem(0, null);
                    anvilInventory.setItem(1, null);
                    cursor.setType(Material.AIR);
                    firstWand.organizeInventory();
                    player.getInventory().addItem(new ItemStack[]{firstWand.getItem()});
                    player.sendMessage("Your wand has been organized!");
                }
                return;
            }
        }
        if (event.getInventory().getType() == InventoryType.CRAFTING) {
            Player player = (Player)event.getWhoClicked();
            Mage mage = this.getMage(player);
            Wand wand = mage.getActiveWand();
            if (wand != null && wand.isInventoryOpen()) {
                ItemStack clickedItem;
                if (event.getAction() == InventoryAction.PICKUP_HALF || event.getAction() == InventoryAction.NOTHING) {
                    wand.cycleInventory();
                    event.setCancelled(true);
                    return;
                }
                if (event.getSlotType() == InventoryType.SlotType.ARMOR) {
                    event.setCancelled(true);
                    return;
                }
                if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY && (clickedItem = event.getCurrentItem()) != null) {
                    this.onPlayerActivateIcon(mage, wand, clickedItem);
                    player.closeInventory();
                    event.setCancelled(true);
                    return;
                }
            }
            return;
        }
    }

    @EventHandler
    public void onInventoryClosed(InventoryCloseEvent event) {
        if (!(event.getPlayer() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getPlayer();
        Mage mage = this.getMage(player);
        Wand previousWand = mage.getActiveWand();
        if (previousWand != null && previousWand.isInventoryOpen()) {
            previousWand.saveInventory();
        }
        Wand wand = Wand.getActiveWand(this, player);
        boolean changedWands = false;
        if (previousWand != null && wand == null) {
            changedWands = true;
        }
        if (previousWand == null && wand != null) {
            changedWands = true;
        }
        if (previousWand != null && wand != null && !previousWand.equals(wand)) {
            changedWands = true;
        }
        if (changedWands) {
            if (previousWand != null) {
                previousWand.deactivate();
            }
            if (wand != null) {
                wand.activate(mage);
            }
        }
        if (previousWand != null && !changedWands && previousWand.isInventoryOpen()) {
            previousWand.updateInventoryNames(true);
        }
    }

    @EventHandler
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        Mage spells = this.getMage(event.getPlayer());
        ItemStack pickup = event.getItem().getItemStack();
        if (this.dynmapShowWands && Wand.isWand(pickup)) {
            Wand wand = new Wand(this, pickup);
            this.removeMarker("wand-" + wand.getId(), "Wands");
        }
        if (spells.hasStoredInventory()) {
            event.setCancelled(true);
            if (spells.addToStoredInventory(event.getItem().getItemStack())) {
                event.getItem().remove();
            }
        } else {
            PlayerInventory inventory = event.getPlayer().getInventory();
            ItemStack inHand = inventory.getItemInHand();
            if (Wand.isWand(pickup) && (inHand == null || inHand.getType() == Material.AIR)) {
                Wand wand = new Wand(this, pickup);
                event.setCancelled(true);
                event.getItem().remove();
                inventory.setItem(inventory.getHeldItemSlot(), pickup);
                wand.activate(spells);
            }
        }
    }

    @EventHandler
    public void onBlockPlace(BlockPlaceEvent event) {
        Player player = event.getPlayer();
        Mage spells = this.getMage(player);
        if (spells.hasStoredInventory() || spells.getBlockPlaceTimeout() > System.currentTimeMillis()) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        Player player = event.getPlayer();
        Mage spells = this.getMage(player);
        Wand activeWand = spells.getActiveWand();
        if (activeWand != null) {
            ItemStack inHand = event.getPlayer().getInventory().getItemInHand();
            if (Wand.isWand(event.getItemDrop().getItemStack()) && (inHand == null || inHand.getType() == Material.AIR)) {
                activeWand.deactivate();
                player.setItemInHand(new ItemStack(Material.AIR, 1));
            } else {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onEnchantItem(EnchantItemEvent event) {
        if (this.enchantingEnabled && Wand.isWand(event.getItem())) {
            event.getEnchantsToAdd().clear();
            int level = event.getExpLevelCost();
            Wand wand = new Wand(this, event.getItem());
            WandLevel.randomizeWand(wand, true, level);
        }
    }

    @EventHandler
    public void onPrepareEnchantItem(PrepareItemEnchantEvent event) {
        if (this.enchantingEnabled && Wand.isWand(event.getItem())) {
            Wand wandItem = new Wand(this, event.getItem());
            if (!wandItem.isModifiable()) {
                return;
            }
            Set<Integer> levelSet = WandLevel.getLevels();
            ArrayList<Integer> levels = new ArrayList<Integer>();
            levels.addAll(levelSet);
            int[] offered = event.getExpLevelCostsOffered();
            int bonusLevels = event.getEnchantmentBonus();
            int maxLevel = (Integer)levels.get(levels.size() - 1) - 20 + bonusLevels;
            int i = 0;
            while (i < offered.length - 1) {
                int levelIndex = (int)((float)i * (float)levels.size() / (float)offered.length);
                levelIndex = (int)((float)levelIndex + (float)bonusLevels * (float)((i + 1) / offered.length));
                levelIndex = Math.min(levelIndex, levels.size() - 1);
                offered[i] = (Integer)levels.get(levelIndex);
                ++i;
            }
            offered[offered.length - 1] = maxLevel;
            event.setCancelled(false);
        }
    }

    public WandChestPopulator getWandChestPopulator() {
        return new WandChestPopulator(this, this.blockPopulatorConfig);
    }

    @EventHandler
    public void onWorldInit(WorldInitEvent event) {
        if (this.blockPopulatorEnabled && this.blockPopulatorConfig != null) {
            World world = event.getWorld();
            world.getPopulators().add(this.getWandChestPopulator());
        }
    }

    protected boolean addWandMarker(Wand wand, Location location) {
        String description = wand.getHTMLDescription();
        return this.addMarker("wand-" + wand.getId(), "Wands", wand.getName(), location.getWorld().getName(), location.getBlockX(), location.getBlockY(), location.getBlockZ(), description);
    }

    protected void checkForWands(final Entity[] entities, final int retries) {
        if (this.dynmapShowWands && this.dynmap != null) {
            if (!this.dynmap.markerAPIInitialized()) {
                if (retries > 0) {
                    final MagicController me = this;
                    Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                        public void run() {
                            me.checkForWands(entities, retries + 1);
                        }
                    }, 40L);
                }
                return;
            }
            int wandCount = 0;
            Entity[] entityArray = entities;
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                Item item;
                ItemStack itemStack;
                Entity entity = entityArray[n2];
                if (entity instanceof Item && Wand.isWand(itemStack = (item = (Item)entity).getItemStack())) {
                    Wand wand = new Wand(this, itemStack);
                    wandCount += this.addWandMarker(wand, item.getLocation()) ? 1 : 0;
                }
                ++n2;
            }
            if (wandCount > 0) {
                this.getLogger().info("Found " + wandCount + " wands, added to map");
            }
        }
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent e) {
        final MagicController me = this;
        final ChunkLoadEvent event = e;
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

            public void run() {
                me.checkForWands(event.getChunk().getEntities(), 10);
            }
        }, 40L);
    }

    public Spell getSpell(String name) {
        return this.spells.get(name);
    }

    public void toggleCastCommandOverrides(Mage mage, boolean override) {
        mage.setCostReduction(override ? this.castCommandCostReduction : 0.0f);
        mage.setCooldownReduction(override ? this.castCommandCooldownReduction : 0.0f);
    }

    public static List<String> getPlayerNames() {
        ArrayList<String> playerNames = new ArrayList<String>();
        List worlds = Bukkit.getWorlds();
        for (World world : worlds) {
            List players = world.getPlayers();
            for (Player player : players) {
                playerNames.add(player.getName());
            }
        }
        return playerNames;
    }

    public boolean sendMail(CommandSender sender, String fromPlayer, String toPlayer, String message) {
        if (this.mailer != null) {
            return this.mailer.sendMail(sender, fromPlayer, toPlayer, message);
        }
        return false;
    }

    public Material getDefaultMaterial() {
        return this.defaultMaterial;
    }
}

