/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.Set;
import java.util.TreeSet;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class TunnelSpell
extends Spell {
    static final String DEFAULT_DESTRUCTIBLES = "1,3,10,11,12,13,87,88";
    private Set<Material> destructibleMaterials = new TreeSet<Material>();
    private int defaultDepth = 8;
    private int defaultWidth = 3;
    private int defaultHeight = 3;
    private int defaultSearchDistance = 32;
    private int torchFrequency = 4;

    public SpellResult onCast(ConfigurationNode parameters) {
        Block bottomBlock;
        this.destructibleMaterials = parameters.getMaterials("destructible", DEFAULT_DESTRUCTIBLES);
        this.defaultDepth = parameters.getInteger("depth", this.defaultDepth);
        this.defaultWidth = parameters.getInteger("width", this.defaultWidth);
        this.defaultHeight = parameters.getInteger("height", this.defaultHeight);
        this.defaultSearchDistance = parameters.getInteger("search_distance", this.defaultSearchDistance);
        this.torchFrequency = parameters.getInteger("torch_frequency", this.torchFrequency);
        Block playerBlock = this.getPlayerBlock();
        if (playerBlock == null) {
            this.castMessage("You need to be standing on something");
            return SpellResult.NO_TARGET;
        }
        if (!this.hasBuildPermission(playerBlock)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        BlockFace direction = this.getPlayerFacing();
        Block searchBlock = playerBlock.getRelative(BlockFace.UP).getRelative(BlockFace.UP);
        int searchDistance = 0;
        while (searchBlock.getType() == Material.AIR && searchDistance < this.defaultSearchDistance) {
            searchBlock = searchBlock.getRelative(direction);
            ++searchDistance;
        }
        int depth = this.defaultDepth;
        int height = this.defaultHeight;
        int width = this.defaultWidth;
        BlockList tunneledBlocks = new BlockList();
        BlockFace toTheLeft = TunnelSpell.goLeft(direction);
        BlockFace toTheRight = TunnelSpell.goRight(direction);
        Block bottomLeftBlock = bottomBlock = searchBlock.getRelative(BlockFace.DOWN);
        int i = 0;
        while (i < width / 2) {
            bottomLeftBlock = bottomLeftBlock.getRelative(toTheLeft);
            ++i;
        }
        Block targetBlock = bottomLeftBlock;
        int d = 0;
        while (d < depth) {
            bottomBlock = bottomLeftBlock;
            int w = 0;
            while (w < width) {
                targetBlock = bottomBlock;
                int h = 0;
                while (h < height) {
                    if (this.isDestructible(targetBlock) && !this.isIndestructible(targetBlock) && this.hasBuildPermission(targetBlock)) {
                        boolean useTorch = false;
                        tunneledBlocks.add(targetBlock);
                        if (useTorch) {
                            Block checkBlock = null;
                            checkBlock = w == 0 ? targetBlock.getRelative(toTheLeft) : targetBlock.getRelative(toTheRight);
                            if (checkBlock.getType() == Material.AIR) {
                                targetBlock.setType(Material.AIR);
                            } else {
                                targetBlock.setType(Material.TORCH);
                            }
                        } else {
                            targetBlock.setType(Material.AIR);
                        }
                    }
                    targetBlock = targetBlock.getRelative(BlockFace.UP);
                    ++h;
                }
                bottomBlock = bottomBlock.getRelative(toTheRight);
                ++w;
            }
            bottomLeftBlock = bottomLeftBlock.getRelative(direction);
            ++d;
        }
        this.controller.addToUndoQueue(this.getPlayer(), tunneledBlocks);
        this.castMessage("Tunneled through " + tunneledBlocks.size() + "blocks");
        return SpellResult.SUCCESS;
    }

    public boolean isDestructible(Block block) {
        if (block.getType() == Material.AIR) {
            return false;
        }
        return this.destructibleMaterials.contains(block.getType());
    }
}

