/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.URLMap;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Effect;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class CameraSpell
extends Spell {
    public SpellResult onCast(ConfigurationNode parameters) {
        String url;
        ItemStack newMapItem = null;
        Integer priority = parameters.getInteger("priority", null);
        if (parameters.containsKey("id")) {
            newMapItem = new ItemStack(Material.MAP, 1, (short)parameters.getInt("id", 0));
            String mapName = parameters.getString("name", "Image");
            ItemMeta meta = newMapItem.getItemMeta();
            meta.setDisplayName(mapName);
            newMapItem.setItemMeta(meta);
        }
        if (newMapItem == null && (url = parameters.getString("url")) != null) {
            int x = parameters.getInt("x", 0);
            int y = parameters.getInt("y", 0);
            int width = parameters.getInt("width", 0);
            int height = parameters.getInt("height", 0);
            String mapName = parameters.getString("name", "Photo");
            newMapItem = URLMap.getURLItem(url, x, y, width, height, mapName, priority);
        }
        if (newMapItem == null) {
            this.targetEntity(Player.class);
            Target target = this.getTarget();
            String playerName = parameters.getString("name");
            if (playerName == null) {
                Player targetPlayer = this.getPlayer();
                if (target != null && target.isEntity() && target.getEntity() instanceof Player) {
                    this.castMessage("CLICK!");
                    targetPlayer = (Player)target.getEntity();
                } else {
                    this.castMessage("Selfie!");
                }
                playerName = targetPlayer.getName();
            }
            if (parameters.containsKey("reload")) {
                URLMap.forceReloadPlayerPortrait(playerName);
            }
            newMapItem = URLMap.getPlayerPortrait(playerName, priority);
        }
        if (newMapItem == null) {
            this.sendMessage("Failed to load photo");
            return SpellResult.FAILURE;
        }
        this.getPlayer().getWorld().dropItemNaturally(this.getPlayer().getLocation(), newMapItem);
        this.getPlayer().getWorld().playEffect(this.getPlayer().getEyeLocation(), Effect.SMOKE, 0);
        return SpellResult.SUCCESS;
    }
}

