/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic;

import com.elmakers.mine.bukkit.utilities.borrowed.MaterialAndData;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class MaterialBrush
extends MaterialAndData {
    BrushMode mode = BrushMode.MATERIAL;
    Location cloneLocation = null;
    Location cloneTarget = null;
    Location materialTarget = null;

    public MaterialBrush(Material material, byte data) {
        super(material, data);
    }

    public void setMaterial(Material material) {
        this.material = material;
        this.data = 0;
        this.mode = BrushMode.MATERIAL;
    }

    public void setMaterial(Material material, byte data) {
        this.setMaterial(material);
        this.data = data;
    }

    public void enableCloning() {
        this.mode = BrushMode.CLONE;
    }

    public void enableReplication() {
        this.mode = BrushMode.REPLICATE;
    }

    public void setData(byte data) {
        this.data = data;
    }

    public void setCloneLocation(Location cloneFrom) {
        this.mode = BrushMode.CLONE;
        this.cloneLocation = cloneFrom;
        this.materialTarget = cloneFrom;
        this.cloneTarget = null;
    }

    public void enableCopying() {
        this.mode = BrushMode.COPY;
    }

    public boolean isReady() {
        if ((this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE) && this.materialTarget != null) {
            Block block = this.materialTarget.getBlock();
            return block.getChunk().isLoaded();
        }
        return true;
    }

    public void setTarget(Location target) {
        Block block;
        if (!(this.mode != BrushMode.REPLICATE && this.mode != BrushMode.CLONE || this.cloneTarget != null && this.mode != BrushMode.CLONE && target.getWorld().getName().equals(this.cloneTarget.getWorld().getName()))) {
            this.cloneTarget = target;
        }
        if (this.mode == BrushMode.COPY && (block = target.getBlock()).getChunk().isLoaded()) {
            this.material = block.getType();
            this.data = block.getData();
        }
    }

    public boolean update(Location target) {
        if (this.cloneLocation != null && (this.mode == BrushMode.CLONE || this.mode == BrushMode.REPLICATE)) {
            this.materialTarget = this.cloneLocation.clone();
            this.materialTarget.subtract(this.cloneTarget.toVector());
            this.materialTarget.add(target.toVector());
            Block block = this.materialTarget.getBlock();
            if (!block.getChunk().isLoaded()) {
                return false;
            }
            this.material = block.getType();
            this.data = block.getData();
        }
        return true;
    }

    public void prepare() {
        Block block;
        if (this.cloneLocation != null && !(block = this.cloneTarget.getBlock()).getChunk().isLoaded()) {
            block.getChunk().load(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum BrushMode {
        MATERIAL,
        COPY,
        CLONE,
        REPLICATE;

    }
}

