/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.blocks;

import com.elmakers.mine.bukkit.blocks.BlockList;
import com.elmakers.mine.bukkit.blocks.ConstructionType;
import com.elmakers.mine.bukkit.blocks.VolumeBatch;
import com.elmakers.mine.bukkit.plugins.magic.Mage;
import com.elmakers.mine.bukkit.plugins.magic.MaterialBrush;
import com.elmakers.mine.bukkit.plugins.magic.Spell;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.FallingBlock;
import org.bukkit.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstructBatch
extends VolumeBatch {
    private int timeToLive = 0;
    private final Set<Material> indestructible;
    private final BlockList constructedBlocks = new BlockList();
    private final Location center;
    private final int radius;
    private final MaterialBrush brush;
    private boolean checkDestructible = true;
    private final ConstructionType type;
    private final boolean fill;
    private final Mage playerSpells;
    private final Spell spell;
    private final String playerName;
    private final boolean spawnFallingBlocks;
    private Vector fallingBlockVelocity = null;
    private int x = 0;
    private int y = 0;
    private int z = 0;

    public ConstructBatch(Spell spell, Location center, ConstructionType type, int radius, boolean fill, MaterialBrush brush, Set<Material> indestructible, boolean spawnFallingBlocks) {
        super(spell.getMage().getController(), center.getWorld().getName());
        this.indestructible = indestructible;
        this.center = center;
        this.radius = radius;
        this.brush = brush;
        this.type = type;
        this.fill = fill;
        this.spawnFallingBlocks = spawnFallingBlocks;
        this.playerSpells = spell.getMage();
        this.spell = spell;
        this.playerName = this.playerSpells.getPlayer().getName();
    }

    public void setFallingBlockVelocity(Vector velocity) {
        this.fallingBlockVelocity = velocity;
    }

    @Override
    public int process(int maxBlocks) {
        int processedBlocks = 0;
        while (processedBlocks <= maxBlocks && this.x <= this.radius) {
            if (!this.fillBlock(this.x, this.y, this.z)) {
                return processedBlocks;
            }
            ++this.y;
            if (this.y > this.radius) {
                this.y = 0;
                ++this.z;
                if (this.z > this.radius) {
                    this.z = 0;
                    ++this.x;
                }
            }
            ++processedBlocks;
        }
        if (this.x > this.radius) {
            this.finish();
        }
        return processedBlocks;
    }

    @Override
    protected void finish() {
        super.finish();
        if (this.timeToLive == 0) {
            this.spells.addToUndoQueue(this.playerName, this.constructedBlocks);
        } else {
            this.constructedBlocks.setTimeToLive(this.timeToLive);
            this.spells.scheduleCleanup(this.playerName, this.constructedBlocks);
        }
        this.spell.castMessage("Constructed " + this.constructedBlocks.size() + " blocks");
    }

    public boolean fillBlock(int x, int y, int z) {
        boolean fillBlock = false;
        switch (this.type) {
            case SPHERE: {
                int maxDistanceSquared = this.radius * this.radius;
                float mx = (float)x - 0.5f;
                float my = (float)y - 0.5f;
                float mz = (float)z - 0.5f;
                int distanceSquared = (int)(mx * mx + my * my + mz * mz);
                if (this.fill) {
                    fillBlock = distanceSquared <= maxDistanceSquared;
                    break;
                }
                int outerDistanceSquared = (int)((mx += 1.0f) * mx + (my += 1.0f) * my + (mz += 1.0f) * mz);
                fillBlock = maxDistanceSquared >= distanceSquared && maxDistanceSquared <= outerDistanceSquared;
                break;
            }
            case PYRAMID: {
                int elevation = this.radius - y;
                if (this.fill) {
                    fillBlock = x <= elevation && z <= elevation;
                    break;
                }
                fillBlock = x == elevation && z <= elevation || z == elevation && x <= elevation;
                break;
            }
            default: {
                fillBlock = this.fill ? true : x == this.radius || y == this.radius || z == this.radius;
            }
        }
        boolean success = true;
        if (fillBlock) {
            success = success && this.constructBlock(x, y, z);
            success = success && this.constructBlock(-x, y, z);
            success = success && this.constructBlock(x, -y, z);
            success = success && this.constructBlock(x, y, -z);
            success = success && this.constructBlock(-x, -y, z);
            success = success && this.constructBlock(x, -y, -z);
            success = success && this.constructBlock(-x, y, -z);
            success = success && this.constructBlock(-x, -y, -z);
        }
        return success;
    }

    public int getDistanceSquared(int x, int y, int z) {
        return x * x + y * y + z * z;
    }

    public boolean constructBlock(int dx, int dy, int dz) {
        int x = this.center.getBlockX() + dx;
        int y = this.center.getBlockY() + dy;
        int z = this.center.getBlockZ() + dz;
        if (y < 0 || y > 255) {
            return true;
        }
        Block block = this.center.getWorld().getBlockAt(x, y, z);
        this.brush.update(block.getLocation());
        if (!block.getChunk().isLoaded()) {
            block.getChunk().load();
            return false;
        }
        if (!this.brush.isReady()) {
            this.brush.prepare();
            return false;
        }
        if (this.playerSpells.isIndestructible(block)) {
            return true;
        }
        if (this.checkDestructible && !this.isDestructible(block)) {
            return true;
        }
        if (!this.playerSpells.hasBuildPermission(block)) {
            return true;
        }
        Material previousMaterial = block.getType();
        byte previousData = block.getData();
        if (previousMaterial != this.brush.getMaterial() || previousData != this.brush.getData()) {
            this.updateBlock(this.center.getWorld().getName(), x, y, z);
            this.constructedBlocks.add(block);
            block.setType(this.brush.getMaterial());
            block.setData(this.brush.getData());
            if (this.spawnFallingBlocks) {
                FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation(), previousMaterial, previousData);
                falling.setDropItem(false);
                if (this.fallingBlockVelocity != null) {
                    falling.setVelocity(this.fallingBlockVelocity);
                }
            }
        }
        return true;
    }

    protected boolean isDestructible(Block block) {
        if (this.indestructible.isEmpty()) {
            return this.playerSpells.getController().getDestructibleMaterials().contains(block.getType());
        }
        return !this.indestructible.contains(block.getType());
    }

    public void setTimeToLive(int timeToLive) {
        this.timeToLive = timeToLive;
    }

    public void setCheckDestructible(boolean check) {
        this.checkDestructible = check;
    }
}

