/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import com.elmakers.mine.bukkit.dao.BlockList;
import com.elmakers.mine.bukkit.plugins.magic.CleanupBlocksTask;
import com.elmakers.mine.bukkit.plugins.magic.MagicPlugin;
import com.elmakers.mine.bukkit.plugins.magic.Spells;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.bukkit.Server;
import org.bukkit.block.Block;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitScheduler;

public class UndoQueue {
    private final LinkedList<BlockList> blockQueue = new LinkedList();
    private final Set<BlockList> scheduledBlocks = new HashSet<BlockList>();
    private int maxSize = 0;

    public void add(BlockList blocks) {
        if (this.maxSize > 0 && this.blockQueue.size() > this.maxSize) {
            this.blockQueue.removeFirst();
        }
        this.blockQueue.add(blocks);
    }

    public void scheduleCleanup(Spells spells, BlockList blocks) {
        this.scheduledBlocks.add(blocks);
        MagicPlugin plugin = spells.getPlugin();
        Server server = plugin.getServer();
        BukkitScheduler scheduler = server.getScheduler();
        long ticksToLive = blocks.getTimeToLive() * 20 / 1000;
        scheduler.scheduleSyncDelayedTask((Plugin)plugin, (Runnable)new CleanupBlocksTask(this, spells, blocks), ticksToLive);
    }

    public void removeScheduledCleanup(BlockList blockList) {
        this.scheduledBlocks.remove(blockList);
    }

    public BlockList getLast() {
        if (this.blockQueue.isEmpty()) {
            return null;
        }
        return this.blockQueue.getLast();
    }

    public BlockList getLast(Block target) {
        if (this.blockQueue.size() == 0) {
            return null;
        }
        for (BlockList blocks : this.blockQueue) {
            if (!blocks.contains(target)) continue;
            return blocks;
        }
        return null;
    }

    public void setMaxSize(int size) {
        this.maxSize = size;
    }

    public boolean undo(Spells spells) {
        if (this.blockQueue.size() == 0) {
            return false;
        }
        BlockList blocks = this.blockQueue.removeLast();
        blocks.undo(spells);
        return true;
    }

    public boolean undo(Spells spells, Block target) {
        BlockList lastActionOnTarget = this.getLast(target);
        if (lastActionOnTarget == null) {
            return false;
        }
        this.blockQueue.remove(lastActionOnTarget);
        lastActionOnTarget.undo(spells);
        return true;
    }

    public void load(Spells spells, ConfigurationNode node) {
        try {
            BlockList list;
            if (node == null) {
                return;
            }
            List<ConfigurationNode> nodeList = node.getNodeList("undo", null);
            for (ConfigurationNode listNode : nodeList) {
                list = new BlockList();
                list.load(listNode);
                this.blockQueue.add(list);
            }
            nodeList = node.getNodeList("scheduled", null);
            for (ConfigurationNode listNode : nodeList) {
                list = new BlockList();
                list.load(listNode);
                this.scheduleCleanup(spells, list);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            spells.getPlugin().getLogger().warning("Failed to load undo data: " + ex.getMessage());
        }
    }

    public void save(Spells spells, ConfigurationNode node) {
        try {
            HashMap<String, Object> listNode;
            ArrayList<HashMap<String, Object>> nodeList = new ArrayList<HashMap<String, Object>>();
            for (BlockList list : this.blockQueue) {
                listNode = new HashMap<String, Object>();
                list.save(listNode);
                nodeList.add(listNode);
            }
            node.setProperty("undo", nodeList);
            nodeList = new ArrayList();
            for (BlockList list : this.scheduledBlocks) {
                listNode = new HashMap();
                list.save(listNode);
                nodeList.add(listNode);
            }
            node.setProperty("scheduled", nodeList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            spells.getPlugin().getLogger().warning("Failed to save undo data: " + ex.getMessage());
        }
    }

    public int getSize() {
        return this.blockQueue.size();
    }

    public void commit() {
        this.blockQueue.clear();
    }
}

