/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.utilities;

import com.elmakers.mine.bukkit.dao.MaterialList;
import com.elmakers.mine.bukkit.plugins.magic.PlayerSpells;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.SimpleBlockAction;
import org.bukkit.Material;
import org.bukkit.block.Block;

public class ReplaceMaterialAction
extends SimpleBlockAction {
    protected PlayerSpells playerSpells;
    protected Material replace;
    protected byte replaceData;
    protected MaterialList replaceable = new MaterialList();

    public ReplaceMaterialAction(PlayerSpells playerSpells, Block targetBlock, Material replaceMaterial, byte replaceData) {
        this.playerSpells = playerSpells;
        this.replaceable.add(targetBlock.getType());
        this.replace = replaceMaterial;
        this.replaceData = replaceData;
    }

    public ReplaceMaterialAction(PlayerSpells playerSpells, Material replaceMaterial, byte replaceData) {
        this.playerSpells = playerSpells;
        this.replace = replaceMaterial;
        this.replaceData = replaceData;
    }

    public void addReplaceable(Material material) {
        this.replaceable.add(material);
    }

    public SpellResult perform(Block block) {
        if (this.replace == null) {
            return SpellResult.FAILURE;
        }
        if (!this.playerSpells.hasBuildPermission(block)) {
            return SpellResult.INSUFFICIENT_PERMISSION;
        }
        if (this.playerSpells.isIndestructible(block)) {
            return SpellResult.FAILURE;
        }
        if (this.replaceable == null || this.replaceable.contains(block.getType())) {
            block.setType(this.replace);
            block.setData(this.replaceData);
            super.perform(block);
            return SpellResult.SUCCESS;
        }
        return SpellResult.FAILURE;
    }
}

