/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.plugins.magic.Target;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Wolf;

public class WolfSpell
extends Spell {
    private static int DEFAULT_MAX_WOLVES = 5;
    protected List<Wolf> wolves = new ArrayList<Wolf>();

    public Wolf newWolf(Target target) {
        Wolf entity;
        if (target == null) {
            this.castMessage("No target");
            return null;
        }
        Block targetBlock = target.getBlock();
        targetBlock = targetBlock.getRelative(BlockFace.UP);
        if (target.isEntity()) {
            targetBlock = targetBlock.getRelative(BlockFace.SOUTH);
        }
        if ((entity = (Wolf)this.player.getWorld().spawnEntity(targetBlock.getLocation(), EntityType.WOLF)) == null) {
            this.sendMessage("Your wolfie is DOA");
            return null;
        }
        this.tameWolf(entity);
        this.castMessage("You summon a wolfie!");
        return entity;
    }

    public SpellResult onCast(ConfigurationNode parameters) {
        Wolf wolf;
        this.targetEntity(LivingEntity.class);
        Target target = this.getTarget();
        if (target == null) {
            return SpellResult.NO_TARGET;
        }
        ArrayList<Wolf> newWolves = new ArrayList<Wolf>();
        for (Wolf wolf2 : this.wolves) {
            if (wolf2.isDead()) continue;
            newWolves.add(wolf2);
        }
        this.wolves = newWolves;
        int maxWolves = parameters.getInt("max_wolves", DEFAULT_MAX_WOLVES);
        int scaledMaxWolves = (int)(this.playerSpells.getRadiusMultiplier() * (float)maxWolves);
        if (this.wolves.size() >= scaledMaxWolves) {
            Wolf killWolf = this.wolves.remove(0);
            killWolf.setHealth(0.0);
        }
        if ((wolf = this.newWolf(target)) == null) {
            return SpellResult.NO_TARGET;
        }
        this.wolves.add(wolf);
        Entity e = target.getEntity();
        if (e != null && e instanceof LivingEntity) {
            LivingEntity targetEntity = (LivingEntity)e;
            for (Wolf w : this.wolves) {
                w.setTarget(targetEntity);
                w.setAngry(true);
            }
        }
        return SpellResult.SUCCESS;
    }

    protected void tameWolf(Wolf wolfie) {
        wolfie.setAngry(false);
        wolfie.setHealth(8.0);
        wolfie.setTamed(true);
        wolfie.setOwner((AnimalTamer)this.player);
    }
}

