/*
 * Decompiled with CFR 0.152.
 */
package com.elmakers.mine.bukkit.plugins.magic.spells;

import com.elmakers.mine.bukkit.plugins.magic.Spell;
import com.elmakers.mine.bukkit.plugins.magic.SpellResult;
import com.elmakers.mine.bukkit.utilities.EffectUtils;
import com.elmakers.mine.bukkit.utilities.ParticleType;
import com.elmakers.mine.bukkit.utilities.borrowed.ConfigurationNode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class RecallSpell
extends Spell {
    public Location location;
    public boolean isActive;
    private int disableDistance = 5;

    public SpellResult onCast(ConfigurationNode parameters) {
        boolean autoResurrect = parameters.getBoolean("auto_resurrect", true);
        boolean autoSpawn = parameters.getBoolean("allow_spawn", true);
        String typeString = parameters.getString("type", "");
        if (typeString.equals("spawn")) {
            this.castMessage("Returning you home");
            this.player.teleport(this.tryFindPlaceToStand(this.player.getWorld().getSpawnLocation()));
            return SpellResult.SUCCESS;
        }
        if (typeString.equals("death") || this.getYRotation() < -70.0 && autoResurrect) {
            Location deathLocation = this.playerSpells.getLastDeathLocation();
            if (deathLocation == null) {
                return SpellResult.NO_TARGET;
            }
            this.player.teleport(this.tryFindPlaceToStand(deathLocation));
            return SpellResult.SUCCESS;
        }
        if (this.getYRotation() > 70.0) {
            if (!this.isActive && autoSpawn) {
                this.castMessage("Returning you home");
                this.player.teleport(this.tryFindPlaceToStand(this.player.getWorld().getSpawnLocation()));
            } else {
                if (!this.isActive) {
                    return SpellResult.NO_TARGET;
                }
                double distanceSquared = this.player.getLocation().distanceSquared(this.location);
                if (distanceSquared < (double)(this.disableDistance * this.disableDistance) && autoSpawn) {
                    this.castMessage("Returning you home");
                    this.player.teleport(this.tryFindPlaceToStand(this.player.getWorld().getSpawnLocation()));
                } else {
                    this.castMessage("Returning you to your marker");
                    this.player.teleport(this.location);
                }
            }
            return SpellResult.SUCCESS;
        }
        if (!this.isActive) {
            return this.placeMarker(this.getTargetBlock());
        }
        return this.placeMarker(this.getTargetBlock());
    }

    protected boolean removeMarker() {
        if (!this.isActive || this.location == null) {
            return false;
        }
        this.isActive = false;
        return true;
    }

    protected SpellResult placeMarker(Block target) {
        if (target == null) {
            this.castMessage("No target");
            return SpellResult.NO_TARGET;
        }
        Block targetBlock = target.getRelative(BlockFace.UP);
        if (targetBlock.getType() != Material.AIR) {
            targetBlock = this.getFaceBlock();
        }
        if (targetBlock.getType() != Material.AIR) {
            this.castMessage("Can't place a marker there");
            return SpellResult.NO_TARGET;
        }
        if (this.removeMarker()) {
            this.castMessage("You move your recall marker");
        } else {
            this.castMessage("You place a recall marker");
        }
        this.location = this.player.getLocation();
        this.location.setX((double)targetBlock.getX());
        this.location.setY((double)targetBlock.getY());
        this.location.setZ((double)targetBlock.getZ());
        this.player.setCompassTarget(this.location);
        EffectUtils.playEffect(targetBlock.getLocation(), ParticleType.CLOUD, 1.0f, 1);
        this.isActive = true;
        return SpellResult.SUCCESS;
    }

    public void onLoad(ConfigurationNode node) {
        this.isActive = node.getBoolean("active", false);
        this.location = node.getLocation("location");
    }

    public void onSave(ConfigurationNode node) {
        node.setProperty("active", this.isActive);
        node.setProperty("location", this.location);
    }
}

